/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLastAccessedDetailsWithEntitiesResponse extends IamResponse
        implements
        ToCopyableBuilder<GetServiceLastAccessedDetailsWithEntitiesResponse.Builder, GetServiceLastAccessedDetailsWithEntitiesResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobCreationDate").getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobCreationDate))
            .setter(setter(Builder::jobCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()).build();

    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobCompletionDate").getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobCompletionDate))
            .setter(setter(Builder::jobCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()).build();

    private static final SdkField<List<EntityDetails>> ENTITY_DETAILS_LIST_FIELD = SdkField
            .<List<EntityDetails>> builder(MarshallingType.LIST)
            .memberName("EntityDetailsList")
            .getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::entityDetailsList))
            .setter(setter(Builder::entityDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(GetServiceLastAccessedDetailsWithEntitiesResponse::error))
            .setter(setter(Builder::error)).constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            JOB_CREATION_DATE_FIELD, JOB_COMPLETION_DATE_FIELD, ENTITY_DETAILS_LIST_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobStatus", JOB_STATUS_FIELD);
                    put("JobCreationDate", JOB_CREATION_DATE_FIELD);
                    put("JobCompletionDate", JOB_COMPLETION_DATE_FIELD);
                    put("EntityDetailsList", ENTITY_DETAILS_LIST_FIELD);
                    put("IsTruncated", IS_TRUNCATED_FIELD);
                    put("Marker", MARKER_FIELD);
                    put("Error", ERROR_FIELD);
                }
            });

    private final String jobStatus;

    private final Instant jobCreationDate;

    private final Instant jobCompletionDate;

    private final List<EntityDetails> entityDetailsList;

    private final Boolean isTruncated;

    private final String marker;

    private final ErrorDetails error;

    private GetServiceLastAccessedDetailsWithEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.entityDetailsList = builder.entityDetailsList;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.error = builder.error;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public final JobStatusType jobStatus() {
        return JobStatusType.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job
     * was created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         report job was created.
     */
    public final Instant jobCreationDate() {
        return jobCreationDate;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated
     * report job was completed or failed.
     * </p>
     * <p>
     * This field is null if the job is still in progress, as indicated by a job status value of
     * <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         generated report job was completed or failed.</p>
     *         <p>
     *         This field is null if the job is still in progress, as indicated by a job status value of
     *         <code>IN_PROGRESS</code>.
     */
    public final Instant jobCompletionDate() {
        return jobCompletionDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityDetailsList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityDetailsList() {
        return entityDetailsList != null && !(entityDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group
     * or policy permissions in an attempt to access the specified Amazon Web Services service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityDetailsList} method.
     * </p>
     * 
     * @return An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role)
     *         used group or policy permissions in an attempt to access the specified Amazon Web Services service.
     */
    public final List<EntityDetails> entityDetailsList() {
        return entityDetailsList;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * An object that contains details about the reason the operation failed.
     * </p>
     * 
     * @return An object that contains details about the reason the operation failed.
     */
    public final ErrorDetails error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityDetailsList() ? entityDetailsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsWithEntitiesResponse)) {
            return false;
        }
        GetServiceLastAccessedDetailsWithEntitiesResponse other = (GetServiceLastAccessedDetailsWithEntitiesResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobCreationDate(), other.jobCreationDate())
                && Objects.equals(jobCompletionDate(), other.jobCompletionDate())
                && hasEntityDetailsList() == other.hasEntityDetailsList()
                && Objects.equals(entityDetailsList(), other.entityDetailsList())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceLastAccessedDetailsWithEntitiesResponse").add("JobStatus", jobStatusAsString())
                .add("JobCreationDate", jobCreationDate()).add("JobCompletionDate", jobCompletionDate())
                .add("EntityDetailsList", hasEntityDetailsList() ? entityDetailsList() : null).add("IsTruncated", isTruncated())
                .add("Marker", marker()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "JobCreationDate":
            return Optional.ofNullable(clazz.cast(jobCreationDate()));
        case "JobCompletionDate":
            return Optional.ofNullable(clazz.cast(jobCompletionDate()));
        case "EntityDetailsList":
            return Optional.ofNullable(clazz.cast(entityDetailsList()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsWithEntitiesResponse, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsWithEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLastAccessedDetailsWithEntitiesResponse> {
        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(JobStatusType jobStatus);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report
         * job was created.
         * </p>
         * 
         * @param jobCreationDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        report job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCreationDate(Instant jobCreationDate);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         * generated report job was completed or failed.
         * </p>
         * <p>
         * This field is null if the job is still in progress, as indicated by a job status value of
         * <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param jobCompletionDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        generated report job was completed or failed.</p>
         *        <p>
         *        This field is null if the job is still in progress, as indicated by a job status value of
         *        <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCompletionDate(Instant jobCompletionDate);

        /**
         * <p>
         * An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used
         * group or policy permissions in an attempt to access the specified Amazon Web Services service.
         * </p>
         * 
         * @param entityDetailsList
         *        An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role)
         *        used group or policy permissions in an attempt to access the specified Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityDetailsList(Collection<EntityDetails> entityDetailsList);

        /**
         * <p>
         * An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used
         * group or policy permissions in an attempt to access the specified Amazon Web Services service.
         * </p>
         * 
         * @param entityDetailsList
         *        An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role)
         *        used group or policy permissions in an attempt to access the specified Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityDetailsList(EntityDetails... entityDetailsList);

        /**
         * <p>
         * An <code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used
         * group or policy permissions in an attempt to access the specified Amazon Web Services service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.EntityDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.EntityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.EntityDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #entityDetailsList(List<EntityDetails>)}.
         * 
         * @param entityDetailsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.EntityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityDetailsList(java.util.Collection<EntityDetails>)
         */
        Builder entityDetailsList(Consumer<EntityDetails.Builder>... entityDetailsList);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An object that contains details about the reason the operation failed.
         * </p>
         * 
         * @param error
         *        An object that contains details about the reason the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetails error);

        /**
         * <p>
         * An object that contains details about the reason the operation failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetails)
         */
        default Builder error(Consumer<ErrorDetails.Builder> error) {
            return error(ErrorDetails.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private Instant jobCreationDate;

        private Instant jobCompletionDate;

        private List<EntityDetails> entityDetailsList = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private ErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsWithEntitiesResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            jobCreationDate(model.jobCreationDate);
            jobCompletionDate(model.jobCompletionDate);
            entityDetailsList(model.entityDetailsList);
            isTruncated(model.isTruncated);
            marker(model.marker);
            error(model.error);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getJobCreationDate() {
            return jobCreationDate;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final Instant getJobCompletionDate() {
            return jobCompletionDate;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final List<EntityDetails.Builder> getEntityDetailsList() {
            List<EntityDetails.Builder> result = _entityDetailsListTypeCopier.copyToBuilder(this.entityDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityDetailsList(Collection<EntityDetails.BuilderImpl> entityDetailsList) {
            this.entityDetailsList = _entityDetailsListTypeCopier.copyFromBuilder(entityDetailsList);
        }

        @Override
        public final Builder entityDetailsList(Collection<EntityDetails> entityDetailsList) {
            this.entityDetailsList = _entityDetailsListTypeCopier.copy(entityDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityDetailsList(EntityDetails... entityDetailsList) {
            entityDetailsList(Arrays.asList(entityDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityDetailsList(Consumer<EntityDetails.Builder>... entityDetailsList) {
            entityDetailsList(Stream.of(entityDetailsList).map(c -> EntityDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        @Override
        public GetServiceLastAccessedDetailsWithEntitiesResponse build() {
            return new GetServiceLastAccessedDetailsWithEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
