/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListSigningCertificates</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningCertificatesResponse extends IamResponse implements
        ToCopyableBuilder<ListSigningCertificatesResponse.Builder, ListSigningCertificatesResponse> {
    private static final SdkField<List<SigningCertificate>> CERTIFICATES_FIELD = SdkField
            .<List<SigningCertificate>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(ListSigningCertificatesResponse::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigningCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigningCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListSigningCertificatesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListSigningCertificatesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATES_FIELD,
            IS_TRUNCATED_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Certificates", CERTIFICATES_FIELD);
                    put("IsTruncated", IS_TRUNCATED_FIELD);
                    put("Marker", MARKER_FIELD);
                }
            });

    private final List<SigningCertificate> certificates;

    private final Boolean isTruncated;

    private final String marker;

    private ListSigningCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Certificates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the user's signing certificate information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificates} method.
     * </p>
     * 
     * @return A list of the user's signing certificate information.
     */
    public final List<SigningCertificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningCertificatesResponse)) {
            return false;
        }
        ListSigningCertificatesResponse other = (ListSigningCertificatesResponse) obj;
        return hasCertificates() == other.hasCertificates() && Objects.equals(certificates(), other.certificates())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSigningCertificatesResponse").add("Certificates", hasCertificates() ? certificates() : null)
                .add("IsTruncated", isTruncated()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningCertificatesResponse, T> g) {
        return obj -> g.apply((ListSigningCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningCertificatesResponse> {
        /**
         * <p>
         * A list of the user's signing certificate information.
         * </p>
         * 
         * @param certificates
         *        A list of the user's signing certificate information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<SigningCertificate> certificates);

        /**
         * <p>
         * A list of the user's signing certificate information.
         * </p>
         * 
         * @param certificates
         *        A list of the user's signing certificate information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(SigningCertificate... certificates);

        /**
         * <p>
         * A list of the user's signing certificate information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.SigningCertificate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.SigningCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.SigningCertificate.Builder#build()} is called immediately
         * and its result is passed to {@link #certificates(List<SigningCertificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.SigningCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(java.util.Collection<SigningCertificate>)
         */
        Builder certificates(Consumer<SigningCertificate.Builder>... certificates);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<SigningCertificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningCertificatesResponse model) {
            super(model);
            certificates(model.certificates);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final List<SigningCertificate.Builder> getCertificates() {
            List<SigningCertificate.Builder> result = _certificateListTypeCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<SigningCertificate.BuilderImpl> certificates) {
            this.certificates = _certificateListTypeCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<SigningCertificate> certificates) {
            this.certificates = _certificateListTypeCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(SigningCertificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<SigningCertificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> SigningCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListSigningCertificatesResponse build() {
            return new ListSigningCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
