/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the permissions policies that are attached to the specified identity (user, group, or role).
 * </p>
 * <p>
 * This data type is an element of the <a>ListPoliciesGrantingServiceAccessEntry</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyGrantingServiceAccess implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyGrantingServiceAccess.Builder, PolicyGrantingServiceAccess> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PolicyGrantingServiceAccess::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(PolicyGrantingServiceAccess::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(PolicyGrantingServiceAccess::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(PolicyGrantingServiceAccess::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityName").getter(getter(PolicyGrantingServiceAccess::entityName)).setter(setter(Builder::entityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_TYPE_FIELD, POLICY_ARN_FIELD, ENTITY_TYPE_FIELD, ENTITY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PolicyName", POLICY_NAME_FIELD);
                    put("PolicyType", POLICY_TYPE_FIELD);
                    put("PolicyArn", POLICY_ARN_FIELD);
                    put("EntityType", ENTITY_TYPE_FIELD);
                    put("EntityName", ENTITY_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String policyType;

    private final String policyArn;

    private final String entityType;

    private final String entityName;

    private PolicyGrantingServiceAccess(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.policyArn = builder.policyArn;
        this.entityType = builder.entityType;
        this.entityName = builder.entityName;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy type. For more information about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type. For more information about these policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     *         policies and inline policies</a> in the <i>IAM User Guide</i>.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The policy type. For more information about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type. For more information about these policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     *         policies and inline policies</a> in the <i>IAM User Guide</i>.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * Returns the value of the PolicyArn property for this object.
     * 
     * @return The value of the PolicyArn property for this object.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The type of entity (user or role) that used the policy to access the service to which the inline policy is
     * attached.
     * </p>
     * <p>
     * This field is null for managed policies. For more information about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link PolicyOwnerEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of entity (user or role) that used the policy to access the service to which the inline policy
     *         is attached.</p>
     *         <p>
     *         This field is null for managed policies. For more information about these policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     *         policies and inline policies</a> in the <i>IAM User Guide</i>.
     * @see PolicyOwnerEntityType
     */
    public final PolicyOwnerEntityType entityType() {
        return PolicyOwnerEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of entity (user or role) that used the policy to access the service to which the inline policy is
     * attached.
     * </p>
     * <p>
     * This field is null for managed policies. For more information about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link PolicyOwnerEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of entity (user or role) that used the policy to access the service to which the inline policy
     *         is attached.</p>
     *         <p>
     *         This field is null for managed policies. For more information about these policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     *         policies and inline policies</a> in the <i>IAM User Guide</i>.
     * @see PolicyOwnerEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The name of the entity (user or role) to which the inline policy is attached.
     * </p>
     * <p>
     * This field is null for managed policies. For more information about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The name of the entity (user or role) to which the inline policy is attached.</p>
     *         <p>
     *         This field is null for managed policies. For more information about these policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
     *         policies and inline policies</a> in the <i>IAM User Guide</i>.
     */
    public final String entityName() {
        return entityName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entityName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantingServiceAccess)) {
            return false;
        }
        PolicyGrantingServiceAccess other = (PolicyGrantingServiceAccess) obj;
        return Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(entityName(), other.entityName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyGrantingServiceAccess").add("PolicyName", policyName())
                .add("PolicyType", policyTypeAsString()).add("PolicyArn", policyArn()).add("EntityType", entityTypeAsString())
                .add("EntityName", entityName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "EntityName":
            return Optional.ofNullable(clazz.cast(entityName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantingServiceAccess, T> g) {
        return obj -> g.apply((PolicyGrantingServiceAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyGrantingServiceAccess> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy type. For more information about these policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param policyType
         *        The policy type. For more information about these policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         *        policies and inline policies</a> in the <i>IAM User Guide</i>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The policy type. For more information about these policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param policyType
         *        The policy type. For more information about these policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         *        policies and inline policies</a> in the <i>IAM User Guide</i>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * Sets the value of the PolicyArn property for this object.
         *
         * @param policyArn
         *        The new value for the PolicyArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The type of entity (user or role) that used the policy to access the service to which the inline policy is
         * attached.
         * </p>
         * <p>
         * This field is null for managed policies. For more information about these policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param entityType
         *        The type of entity (user or role) that used the policy to access the service to which the inline
         *        policy is attached.</p>
         *        <p>
         *        This field is null for managed policies. For more information about these policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         *        policies and inline policies</a> in the <i>IAM User Guide</i>.
         * @see PolicyOwnerEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyOwnerEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of entity (user or role) that used the policy to access the service to which the inline policy is
         * attached.
         * </p>
         * <p>
         * This field is null for managed policies. For more information about these policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param entityType
         *        The type of entity (user or role) that used the policy to access the service to which the inline
         *        policy is attached.</p>
         *        <p>
         *        This field is null for managed policies. For more information about these policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         *        policies and inline policies</a> in the <i>IAM User Guide</i>.
         * @see PolicyOwnerEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyOwnerEntityType
         */
        Builder entityType(PolicyOwnerEntityType entityType);

        /**
         * <p>
         * The name of the entity (user or role) to which the inline policy is attached.
         * </p>
         * <p>
         * This field is null for managed policies. For more information about these policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         * policies and inline policies</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param entityName
         *        The name of the entity (user or role) to which the inline policy is attached.</p>
         *        <p>
         *        This field is null for managed policies. For more information about these policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
         *        policies and inline policies</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityName(String entityName);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyType;

        private String policyArn;

        private String entityType;

        private String entityName;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantingServiceAccess model) {
            policyName(model.policyName);
            policyType(model.policyType);
            policyArn(model.policyArn);
            entityType(model.entityType);
            entityName(model.entityName);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(PolicyOwnerEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getEntityName() {
            return entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        @Override
        public PolicyGrantingServiceAccess build() {
            return new PolicyGrantingServiceAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
