/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResyncMfaDeviceRequest extends IamRequest implements
        ToCopyableBuilder<ResyncMfaDeviceRequest.Builder, ResyncMfaDeviceRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(ResyncMfaDeviceRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(ResyncMfaDeviceRequest::serialNumber))
            .setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<String> AUTHENTICATION_CODE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationCode1").getter(getter(ResyncMfaDeviceRequest::authenticationCode1))
            .setter(setter(Builder::authenticationCode1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationCode1").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_CODE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationCode2").getter(getter(ResyncMfaDeviceRequest::authenticationCode2))
            .setter(setter(Builder::authenticationCode2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationCode2").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            SERIAL_NUMBER_FIELD, AUTHENTICATION_CODE1_FIELD, AUTHENTICATION_CODE2_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserName", USER_NAME_FIELD);
                    put("SerialNumber", SERIAL_NUMBER_FIELD);
                    put("AuthenticationCode1", AUTHENTICATION_CODE1_FIELD);
                    put("AuthenticationCode2", AUTHENTICATION_CODE2_FIELD);
                }
            });

    private final String userName;

    private final String serialNumber;

    private final String authenticationCode1;

    private final String authenticationCode2;

    private ResyncMfaDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.authenticationCode1 = builder.authenticationCode1;
        this.authenticationCode2 = builder.authenticationCode2;
    }

    /**
     * <p>
     * The name of the user whose MFA device you want to resynchronize.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the user whose MFA device you want to resynchronize.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Serial number that uniquely identifies the MFA device.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return Serial number that uniquely identifies the MFA device.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * An authentication code emitted by the device.
     * </p>
     * <p>
     * The format for this parameter is a sequence of six digits.
     * </p>
     * 
     * @return An authentication code emitted by the device.</p>
     *         <p>
     *         The format for this parameter is a sequence of six digits.
     */
    public final String authenticationCode1() {
        return authenticationCode1;
    }

    /**
     * <p>
     * A subsequent authentication code emitted by the device.
     * </p>
     * <p>
     * The format for this parameter is a sequence of six digits.
     * </p>
     * 
     * @return A subsequent authentication code emitted by the device.</p>
     *         <p>
     *         The format for this parameter is a sequence of six digits.
     */
    public final String authenticationCode2() {
        return authenticationCode2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationCode1());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationCode2());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResyncMfaDeviceRequest)) {
            return false;
        }
        ResyncMfaDeviceRequest other = (ResyncMfaDeviceRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(authenticationCode1(), other.authenticationCode1())
                && Objects.equals(authenticationCode2(), other.authenticationCode2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResyncMfaDeviceRequest").add("UserName", userName()).add("SerialNumber", serialNumber())
                .add("AuthenticationCode1", authenticationCode1()).add("AuthenticationCode2", authenticationCode2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "AuthenticationCode1":
            return Optional.ofNullable(clazz.cast(authenticationCode1()));
        case "AuthenticationCode2":
            return Optional.ofNullable(clazz.cast(authenticationCode2()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResyncMfaDeviceRequest, T> g) {
        return obj -> g.apply((ResyncMfaDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResyncMfaDeviceRequest> {
        /**
         * <p>
         * The name of the user whose MFA device you want to resynchronize.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param userName
         *        The name of the user whose MFA device you want to resynchronize.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Serial number that uniquely identifies the MFA device.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param serialNumber
         *        Serial number that uniquely identifies the MFA device.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * An authentication code emitted by the device.
         * </p>
         * <p>
         * The format for this parameter is a sequence of six digits.
         * </p>
         * 
         * @param authenticationCode1
         *        An authentication code emitted by the device.</p>
         *        <p>
         *        The format for this parameter is a sequence of six digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationCode1(String authenticationCode1);

        /**
         * <p>
         * A subsequent authentication code emitted by the device.
         * </p>
         * <p>
         * The format for this parameter is a sequence of six digits.
         * </p>
         * 
         * @param authenticationCode2
         *        A subsequent authentication code emitted by the device.</p>
         *        <p>
         *        The format for this parameter is a sequence of six digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationCode2(String authenticationCode2);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String userName;

        private String serialNumber;

        private String authenticationCode1;

        private String authenticationCode2;

        private BuilderImpl() {
        }

        private BuilderImpl(ResyncMfaDeviceRequest model) {
            super(model);
            userName(model.userName);
            serialNumber(model.serialNumber);
            authenticationCode1(model.authenticationCode1);
            authenticationCode2(model.authenticationCode2);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getAuthenticationCode1() {
            return authenticationCode1;
        }

        public final void setAuthenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
        }

        @Override
        public final Builder authenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
            return this;
        }

        public final String getAuthenticationCode2() {
            return authenticationCode2;
        }

        public final void setAuthenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
        }

        @Override
        public final Builder authenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResyncMfaDeviceRequest build() {
            return new ResyncMfaDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
