/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a server certificate.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetServerCertificate</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerCertificate.Builder, ServerCertificate> {
    private static final SdkField<ServerCertificateMetadata> SERVER_CERTIFICATE_METADATA_FIELD = SdkField
            .<ServerCertificateMetadata> builder(MarshallingType.SDK_POJO).memberName("ServerCertificateMetadata")
            .getter(getter(ServerCertificate::serverCertificateMetadata)).setter(setter(Builder::serverCertificateMetadata))
            .constructor(ServerCertificateMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateMetadata").build())
            .build();

    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateBody").getter(getter(ServerCertificate::certificateBody))
            .setter(setter(Builder::certificateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBody").build()).build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateChain").getter(getter(ServerCertificate::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ServerCertificate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVER_CERTIFICATE_METADATA_FIELD, CERTIFICATE_BODY_FIELD, CERTIFICATE_CHAIN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ServerCertificateMetadata", SERVER_CERTIFICATE_METADATA_FIELD);
                    put("CertificateBody", CERTIFICATE_BODY_FIELD);
                    put("CertificateChain", CERTIFICATE_CHAIN_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ServerCertificateMetadata serverCertificateMetadata;

    private final String certificateBody;

    private final String certificateChain;

    private final List<Tag> tags;

    private ServerCertificate(BuilderImpl builder) {
        this.serverCertificateMetadata = builder.serverCertificateMetadata;
        this.certificateBody = builder.certificateBody;
        this.certificateChain = builder.certificateChain;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The meta information of the server certificate, such as its name, path, ID, and ARN.
     * </p>
     * 
     * @return The meta information of the server certificate, such as its name, path, ID, and ARN.
     */
    public final ServerCertificateMetadata serverCertificateMetadata() {
        return serverCertificateMetadata;
    }

    /**
     * <p>
     * The contents of the public key certificate.
     * </p>
     * 
     * @return The contents of the public key certificate.
     */
    public final String certificateBody() {
        return certificateBody;
    }

    /**
     * <p>
     * The contents of the public key certificate chain.
     * </p>
     * 
     * @return The contents of the public key certificate chain.
     */
    public final String certificateChain() {
        return certificateChain;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that are attached to the server certificate. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that are attached to the server certificate. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificate)) {
            return false;
        }
        ServerCertificate other = (ServerCertificate) obj;
        return Objects.equals(serverCertificateMetadata(), other.serverCertificateMetadata())
                && Objects.equals(certificateBody(), other.certificateBody())
                && Objects.equals(certificateChain(), other.certificateChain()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerCertificate").add("ServerCertificateMetadata", serverCertificateMetadata())
                .add("CertificateBody", certificateBody()).add("CertificateChain", certificateChain())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificateMetadata":
            return Optional.ofNullable(clazz.cast(serverCertificateMetadata()));
        case "CertificateBody":
            return Optional.ofNullable(clazz.cast(certificateBody()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificate, T> g) {
        return obj -> g.apply((ServerCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerCertificate> {
        /**
         * <p>
         * The meta information of the server certificate, such as its name, path, ID, and ARN.
         * </p>
         * 
         * @param serverCertificateMetadata
         *        The meta information of the server certificate, such as its name, path, ID, and ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateMetadata(ServerCertificateMetadata serverCertificateMetadata);

        /**
         * <p>
         * The meta information of the server certificate, such as its name, path, ID, and ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerCertificateMetadata.Builder}
         * avoiding the need to create one manually via {@link ServerCertificateMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerCertificateMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #serverCertificateMetadata(ServerCertificateMetadata)}.
         * 
         * @param serverCertificateMetadata
         *        a consumer that will call methods on {@link ServerCertificateMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificateMetadata(ServerCertificateMetadata)
         */
        default Builder serverCertificateMetadata(Consumer<ServerCertificateMetadata.Builder> serverCertificateMetadata) {
            return serverCertificateMetadata(ServerCertificateMetadata.builder().applyMutation(serverCertificateMetadata).build());
        }

        /**
         * <p>
         * The contents of the public key certificate.
         * </p>
         * 
         * @param certificateBody
         *        The contents of the public key certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBody(String certificateBody);

        /**
         * <p>
         * The contents of the public key certificate chain.
         * </p>
         * 
         * @param certificateChain
         *        The contents of the public key certificate chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        /**
         * <p>
         * A list of tags that are attached to the server certificate. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the server certificate. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that are attached to the server certificate. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the server certificate. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that are attached to the server certificate. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iam.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iam.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iam.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private ServerCertificateMetadata serverCertificateMetadata;

        private String certificateBody;

        private String certificateChain;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificate model) {
            serverCertificateMetadata(model.serverCertificateMetadata);
            certificateBody(model.certificateBody);
            certificateChain(model.certificateChain);
            tags(model.tags);
        }

        public final ServerCertificateMetadata.Builder getServerCertificateMetadata() {
            return serverCertificateMetadata != null ? serverCertificateMetadata.toBuilder() : null;
        }

        public final void setServerCertificateMetadata(ServerCertificateMetadata.BuilderImpl serverCertificateMetadata) {
            this.serverCertificateMetadata = serverCertificateMetadata != null ? serverCertificateMetadata.build() : null;
        }

        @Override
        public final Builder serverCertificateMetadata(ServerCertificateMetadata serverCertificateMetadata) {
            this.serverCertificateMetadata = serverCertificateMetadata;
            return this;
        }

        public final String getCertificateBody() {
            return certificateBody;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServerCertificate build() {
            return new ServerCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
