/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessKeyRequest extends IamRequest implements
        ToCopyableBuilder<UpdateAccessKeyRequest.Builder, UpdateAccessKeyRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UpdateAccessKeyRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKeyId").getter(getter(UpdateAccessKeyRequest::accessKeyId)).setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateAccessKeyRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            ACCESS_KEY_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserName", USER_NAME_FIELD);
                    put("AccessKeyId", ACCESS_KEY_ID_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private final String userName;

    private final String accessKeyId;

    private final String status;

    private UpdateAccessKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the user whose key you want to update.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the user whose key you want to update.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The access key ID of the secret access key you want to update.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters that can consist of any upper or lowercased letter or digit.
     * </p>
     * 
     * @return The access key ID of the secret access key you want to update.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters that can consist of any upper or lowercased letter or digit.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The status you want to assign to the secret access key. <code>Active</code> means that the key can be used for
     * programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status you want to assign to the secret access key. <code>Active</code> means that the key can be
     *         used for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot
     *         be used.
     * @see StatusType
     */
    public final StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status you want to assign to the secret access key. <code>Active</code> means that the key can be used for
     * programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status you want to assign to the secret access key. <code>Active</code> means that the key can be
     *         used for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot
     *         be used.
     * @see StatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessKeyRequest)) {
            return false;
        }
        UpdateAccessKeyRequest other = (UpdateAccessKeyRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(accessKeyId(), other.accessKeyId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessKeyRequest").add("UserName", userName()).add("AccessKeyId", accessKeyId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AccessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessKeyRequest, T> g) {
        return obj -> g.apply((UpdateAccessKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccessKeyRequest> {
        /**
         * <p>
         * The name of the user whose key you want to update.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param userName
         *        The name of the user whose key you want to update.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The access key ID of the secret access key you want to update.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters that can consist of any upper or lowercased letter or digit.
         * </p>
         * 
         * @param accessKeyId
         *        The access key ID of the secret access key you want to update.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters that can consist of any upper or lowercased letter or digit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The status you want to assign to the secret access key. <code>Active</code> means that the key can be used
         * for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot be used.
         * </p>
         * 
         * @param status
         *        The status you want to assign to the secret access key. <code>Active</code> means that the key can be
         *        used for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key
         *        cannot be used.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status you want to assign to the secret access key. <code>Active</code> means that the key can be used
         * for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key cannot be used.
         * </p>
         * 
         * @param status
         *        The status you want to assign to the secret access key. <code>Active</code> means that the key can be
         *        used for programmatic calls to Amazon Web Services, while <code>Inactive</code> means that the key
         *        cannot be used.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String userName;

        private String accessKeyId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessKeyRequest model) {
            super(model);
            userName(model.userName);
            accessKeyId(model.accessKeyId);
            status(model.status);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessKeyRequest build() {
            return new UpdateAccessKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
