/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>UploadSigningCertificate</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadSigningCertificateResponse extends IamResponse implements
        ToCopyableBuilder<UploadSigningCertificateResponse.Builder, UploadSigningCertificateResponse> {
    private static final SdkField<SigningCertificate> CERTIFICATE_FIELD = SdkField
            .<SigningCertificate> builder(MarshallingType.SDK_POJO).memberName("Certificate")
            .getter(getter(UploadSigningCertificateResponse::certificate)).setter(setter(Builder::certificate))
            .constructor(SigningCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Certificate", CERTIFICATE_FIELD);
                }
            });

    private final SigningCertificate certificate;

    private UploadSigningCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
    }

    /**
     * <p>
     * Information about the certificate.
     * </p>
     * 
     * @return Information about the certificate.
     */
    public final SigningCertificate certificate() {
        return certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSigningCertificateResponse)) {
            return false;
        }
        UploadSigningCertificateResponse other = (UploadSigningCertificateResponse) obj;
        return Objects.equals(certificate(), other.certificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadSigningCertificateResponse").add("Certificate", certificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UploadSigningCertificateResponse, T> g) {
        return obj -> g.apply((UploadSigningCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, UploadSigningCertificateResponse> {
        /**
         * <p>
         * Information about the certificate.
         * </p>
         * 
         * @param certificate
         *        Information about the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(SigningCertificate certificate);

        /**
         * <p>
         * Information about the certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningCertificate.Builder} avoiding the
         * need to create one manually via {@link SigningCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #certificate(SigningCertificate)}.
         * 
         * @param certificate
         *        a consumer that will call methods on {@link SigningCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificate(SigningCertificate)
         */
        default Builder certificate(Consumer<SigningCertificate.Builder> certificate) {
            return certificate(SigningCertificate.builder().applyMutation(certificate).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private SigningCertificate certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSigningCertificateResponse model) {
            super(model);
            certificate(model.certificate);
        }

        public final SigningCertificate.Builder getCertificate() {
            return certificate != null ? certificate.toBuilder() : null;
        }

        public final void setCertificate(SigningCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        public final Builder certificate(SigningCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        @Override
        public UploadSigningCertificateResponse build() {
            return new UploadSigningCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
