/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about when a principal in the reported Organizations entity last attempted to access
 * an Amazon Web Services service. A principal can be an IAM user, an IAM role, or the Amazon Web Services account root
 * user within the reported Organizations entity.
 * </p>
 * <p>
 * This data type is a response element in the <a>GetOrganizationsAccessReport</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessDetail implements SdkPojo, Serializable, ToCopyableBuilder<AccessDetail.Builder, AccessDetail> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(AccessDetail::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNamespace").getter(getter(AccessDetail::serviceNamespace))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(AccessDetail::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ENTITY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityPath").getter(getter(AccessDetail::entityPath)).setter(setter(Builder::entityPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build()).build();

    private static final SdkField<Instant> LAST_AUTHENTICATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAuthenticatedTime").getter(getter(AccessDetail::lastAuthenticatedTime))
            .setter(setter(Builder::lastAuthenticatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedTime").build())
            .build();

    private static final SdkField<Integer> TOTAL_AUTHENTICATED_ENTITIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalAuthenticatedEntities")
            .getter(getter(AccessDetail::totalAuthenticatedEntities))
            .setter(setter(Builder::totalAuthenticatedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAuthenticatedEntities").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            SERVICE_NAMESPACE_FIELD, REGION_FIELD, ENTITY_PATH_FIELD, LAST_AUTHENTICATED_TIME_FIELD,
            TOTAL_AUTHENTICATED_ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final String serviceNamespace;

    private final String region;

    private final String entityPath;

    private final Instant lastAuthenticatedTime;

    private final Integer totalAuthenticatedEntities;

    private AccessDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceNamespace = builder.serviceNamespace;
        this.region = builder.region;
        this.entityPath = builder.entityPath;
        this.lastAuthenticatedTime = builder.lastAuthenticatedTime;
        this.totalAuthenticatedEntities = builder.totalAuthenticatedEntities;
    }

    /**
     * <p>
     * The name of the service in which access was attempted.
     * </p>
     * 
     * @return The name of the service in which access was attempted.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The namespace of the service in which access was attempted.
     * </p>
     * <p>
     * To learn the service namespace of a service, see <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>Service Authorization
     * Reference</i>. Choose the name of the service to view details for that service. In the first paragraph, find the
     * service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
     * see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The namespace of the service in which access was attempted.</p>
     *         <p>
     *         To learn the service namespace of a service, see <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>Service
     *         Authorization Reference</i>. Choose the name of the service to view details for that service. In the
     *         first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more
     *         information about service namespaces, see <a href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String serviceNamespace() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The Region where the last service access attempt occurred.
     * </p>
     * <p>
     * This field is null if no principals in the reported Organizations entity attempted to access the service within
     * the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >tracking period</a>.
     * </p>
     * 
     * @return The Region where the last service access attempt occurred.</p>
     *         <p>
     *         This field is null if no principals in the reported Organizations entity attempted to access the service
     *         within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >tracking period</a>.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The path of the Organizations entity (root, organizational unit, or account) from which an authenticated
     * principal last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no principals (IAM users, IAM roles, or root user) in the reported Organizations entity
     * attempted to access the service within the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >tracking period</a>.
     * </p>
     * 
     * @return The path of the Organizations entity (root, organizational unit, or account) from which an authenticated
     *         principal last attempted to access the service. Amazon Web Services does not report unauthenticated
     *         requests.</p>
     *         <p>
     *         This field is null if no principals (IAM users, IAM roles, or root user) in the reported Organizations
     *         entity attempted to access the service within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >tracking period</a>.
     */
    public final String entityPath() {
        return entityPath;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     * authenticated principal most recently attempted to access the service. Amazon Web Services does not report
     * unauthenticated requests.
     * </p>
     * <p>
     * This field is null if no principals in the reported Organizations entity attempted to access the service within
     * the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     * >tracking period</a>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
     *         authenticated principal most recently attempted to access the service. Amazon Web Services does not
     *         report unauthenticated requests.</p>
     *         <p>
     *         This field is null if no principals in the reported Organizations entity attempted to access the service
     *         within the <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
     *         >tracking period</a>.
     */
    public final Instant lastAuthenticatedTime() {
        return lastAuthenticatedTime;
    }

    /**
     * <p>
     * The number of accounts with authenticated principals (root user, IAM users, and IAM roles) that attempted to
     * access the service in the tracking period.
     * </p>
     * 
     * @return The number of accounts with authenticated principals (root user, IAM users, and IAM roles) that attempted
     *         to access the service in the tracking period.
     */
    public final Integer totalAuthenticatedEntities() {
        return totalAuthenticatedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(lastAuthenticatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(totalAuthenticatedEntities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessDetail)) {
            return false;
        }
        AccessDetail other = (AccessDetail) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceNamespace(), other.serviceNamespace())
                && Objects.equals(region(), other.region()) && Objects.equals(entityPath(), other.entityPath())
                && Objects.equals(lastAuthenticatedTime(), other.lastAuthenticatedTime())
                && Objects.equals(totalAuthenticatedEntities(), other.totalAuthenticatedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessDetail").add("ServiceName", serviceName()).add("ServiceNamespace", serviceNamespace())
                .add("Region", region()).add("EntityPath", entityPath()).add("LastAuthenticatedTime", lastAuthenticatedTime())
                .add("TotalAuthenticatedEntities", totalAuthenticatedEntities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespace()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "EntityPath":
            return Optional.ofNullable(clazz.cast(entityPath()));
        case "LastAuthenticatedTime":
            return Optional.ofNullable(clazz.cast(lastAuthenticatedTime()));
        case "TotalAuthenticatedEntities":
            return Optional.ofNullable(clazz.cast(totalAuthenticatedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("EntityPath", ENTITY_PATH_FIELD);
        map.put("LastAuthenticatedTime", LAST_AUTHENTICATED_TIME_FIELD);
        map.put("TotalAuthenticatedEntities", TOTAL_AUTHENTICATED_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessDetail, T> g) {
        return obj -> g.apply((AccessDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessDetail> {
        /**
         * <p>
         * The name of the service in which access was attempted.
         * </p>
         * 
         * @param serviceName
         *        The name of the service in which access was attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The namespace of the service in which access was attempted.
         * </p>
         * <p>
         * To learn the service namespace of a service, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>Service Authorization
         * Reference</i>. Choose the name of the service to view details for that service. In the first paragraph, find
         * the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service
         * namespaces, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the service in which access was attempted.</p>
         *        <p>
         *        To learn the service namespace of a service, see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>Service
         *        Authorization Reference</i>. Choose the name of the service to view details for that service. In the
         *        first paragraph, find the service prefix. For example, <code>(service prefix: a4b)</code>. For more
         *        information about service namespaces, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The Region where the last service access attempt occurred.
         * </p>
         * <p>
         * This field is null if no principals in the reported Organizations entity attempted to access the service
         * within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >tracking period</a>.
         * </p>
         * 
         * @param region
         *        The Region where the last service access attempt occurred.</p>
         *        <p>
         *        This field is null if no principals in the reported Organizations entity attempted to access the
         *        service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >tracking period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The path of the Organizations entity (root, organizational unit, or account) from which an authenticated
         * principal last attempted to access the service. Amazon Web Services does not report unauthenticated requests.
         * </p>
         * <p>
         * This field is null if no principals (IAM users, IAM roles, or root user) in the reported Organizations entity
         * attempted to access the service within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >tracking period</a>.
         * </p>
         * 
         * @param entityPath
         *        The path of the Organizations entity (root, organizational unit, or account) from which an
         *        authenticated principal last attempted to access the service. Amazon Web Services does not report
         *        unauthenticated requests.</p>
         *        <p>
         *        This field is null if no principals (IAM users, IAM roles, or root user) in the reported Organizations
         *        entity attempted to access the service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >tracking period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityPath(String entityPath);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         * authenticated principal most recently attempted to access the service. Amazon Web Services does not report
         * unauthenticated requests.
         * </p>
         * <p>
         * This field is null if no principals in the reported Organizations entity attempted to access the service
         * within the <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         * >tracking period</a>.
         * </p>
         * 
         * @param lastAuthenticatedTime
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when an
         *        authenticated principal most recently attempted to access the service. Amazon Web Services does not
         *        report unauthenticated requests.</p>
         *        <p>
         *        This field is null if no principals in the reported Organizations entity attempted to access the
         *        service within the <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period"
         *        >tracking period</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAuthenticatedTime(Instant lastAuthenticatedTime);

        /**
         * <p>
         * The number of accounts with authenticated principals (root user, IAM users, and IAM roles) that attempted to
         * access the service in the tracking period.
         * </p>
         * 
         * @param totalAuthenticatedEntities
         *        The number of accounts with authenticated principals (root user, IAM users, and IAM roles) that
         *        attempted to access the service in the tracking period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private String serviceNamespace;

        private String region;

        private String entityPath;

        private Instant lastAuthenticatedTime;

        private Integer totalAuthenticatedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDetail model) {
            serviceName(model.serviceName);
            serviceNamespace(model.serviceNamespace);
            region(model.region);
            entityPath(model.entityPath);
            lastAuthenticatedTime(model.lastAuthenticatedTime);
            totalAuthenticatedEntities(model.totalAuthenticatedEntities);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEntityPath() {
            return entityPath;
        }

        public final void setEntityPath(String entityPath) {
            this.entityPath = entityPath;
        }

        @Override
        public final Builder entityPath(String entityPath) {
            this.entityPath = entityPath;
            return this;
        }

        public final Instant getLastAuthenticatedTime() {
            return lastAuthenticatedTime;
        }

        public final void setLastAuthenticatedTime(Instant lastAuthenticatedTime) {
            this.lastAuthenticatedTime = lastAuthenticatedTime;
        }

        @Override
        public final Builder lastAuthenticatedTime(Instant lastAuthenticatedTime) {
            this.lastAuthenticatedTime = lastAuthenticatedTime;
            return this;
        }

        public final Integer getTotalAuthenticatedEntities() {
            return totalAuthenticatedEntities;
        }

        public final void setTotalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
        }

        @Override
        public final Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
            return this;
        }

        @Override
        public AccessDetail build() {
            return new AccessDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
