/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangePasswordRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ChangePasswordRequest> {
    private static final SdkField<String> OLD_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OldPassword").getter(ChangePasswordRequest.getter(ChangePasswordRequest::oldPassword)).setter(ChangePasswordRequest.setter(Builder::oldPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldPassword").build()}).build();
    private static final SdkField<String> NEW_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewPassword").getter(ChangePasswordRequest.getter(ChangePasswordRequest::newPassword)).setter(ChangePasswordRequest.setter(Builder::newPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OLD_PASSWORD_FIELD, NEW_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OldPassword", OLD_PASSWORD_FIELD);
            this.put("NewPassword", NEW_PASSWORD_FIELD);
        }
    });
    private final String oldPassword;
    private final String newPassword;

    private ChangePasswordRequest(BuilderImpl builder) {
        super(builder);
        this.oldPassword = builder.oldPassword;
        this.newPassword = builder.newPassword;
    }

    public final String oldPassword() {
        return this.oldPassword;
    }

    public final String newPassword() {
        return this.newPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.oldPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangePasswordRequest)) {
            return false;
        }
        ChangePasswordRequest other = (ChangePasswordRequest)((Object)obj);
        return Objects.equals(this.oldPassword(), other.oldPassword()) && Objects.equals(this.newPassword(), other.newPassword());
    }

    public final String toString() {
        return ToString.builder((String)"ChangePasswordRequest").add("OldPassword", (Object)(this.oldPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NewPassword", (Object)(this.newPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OldPassword": {
                return Optional.ofNullable(clazz.cast(this.oldPassword()));
            }
            case "NewPassword": {
                return Optional.ofNullable(clazz.cast(this.newPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangePasswordRequest, T> g) {
        return obj -> g.apply((ChangePasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String oldPassword;
        private String newPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangePasswordRequest model) {
            super(model);
            this.oldPassword(model.oldPassword);
            this.newPassword(model.newPassword);
        }

        public final String getOldPassword() {
            return this.oldPassword;
        }

        public final void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        @Override
        public final Builder oldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
            return this;
        }

        public final String getNewPassword() {
            return this.newPassword;
        }

        public final void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @Override
        public final Builder newPassword(String newPassword) {
            this.newPassword = newPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            return new ChangePasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangePasswordRequest> {
        public Builder oldPassword(String var1);

        public Builder newPassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

