/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesGrantingServiceAccessRequest extends IamRequest implements
        ToCopyableBuilder<ListPoliciesGrantingServiceAccessRequest.Builder, ListPoliciesGrantingServiceAccessRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> SERVICE_NAMESPACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ServiceNamespaces")
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::serviceNamespaces))
            .setter(setter(Builder::serviceNamespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, ARN_FIELD,
            SERVICE_NAMESPACES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final String arn;

    private final List<String> serviceNamespaces;

    private ListPoliciesGrantingServiceAccessRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.arn = builder.arn;
        this.serviceNamespaces = builder.serviceNamespaces;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The ARN of the IAM identity (user, group, or role) whose policies you want to list.
     * </p>
     * 
     * @return The ARN of the IAM identity (user, group, or role) whose policies you want to list.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceNamespaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceNamespaces() {
        return serviceNamespaces != null && !(serviceNamespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The service namespace for the Amazon Web Services services whose policies you want to list.
     * </p>
     * <p>
     * To learn the service namespace for a service, see <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User Guide</i>. Choose
     * the name of the service to view details for that service. In the first paragraph, find the service prefix. For
     * example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceNamespaces} method.
     * </p>
     * 
     * @return The service namespace for the Amazon Web Services services whose policies you want to list.</p>
     *         <p>
     *         To learn the service namespace for a service, see <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User
     *         Guide</i>. Choose the name of the service to view details for that service. In the first paragraph, find
     *         the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about service
     *         namespaces, see <a href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<String> serviceNamespaces() {
        return serviceNamespaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceNamespaces() ? serviceNamespaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessRequest)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessRequest other = (ListPoliciesGrantingServiceAccessRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(arn(), other.arn())
                && hasServiceNamespaces() == other.hasServiceNamespaces()
                && Objects.equals(serviceNamespaces(), other.serviceNamespaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPoliciesGrantingServiceAccessRequest").add("Marker", marker()).add("Arn", arn())
                .add("ServiceNamespaces", hasServiceNamespaces() ? serviceNamespaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ServiceNamespaces":
            return Optional.ofNullable(clazz.cast(serviceNamespaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ServiceNamespaces", SERVICE_NAMESPACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessRequest, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessRequest> {
        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The ARN of the IAM identity (user, group, or role) whose policies you want to list.
         * </p>
         * 
         * @param arn
         *        The ARN of the IAM identity (user, group, or role) whose policies you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The service namespace for the Amazon Web Services services whose policies you want to list.
         * </p>
         * <p>
         * To learn the service namespace for a service, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User Guide</i>.
         * Choose the name of the service to view details for that service. In the first paragraph, find the service
         * prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see
         * <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param serviceNamespaces
         *        The service namespace for the Amazon Web Services services whose policies you want to list.</p>
         *        <p>
         *        To learn the service namespace for a service, see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User
         *        Guide</i>. Choose the name of the service to view details for that service. In the first paragraph,
         *        find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about
         *        service namespaces, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespaces(Collection<String> serviceNamespaces);

        /**
         * <p>
         * The service namespace for the Amazon Web Services services whose policies you want to list.
         * </p>
         * <p>
         * To learn the service namespace for a service, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         * >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User Guide</i>.
         * Choose the name of the service to view details for that service. In the first paragraph, find the service
         * prefix. For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see
         * <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param serviceNamespaces
         *        The service namespace for the Amazon Web Services services whose policies you want to list.</p>
         *        <p>
         *        To learn the service namespace for a service, see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, resources, and condition keys for Amazon Web Services services</a> in the <i>IAM User
         *        Guide</i>. Choose the name of the service to view details for that service. In the first paragraph,
         *        find the service prefix. For example, <code>(service prefix: a4b)</code>. For more information about
         *        service namespaces, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >Amazon Web Services service namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespaces(String... serviceNamespaces);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String marker;

        private String arn;

        private List<String> serviceNamespaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessRequest model) {
            super(model);
            marker(model.marker);
            arn(model.arn);
            serviceNamespaces(model.serviceNamespaces);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getServiceNamespaces() {
            if (serviceNamespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceNamespaces;
        }

        public final void setServiceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
        }

        @Override
        public final Builder serviceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNamespaces(String... serviceNamespaces) {
            serviceNamespaces(Arrays.asList(serviceNamespaces));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesGrantingServiceAccessRequest build() {
            return new ListPoliciesGrantingServiceAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
