/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a reference to a <code>Statement</code> element in a policy document that determines the result of the
 * simulation.
 * </p>
 * <p>
 * This data type is used by the <code>MatchedStatements</code> member of the <code> <a>EvaluationResult</a> </code>
 * type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statement implements SdkPojo, Serializable, ToCopyableBuilder<Statement.Builder, Statement> {
    private static final SdkField<String> SOURCE_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePolicyId").getter(getter(Statement::sourcePolicyId)).setter(setter(Builder::sourcePolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePolicyId").build()).build();

    private static final SdkField<String> SOURCE_POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePolicyType").getter(getter(Statement::sourcePolicyTypeAsString))
            .setter(setter(Builder::sourcePolicyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePolicyType").build()).build();

    private static final SdkField<Position> START_POSITION_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO)
            .memberName("StartPosition").getter(getter(Statement::startPosition)).setter(setter(Builder::startPosition))
            .constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build()).build();

    private static final SdkField<Position> END_POSITION_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO)
            .memberName("EndPosition").getter(getter(Statement::endPosition)).setter(setter(Builder::endPosition))
            .constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_POLICY_ID_FIELD,
            SOURCE_POLICY_TYPE_FIELD, START_POSITION_FIELD, END_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourcePolicyId;

    private final String sourcePolicyType;

    private final Position startPosition;

    private final Position endPosition;

    private Statement(BuilderImpl builder) {
        this.sourcePolicyId = builder.sourcePolicyId;
        this.sourcePolicyType = builder.sourcePolicyType;
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
    }

    /**
     * <p>
     * The identifier of the policy that was provided as an input.
     * </p>
     * 
     * @return The identifier of the policy that was provided as an input.
     */
    public final String sourcePolicyId() {
        return sourcePolicyId;
    }

    /**
     * <p>
     * The type of the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourcePolicyType}
     * will return {@link PolicySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourcePolicyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy.
     * @see PolicySourceType
     */
    public final PolicySourceType sourcePolicyType() {
        return PolicySourceType.fromValue(sourcePolicyType);
    }

    /**
     * <p>
     * The type of the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourcePolicyType}
     * will return {@link PolicySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourcePolicyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy.
     * @see PolicySourceType
     */
    public final String sourcePolicyTypeAsString() {
        return sourcePolicyType;
    }

    /**
     * <p>
     * The row and column of the beginning of the <code>Statement</code> in an IAM policy.
     * </p>
     * 
     * @return The row and column of the beginning of the <code>Statement</code> in an IAM policy.
     */
    public final Position startPosition() {
        return startPosition;
    }

    /**
     * <p>
     * The row and column of the end of a <code>Statement</code> in an IAM policy.
     * </p>
     * 
     * @return The row and column of the end of a <code>Statement</code> in an IAM policy.
     */
    public final Position endPosition() {
        return endPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePolicyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startPosition());
        hashCode = 31 * hashCode + Objects.hashCode(endPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement) obj;
        return Objects.equals(sourcePolicyId(), other.sourcePolicyId())
                && Objects.equals(sourcePolicyTypeAsString(), other.sourcePolicyTypeAsString())
                && Objects.equals(startPosition(), other.startPosition()) && Objects.equals(endPosition(), other.endPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statement").add("SourcePolicyId", sourcePolicyId())
                .add("SourcePolicyType", sourcePolicyTypeAsString()).add("StartPosition", startPosition())
                .add("EndPosition", endPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourcePolicyId":
            return Optional.ofNullable(clazz.cast(sourcePolicyId()));
        case "SourcePolicyType":
            return Optional.ofNullable(clazz.cast(sourcePolicyTypeAsString()));
        case "StartPosition":
            return Optional.ofNullable(clazz.cast(startPosition()));
        case "EndPosition":
            return Optional.ofNullable(clazz.cast(endPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourcePolicyId", SOURCE_POLICY_ID_FIELD);
        map.put("SourcePolicyType", SOURCE_POLICY_TYPE_FIELD);
        map.put("StartPosition", START_POSITION_FIELD);
        map.put("EndPosition", END_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Statement, T> g) {
        return obj -> g.apply((Statement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statement> {
        /**
         * <p>
         * The identifier of the policy that was provided as an input.
         * </p>
         * 
         * @param sourcePolicyId
         *        The identifier of the policy that was provided as an input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePolicyId(String sourcePolicyId);

        /**
         * <p>
         * The type of the policy.
         * </p>
         * 
         * @param sourcePolicyType
         *        The type of the policy.
         * @see PolicySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicySourceType
         */
        Builder sourcePolicyType(String sourcePolicyType);

        /**
         * <p>
         * The type of the policy.
         * </p>
         * 
         * @param sourcePolicyType
         *        The type of the policy.
         * @see PolicySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicySourceType
         */
        Builder sourcePolicyType(PolicySourceType sourcePolicyType);

        /**
         * <p>
         * The row and column of the beginning of the <code>Statement</code> in an IAM policy.
         * </p>
         * 
         * @param startPosition
         *        The row and column of the beginning of the <code>Statement</code> in an IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startPosition(Position startPosition);

        /**
         * <p>
         * The row and column of the beginning of the <code>Statement</code> in an IAM policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #startPosition(Position)}.
         * 
         * @param startPosition
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startPosition(Position)
         */
        default Builder startPosition(Consumer<Position.Builder> startPosition) {
            return startPosition(Position.builder().applyMutation(startPosition).build());
        }

        /**
         * <p>
         * The row and column of the end of a <code>Statement</code> in an IAM policy.
         * </p>
         * 
         * @param endPosition
         *        The row and column of the end of a <code>Statement</code> in an IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPosition(Position endPosition);

        /**
         * <p>
         * The row and column of the end of a <code>Statement</code> in an IAM policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #endPosition(Position)}.
         * 
         * @param endPosition
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endPosition(Position)
         */
        default Builder endPosition(Consumer<Position.Builder> endPosition) {
            return endPosition(Position.builder().applyMutation(endPosition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourcePolicyId;

        private String sourcePolicyType;

        private Position startPosition;

        private Position endPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            sourcePolicyId(model.sourcePolicyId);
            sourcePolicyType(model.sourcePolicyType);
            startPosition(model.startPosition);
            endPosition(model.endPosition);
        }

        public final String getSourcePolicyId() {
            return sourcePolicyId;
        }

        public final void setSourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
        }

        @Override
        public final Builder sourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
            return this;
        }

        public final String getSourcePolicyType() {
            return sourcePolicyType;
        }

        public final void setSourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
        }

        @Override
        public final Builder sourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
            return this;
        }

        @Override
        public final Builder sourcePolicyType(PolicySourceType sourcePolicyType) {
            this.sourcePolicyType(sourcePolicyType == null ? null : sourcePolicyType.toString());
            return this;
        }

        public final Position.Builder getStartPosition() {
            return startPosition != null ? startPosition.toBuilder() : null;
        }

        public final void setStartPosition(Position.BuilderImpl startPosition) {
            this.startPosition = startPosition != null ? startPosition.build() : null;
        }

        @Override
        public final Builder startPosition(Position startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final Position.Builder getEndPosition() {
            return endPosition != null ? endPosition.toBuilder() : null;
        }

        public final void setEndPosition(Position.BuilderImpl endPosition) {
            this.endPosition = endPosition != null ? endPosition.build() : null;
        }

        @Override
        public final Builder endPosition(Position endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        @Override
        public Statement build() {
            return new Statement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
