/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iam.internal.IamServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iam.model.AccountNotManagementOrDelegatedAdministratorException;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.services.iam.model.AddUserToGroupResponse;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.CallerIsNotManagementAccountException;
import software.amazon.awssdk.services.iam.model.ChangePasswordRequest;
import software.amazon.awssdk.services.iam.model.ChangePasswordResponse;
import software.amazon.awssdk.services.iam.model.ConcurrentModificationException;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;
import software.amazon.awssdk.services.iam.model.CreateGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.CredentialReportExpiredException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotPresentException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotReadyException;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteConflictException;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupResponse;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserResponse;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootCredentialsManagementRequest;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootCredentialsManagementResponse;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootSessionsRequest;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootSessionsResponse;
import software.amazon.awssdk.services.iam.model.DuplicateCertificateException;
import software.amazon.awssdk.services.iam.model.DuplicateSshPublicKeyException;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootCredentialsManagementRequest;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootCredentialsManagementResponse;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootSessionsRequest;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootSessionsResponse;
import software.amazon.awssdk.services.iam.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.iam.model.EntityTemporarilyUnmodifiableException;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryRequest;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GetCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.GetLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.GetSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.GetServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.GetServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.services.iam.model.InvalidAuthenticationCodeException;
import software.amazon.awssdk.services.iam.model.InvalidCertificateException;
import software.amazon.awssdk.services.iam.model.InvalidInputException;
import software.amazon.awssdk.services.iam.model.InvalidPublicKeyException;
import software.amazon.awssdk.services.iam.model.InvalidUserTypeException;
import software.amazon.awssdk.services.iam.model.KeyPairMismatchException;
import software.amazon.awssdk.services.iam.model.LimitExceededException;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListOrganizationsFeaturesRequest;
import software.amazon.awssdk.services.iam.model.ListOrganizationsFeaturesResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.MalformedCertificateException;
import software.amazon.awssdk.services.iam.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.iam.model.NoSuchEntityException;
import software.amazon.awssdk.services.iam.model.OpenIdIdpCommunicationErrorException;
import software.amazon.awssdk.services.iam.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.iam.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.iam.model.PasswordPolicyViolationException;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationException;
import software.amazon.awssdk.services.iam.model.PolicyNotAttachableException;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.PutRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupRequest;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupResponse;
import software.amazon.awssdk.services.iam.model.ReportGenerationLimitExceededException;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.ServiceAccessNotEnabledException;
import software.amazon.awssdk.services.iam.model.ServiceFailureException;
import software.amazon.awssdk.services.iam.model.ServiceNotSupportedException;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesRequest;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesResponse;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.TagPolicyRequest;
import software.amazon.awssdk.services.iam.model.TagPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagRoleRequest;
import software.amazon.awssdk.services.iam.model.TagRoleResponse;
import software.amazon.awssdk.services.iam.model.TagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.TagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.TagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.TagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.TagUserRequest;
import software.amazon.awssdk.services.iam.model.TagUserResponse;
import software.amazon.awssdk.services.iam.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.iam.model.UnrecognizedPublicKeyEncodingException;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagPolicyRequest;
import software.amazon.awssdk.services.iam.model.UntagPolicyResponse;
import software.amazon.awssdk.services.iam.model.UntagRoleRequest;
import software.amazon.awssdk.services.iam.model.UntagRoleResponse;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UntagUserRequest;
import software.amazon.awssdk.services.iam.model.UntagUserResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.services.iam.model.UpdateGroupResponse;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleResponse;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;
import software.amazon.awssdk.services.iam.model.UpdateUserResponse;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.transform.AddClientIdToOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AddRoleToInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateServiceLinkedRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateVirtualMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeactivateMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRolePermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServiceLinkedRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserPermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteVirtualMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DisableOrganizationsRootCredentialsManagementRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DisableOrganizationsRootSessionsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.EnableMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.EnableOrganizationsRootCredentialsManagementRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.EnableOrganizationsRootSessionsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateCredentialReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateOrganizationsAccessReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateServiceLastAccessedDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccessKeyLastUsedRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountAuthorizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountSummaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetContextKeysForCustomPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetContextKeysForPrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetCredentialReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetOrganizationsAccessReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLastAccessedDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLastAccessedDetailsWithEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLinkedRoleDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAccessKeysRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAccountAliasesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedGroupPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedRolePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedUserPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListEntitiesForPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListInstanceProfileTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListInstanceProfilesForRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListInstanceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListMfaDeviceTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListMfaDevicesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListOpenIdConnectProviderTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListOpenIdConnectProvidersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListOrganizationsFeaturesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPoliciesGrantingServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPolicyTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRolePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRoleTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRolesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSamlProviderTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSamlProvidersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListServerCertificateTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListServerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListServiceSpecificCredentialsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSigningCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSshPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUserPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUserTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListVirtualMfaDevicesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutRolePermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutUserPermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveClientIdFromOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveRoleFromInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ResetServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ResyncMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SetSecurityTokenServicePreferencesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SimulateCustomPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SimulatePrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAssumeRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateOpenIdConnectProviderThumbprintRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateRoleDescriptionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.waiters.IamAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IamAsyncClient}.
 *
 * @see IamAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIamAsyncClient implements IamAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIamAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultIamAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the AddClientIDToOpenIDConnectProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddClientIdToOpenIdConnectProviderResponse> addClientIDToOpenIDConnectProvider(
            AddClientIdToOpenIdConnectProviderRequest addClientIdToOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addClientIdToOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addClientIdToOpenIdConnectProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddClientIDToOpenIDConnectProvider");

            HttpResponseHandler<AddClientIdToOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddClientIdToOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddClientIdToOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddClientIdToOpenIdConnectProviderRequest, AddClientIdToOpenIdConnectProviderResponse>()
                            .withOperationName("AddClientIDToOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddClientIdToOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addClientIdToOpenIdConnectProviderRequest));
            CompletableFuture<AddClientIdToOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and
     * this quota cannot be increased. You can remove the existing role and then add a different role to an instance
     * profile. You must then wait for the change to appear across all of Amazon Web Services because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this operation must be granted the <code>PassRole</code> permission on the IAM role by a
     * permissions policy.
     * </p>
     * </note> <important>
     * <p>
     * When using the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#available-keys-for-iam"
     * >iam:AssociatedResourceArn</a> condition in a policy to restrict the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> IAM action,
     * special considerations apply if the policy is intended to define access for the
     * <code>AddRoleToInstanceProfile</code> action. In this case, you cannot specify a Region or instance ID in the EC2
     * instance ARN. The ARN value must be <code>arn:aws:ec2:*:CallerAccountId:instance/*</code>. Using any other ARN
     * value may lead to unexpected evaluation results.
     * </p>
     * </important>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     * @return A Java Future containing the result of the AddRoleToInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddRoleToInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddRoleToInstanceProfileResponse> addRoleToInstanceProfile(
            AddRoleToInstanceProfileRequest addRoleToInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRoleToInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToInstanceProfile");

            HttpResponseHandler<AddRoleToInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddRoleToInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddRoleToInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddRoleToInstanceProfileRequest, AddRoleToInstanceProfileResponse>()
                            .withOperationName("AddRoleToInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddRoleToInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addRoleToInstanceProfileRequest));
            CompletableFuture<AddRoleToInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     *
     * @param addUserToGroupRequest
     * @return A Java Future containing the result of the AddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddUserToGroupResponse> addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addUserToGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addUserToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddUserToGroup");

            HttpResponseHandler<AddUserToGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddUserToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddUserToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddUserToGroupRequest, AddUserToGroupResponse>()
                            .withOperationName("AddUserToGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddUserToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addUserToGroupRequest));
            CompletableFuture<AddUserToGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html"> <code>PutGroupPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachGroupPolicyRequest
     * @return A Java Future containing the result of the AttachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachGroupPolicyResponse> attachGroupPolicy(AttachGroupPolicyRequest attachGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachGroupPolicy");

            HttpResponseHandler<AttachGroupPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachGroupPolicyRequest, AttachGroupPolicyResponse>()
                            .withOperationName("AttachGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachGroupPolicyRequest));
            CompletableFuture<AttachGroupPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">
     * <code>CreateRole</code> </a>. You can update a role's trust policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html">
     * <code>UpdateAssumerolePolicy</code> </a>.
     * </p>
     * </note>
     * <p>
     * Use this operation to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html"> <code>PutRolePolicy</code>
     * </a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachRolePolicyRequest
     * @return A Java Future containing the result of the AttachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachRolePolicyResponse> attachRolePolicy(AttachRolePolicyRequest attachRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachRolePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachRolePolicy");

            HttpResponseHandler<AttachRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachRolePolicyRequest, AttachRolePolicyResponse>()
                            .withOperationName("AttachRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachRolePolicyRequest));
            CompletableFuture<AttachRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this operation to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html"> <code>PutUserPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachUserPolicyRequest
     * @return A Java Future containing the result of the AttachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachUserPolicyResponse> attachUserPolicy(AttachUserPolicyRequest attachUserPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachUserPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachUserPolicy");

            HttpResponseHandler<AttachUserPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachUserPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachUserPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachUserPolicyRequest, AttachUserPolicyResponse>()
                            .withOperationName("AttachUserPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AttachUserPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(attachUserPolicyRequest));
            CompletableFuture<AttachUserPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the
     * CLI, the Amazon Web Services API, or the <b>My Security Credentials</b> page in the Amazon Web Services
     * Management Console. The Amazon Web Services account root user password is not affected by this operation.
     * </p>
     * <p>
     * Use <a>UpdateLoginProfile</a> to use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM
     * console to change the password for any IAM user. For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param changePasswordRequest
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidUserTypeException The request was rejected because the type of user for the transaction was
     *         incorrect.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangePassword");

            HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory
                    .createResponseHandler(ChangePasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ChangePasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                            .withOperationName("ChangePassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(changePasswordRequest));
            CompletableFuture<ChangePasswordResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is
     * true even if the Amazon Web Services account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation. You must save the key (for example, in a text file) if you want to be able to access it again.
     * If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @param createAccessKeyRequest
     * @return A Java Future containing the result of the CreateAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessKeyResponse> createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessKey");

            HttpResponseHandler<CreateAccessKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateAccessKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateAccessKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessKeyRequest, CreateAccessKeyResponse>()
                            .withOperationName("CreateAccessKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccessKeyRequest));
            CompletableFuture<CreateAccessKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
     * alias, see <a href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User
     * Guide</i>.
     * </p>
     *
     * @param createAccountAliasRequest
     * @return A Java Future containing the result of the CreateAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountAliasResponse> createAccountAlias(CreateAccountAliasRequest createAccountAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAlias");

            HttpResponseHandler<CreateAccountAliasResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateAccountAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateAccountAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountAliasRequest, CreateAccountAliasResponse>()
                            .withOperationName("CreateAccountAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccountAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccountAliasRequest));
            CompletableFuture<CreateAccountAliasResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * For information about the number of groups you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using roles for
     * applications on Amazon EC2</a> in the <i>IAM User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile"
     * >Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about the number of instance profiles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            CreateInstanceProfileRequest createInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceProfile");

            HttpResponseHandler<CreateInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceProfileRequest, CreateInstanceProfileResponse>()
                            .withOperationName("CreateInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceProfileRequest));
            CompletableFuture<CreateInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services
     * services through the Amazon Web Services Management Console.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to create a
     * password for any IAM user. Use <a>ChangePassword</a> to update your own existing password in the <b>My Security
     * Credentials</b> page in the Amazon Web Services Management Console.
     * </p>
     * <p>
     * For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createLoginProfileRequest
     * @return A Java Future containing the result of the CreateLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoginProfileResponse> createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLoginProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoginProfile");

            HttpResponseHandler<CreateLoginProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLoginProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLoginProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoginProfileRequest, CreateLoginProfileResponse>()
                            .withOperationName("CreateLoginProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLoginProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLoginProfileRequest));
            CompletableFuture<CreateLoginProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between Amazon Web Services and the OIDC provider.
     * </p>
     * <p>
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a
     * separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are
     * available for your use. Instead, you can move directly to creating new roles using your identity provider. To
     * learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating a role for web
     * identity or OpenID connect federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of tags that are attached to the specified IAM OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP you want to use to access Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services secures communication with OIDC identity providers (IdPs) using our library of trusted root
     * certificate authorities (CAs) to verify the JSON Web Key Set (JWKS) endpoint's TLS certificate. If your OIDC IdP
     * relies on a certificate that is not signed by one of these trusted CAs, only then we secure communication using
     * the thumbprints set in the IdP's configuration.
     * </p>
     * </note> <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a>CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note>
     *
     * @param createOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the CreateOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>OpenIdIdpCommunicationErrorException The request failed because IAM cannot connect to the OpenID
     *         Connect identity provider URL.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOpenIdConnectProviderResponse> createOpenIDConnectProvider(
            CreateOpenIdConnectProviderRequest createOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpenIDConnectProvider");

            HttpResponseHandler<CreateOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOpenIdConnectProviderRequest, CreateOpenIdConnectProviderResponse>()
                            .withOperationName("CreateOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOpenIdConnectProviderRequest));
            CompletableFuture<CreateOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new managed policy for your Amazon Web Services account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyRequest
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicy");

            HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreatePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreatePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                            .withOperationName("CreatePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPolicyRequest));
            CompletableFuture<CreatePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a>DeletePolicyVersion</a> before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyVersionRequest
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            CreatePolicyVersionRequest createPolicyVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicyVersion");

            HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreatePolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreatePolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                            .withOperationName("CreatePolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPolicyVersionRequest));
            CompletableFuture<CreatePolicyVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new role for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For information about quotas for role names and the number of roles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createRoleRequest
     * @return A Java Future containing the result of the CreateRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRoleResponse> createRole(CreateRoleRequest createRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRole");

            HttpResponseHandler<CreateRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRoleRequest, CreateRoleResponse>().withOperationName("CreateRole")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRoleRequest));
            CompletableFuture<CreateRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or
     * one that supports API access to Amazon Web Services.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 federated users to access the Amazon Web Services Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createSamlProviderRequest
     * @return A Java Future containing the result of the CreateSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSamlProviderResponse> createSAMLProvider(CreateSamlProviderRequest createSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSAMLProvider");

            HttpResponseHandler<CreateSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSamlProviderRequest, CreateSamlProviderResponse>()
                            .withOperationName("CreateSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSamlProviderRequest));
            CompletableFuture<CreateSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached
     * policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly
     * changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the
     * service to control the role helps improve service stability and proper cleanup when a service and its role are no
     * longer needed. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
     * roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the Amazon Web Services service
     * that depends on this role.
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     * @return A Java Future containing the result of the CreateServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateServiceLinkedRoleResponse> createServiceLinkedRole(
            CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createServiceLinkedRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceLinkedRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceLinkedRole");

            HttpResponseHandler<CreateServiceLinkedRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateServiceLinkedRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateServiceLinkedRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateServiceLinkedRoleRequest, CreateServiceLinkedRoleResponse>()
                            .withOperationName("CreateServiceLinkedRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateServiceLinkedRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createServiceLinkedRoleRequest));
            CompletableFuture<CreateServiceLinkedRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache Cassandra).
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM with CodeCommit:
     * Git credentials, SSH keys, and Amazon Web Services access keys</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the CreateServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceNotSupportedException The specified service does not support service-specific credentials.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateServiceSpecificCredentialResponse> createServiceSpecificCredential(
            CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createServiceSpecificCredentialRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceSpecificCredential");

            HttpResponseHandler<CreateServiceSpecificCredentialResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateServiceSpecificCredentialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateServiceSpecificCredentialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateServiceSpecificCredentialRequest, CreateServiceSpecificCredentialResponse>()
                            .withOperationName("CreateServiceSpecificCredential").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateServiceSpecificCredentialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createServiceSpecificCredentialRequest));
            CompletableFuture<CreateServiceSpecificCredentialResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new IAM user for your Amazon Web Services account.
     * </p>
     * <p>
     * For information about quotas for the number of IAM users you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserRequest));
            CompletableFuture<CreateUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use
     * <a>EnableMFADevice</a> to attach the MFA device to an IAM user. For more information about creating and working
     * with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA device</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of MFA devices you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your Amazon Web Services access
     * keys or your passwords. After you provision your virtual device, you should ensure that the information is
     * destroyed following secure procedures.
     * </p>
     * </important>
     *
     * @param createVirtualMfaDeviceRequest
     * @return A Java Future containing the result of the CreateVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVirtualMfaDeviceResponse> createVirtualMFADevice(
            CreateVirtualMfaDeviceRequest createVirtualMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVirtualMfaDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVirtualMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVirtualMFADevice");

            HttpResponseHandler<CreateVirtualMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVirtualMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVirtualMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVirtualMfaDeviceRequest, CreateVirtualMfaDeviceResponse>()
                            .withOperationName("CreateVirtualMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVirtualMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVirtualMfaDeviceRequest));
            CompletableFuture<CreateVirtualMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual multi-factor
     * authentication (MFA) device</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     * @return A Java Future containing the result of the DeactivateMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeactivateMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeactivateMfaDeviceResponse> deactivateMFADevice(
            DeactivateMfaDeviceRequest deactivateMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateMfaDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateMFADevice");

            HttpResponseHandler<DeactivateMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeactivateMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeactivateMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeactivateMfaDeviceRequest, DeactivateMfaDeviceResponse>()
                            .withOperationName("DeactivateMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeactivateMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deactivateMfaDeviceRequest));
            CompletableFuture<DeactivateMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated users.
     * </p>
     *
     * @param deleteAccessKeyRequest
     * @return A Java Future containing the result of the DeleteAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessKeyResponse> deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessKey");

            HttpResponseHandler<DeleteAccessKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteAccessKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteAccessKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessKeyRequest, DeleteAccessKeyResponse>()
                            .withOperationName("DeleteAccessKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessKeyRequest));
            CompletableFuture<DeleteAccessKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
     * account alias, see <a
     * href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating, deleting, and
     * listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User Guide</i>.
     * </p>
     *
     * @param deleteAccountAliasRequest
     * @return A Java Future containing the result of the DeleteAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountAliasResponse> deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAlias");

            HttpResponseHandler<DeleteAccountAliasResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteAccountAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteAccountAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAliasRequest, DeleteAccountAliasResponse>()
                            .withOperationName("DeleteAccountAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccountAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccountAliasRequest));
            CompletableFuture<DeleteAccountAliasResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     * @return A Java Future containing the result of the DeleteAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountPasswordPolicyResponse> deleteAccountPasswordPolicy(
            DeleteAccountPasswordPolicyRequest deleteAccountPasswordPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountPasswordPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountPasswordPolicy");

            HttpResponseHandler<DeleteAccountPasswordPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteAccountPasswordPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteAccountPasswordPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountPasswordPolicyRequest, DeleteAccountPasswordPolicyResponse>()
                            .withOperationName("DeleteAccountPasswordPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccountPasswordPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccountPasswordPolicyRequest));
            CompletableFuture<DeleteAccountPasswordPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use
     * <a>DetachGroupPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupPolicyResponse> deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupPolicy");

            HttpResponseHandler<DeleteGroupPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupPolicyRequest, DeleteGroupPolicyResponse>()
                            .withOperationName("DeleteGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupPolicyRequest));
            CompletableFuture<DeleteGroupPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            DeleteInstanceProfileRequest deleteInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceProfile");

            HttpResponseHandler<DeleteInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceProfileRequest, DeleteInstanceProfileResponse>()
                            .withOperationName("DeleteInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceProfileRequest));
            CompletableFuture<DeleteInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user, For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html">Managing
     * passwords for IAM users</a>.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to delete a
     * password for any IAM user. You can use <a>ChangePassword</a> to update, but not delete, your own password in the
     * <b>My Security Credentials</b> page in the Amazon Web Services Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line
     * interface or the API. To prevent all user access, you must also either make any access keys inactive or delete
     * them. For more information about making keys inactive or deleting them, see <a>UpdateAccessKey</a> and
     * <a>DeleteAccessKey</a>.
     * </p>
     * </important>
     *
     * @param deleteLoginProfileRequest
     * @return A Java Future containing the result of the DeleteLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoginProfileResponse> deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLoginProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoginProfile");

            HttpResponseHandler<DeleteLoginProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLoginProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLoginProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoginProfileRequest, DeleteLoginProfileResponse>()
                            .withOperationName("DeleteLoginProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLoginProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLoginProfileRequest));
            CompletableFuture<DeleteLoginProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the DeleteOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOpenIdConnectProviderResponse> deleteOpenIDConnectProvider(
            DeleteOpenIdConnectProviderRequest deleteOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpenIDConnectProvider");

            HttpResponseHandler<DeleteOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOpenIdConnectProviderRequest, DeleteOpenIdConnectProviderResponse>()
                            .withOperationName("DeleteOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOpenIdConnectProviderRequest));
            CompletableFuture<DeleteOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using
     * <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a>. To list all the users, groups, and
     * roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a>DeletePolicyVersion</a>. To list the policy's versions, use
     * <a>ListPolicyVersions</a>. You cannot use <a>DeletePolicyVersion</a> to delete the version that is marked as the
     * default version. You delete the policy's default version in the next step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicy");

            HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                            .withOperationName("DeletePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePolicyRequest));
            CompletableFuture<DeletePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this operation. To delete the default version from a
     * policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use
     * <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyVersionRequest
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            DeletePolicyVersionRequest deletePolicyVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicyVersion");

            HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                            .withOperationName("DeletePolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePolicyVersionRequest));
            CompletableFuture<DeletePolicyVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role
     * programmatically, you must delete the items attached to the role manually, or the deletion fails. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli"
     * >Deleting an IAM role</a>. Before attempting to delete a role, remove the following attached items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline policies (<a>DeleteRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a>DetachRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance profile (<a>RemoveRoleFromInstanceProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional – Delete instance profile after detaching from role for resource clean up (<a>DeleteInstanceProfile</a>)
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important>
     *
     * @param deleteRoleRequest
     * @return A Java Future containing the result of the DeleteRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRoleResponse> deleteRole(DeleteRoleRequest deleteRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRole");

            HttpResponseHandler<DeleteRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleRequest, DeleteRoleResponse>().withOperationName("DeleteRole")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRoleRequest));
            CompletableFuture<DeleteRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteRolePermissionsBoundaryRequest
     * @return A Java Future containing the result of the DeleteRolePermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRolePermissionsBoundaryResponse> deleteRolePermissionsBoundary(
            DeleteRolePermissionsBoundaryRequest deleteRolePermissionsBoundaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRolePermissionsBoundaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRolePermissionsBoundaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRolePermissionsBoundary");

            HttpResponseHandler<DeleteRolePermissionsBoundaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRolePermissionsBoundaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRolePermissionsBoundaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRolePermissionsBoundaryRequest, DeleteRolePermissionsBoundaryResponse>()
                            .withOperationName("DeleteRolePermissionsBoundary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRolePermissionsBoundaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRolePermissionsBoundaryRequest));
            CompletableFuture<DeleteRolePermissionsBoundaryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use
     * <a>DetachRolePolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteRolePolicyRequest
     * @return A Java Future containing the result of the DeleteRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRolePolicyResponse> deleteRolePolicy(DeleteRolePolicyRequest deleteRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRolePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRolePolicy");

            HttpResponseHandler<DeleteRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRolePolicyRequest, DeleteRolePolicyResponse>()
                            .withOperationName("DeleteRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRolePolicyRequest));
            CompletableFuture<DeleteRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param deleteSamlProviderRequest
     * @return A Java Future containing the result of the DeleteSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSamlProviderResponse> deleteSAMLProvider(DeleteSamlProviderRequest deleteSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSAMLProvider");

            HttpResponseHandler<DeleteSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSamlProviderRequest, DeleteSamlProviderResponse>()
                            .withOperationName("DeleteSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSamlProviderRequest));
            CompletableFuture<DeleteSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return A Java Future containing the result of the DeleteSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSshPublicKeyResponse> deleteSSHPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSshPublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSSHPublicKey");

            HttpResponseHandler<DeleteSshPublicKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSshPublicKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSshPublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSshPublicKeyRequest, DeleteSshPublicKeyResponse>()
                            .withOperationName("DeleteSSHPublicKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSshPublicKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSshPublicKeyRequest));
            CompletableFuture<DeleteSshPublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of Amazon Web Services services
     * that can use the server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important>
     *
     * @param deleteServerCertificateRequest
     * @return A Java Future containing the result of the DeleteServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServerCertificateResponse> deleteServerCertificate(
            DeleteServerCertificateRequest deleteServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServerCertificate");

            HttpResponseHandler<DeleteServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServerCertificateRequest, DeleteServerCertificateResponse>()
                            .withOperationName("DeleteServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteServerCertificateRequest));
            CompletableFuture<DeleteServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a>GetServiceLinkedRoleDeletionStatus</a> operation returns the
     * reason for the failure, usually including the resources that must be deleted. To delete the service-linked role,
     * you must first remove those resources from the linked service and then submit the deletion request again.
     * Resources are specific to the service that is linked to the role. For more information about removing resources
     * from a service, see the <a href="http://docs.aws.amazon.com/">Amazon Web Services documentation</a> for your
     * service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles terms and concepts: Amazon Web Services service-linked role</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     * @return A Java Future containing the result of the DeleteServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceLinkedRoleResponse> deleteServiceLinkedRole(
            DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServiceLinkedRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceLinkedRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceLinkedRole");

            HttpResponseHandler<DeleteServiceLinkedRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteServiceLinkedRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteServiceLinkedRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceLinkedRoleRequest, DeleteServiceLinkedRoleResponse>()
                            .withOperationName("DeleteServiceLinkedRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteServiceLinkedRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteServiceLinkedRoleRequest));
            CompletableFuture<DeleteServiceLinkedRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the DeleteServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceSpecificCredentialResponse> deleteServiceSpecificCredential(
            DeleteServiceSpecificCredentialRequest deleteServiceSpecificCredentialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServiceSpecificCredentialRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceSpecificCredential");

            HttpResponseHandler<DeleteServiceSpecificCredentialResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteServiceSpecificCredentialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteServiceSpecificCredentialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceSpecificCredentialRequest, DeleteServiceSpecificCredentialResponse>()
                            .withOperationName("DeleteServiceSpecificCredential").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteServiceSpecificCredentialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteServiceSpecificCredentialRequest));
            CompletableFuture<DeleteServiceSpecificCredentialResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated IAM users.
     * </p>
     *
     * @param deleteSigningCertificateRequest
     * @return A Java Future containing the result of the DeleteSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSigningCertificateResponse> deleteSigningCertificate(
            DeleteSigningCertificateRequest deleteSigningCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSigningCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSigningCertificate");

            HttpResponseHandler<DeleteSigningCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSigningCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSigningCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSigningCertificateRequest, DeleteSigningCertificateResponse>()
                            .withOperationName("DeleteSigningCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSigningCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSigningCertificateRequest));
            CompletableFuture<DeleteSigningCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
     * programmatically, you must delete the items attached to the user manually, or the deletion fails. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM user</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a>DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a>DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a>DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a>DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a>DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a>DeactivateMFADevice</a>, <a>DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a>DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a>DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a>RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteUserPermissionsBoundaryRequest
     * @return A Java Future containing the result of the DeleteUserPermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPermissionsBoundaryResponse> deleteUserPermissionsBoundary(
            DeleteUserPermissionsBoundaryRequest deleteUserPermissionsBoundaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPermissionsBoundaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteUserPermissionsBoundaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPermissionsBoundary");

            HttpResponseHandler<DeleteUserPermissionsBoundaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUserPermissionsBoundaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUserPermissionsBoundaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPermissionsBoundaryRequest, DeleteUserPermissionsBoundaryResponse>()
                            .withOperationName("DeleteUserPermissionsBoundary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPermissionsBoundaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPermissionsBoundaryRequest));
            CompletableFuture<DeleteUserPermissionsBoundaryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use
     * <a>DetachUserPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteUserPolicyRequest
     * @return A Java Future containing the result of the DeleteUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPolicyResponse> deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPolicy");

            HttpResponseHandler<DeleteUserPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUserPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUserPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPolicyRequest, DeleteUserPolicyResponse>()
                            .withOperationName("DeleteUserPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPolicyRequest));
            CompletableFuture<DeleteUserPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a>DeactivateMFADevice</a>.
     * </p>
     * </note>
     *
     * @param deleteVirtualMfaDeviceRequest
     * @return A Java Future containing the result of the DeleteVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVirtualMfaDeviceResponse> deleteVirtualMFADevice(
            DeleteVirtualMfaDeviceRequest deleteVirtualMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVirtualMfaDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVirtualMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVirtualMFADevice");

            HttpResponseHandler<DeleteVirtualMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVirtualMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVirtualMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVirtualMfaDeviceRequest, DeleteVirtualMfaDeviceResponse>()
                            .withOperationName("DeleteVirtualMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVirtualMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVirtualMfaDeviceRequest));
            CompletableFuture<DeleteVirtualMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteGroupPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachGroupPolicyRequest
     * @return A Java Future containing the result of the DetachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachGroupPolicyResponse> detachGroupPolicy(DetachGroupPolicyRequest detachGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachGroupPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachGroupPolicy");

            HttpResponseHandler<DetachGroupPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetachGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachGroupPolicyRequest, DetachGroupPolicyResponse>()
                            .withOperationName("DetachGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachGroupPolicyRequest));
            CompletableFuture<DetachGroupPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteRolePolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachRolePolicyRequest
     * @return A Java Future containing the result of the DetachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachRolePolicyResponse> detachRolePolicy(DetachRolePolicyRequest detachRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachRolePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachRolePolicy");

            HttpResponseHandler<DetachRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetachRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachRolePolicyRequest, DetachRolePolicyResponse>()
                            .withOperationName("DetachRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachRolePolicyRequest));
            CompletableFuture<DetachRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use <a>DeleteUserPolicy</a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachUserPolicyRequest
     * @return A Java Future containing the result of the DetachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachUserPolicyResponse> detachUserPolicy(DetachUserPolicyRequest detachUserPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachUserPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachUserPolicy");

            HttpResponseHandler<DetachUserPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachUserPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetachUserPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachUserPolicyRequest, DetachUserPolicyResponse>()
                            .withOperationName("DetachUserPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetachUserPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detachUserPolicyRequest));
            CompletableFuture<DetachUserPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the management of privileged root user credentials across member accounts in your organization. When you
     * disable this feature, the management account and the delegated administrator for IAM can no longer manage root
     * user credentials for member accounts in your organization.
     * </p>
     *
     * @param disableOrganizationsRootCredentialsManagementRequest
     * @return A Java Future containing the result of the DisableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableOrganizationsRootCredentialsManagementResponse> disableOrganizationsRootCredentialsManagement(
            DisableOrganizationsRootCredentialsManagementRequest disableOrganizationsRootCredentialsManagementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                disableOrganizationsRootCredentialsManagementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableOrganizationsRootCredentialsManagementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableOrganizationsRootCredentialsManagement");

            HttpResponseHandler<DisableOrganizationsRootCredentialsManagementResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisableOrganizationsRootCredentialsManagementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisableOrganizationsRootCredentialsManagementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableOrganizationsRootCredentialsManagementRequest, DisableOrganizationsRootCredentialsManagementResponse>()
                            .withOperationName("DisableOrganizationsRootCredentialsManagement")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableOrganizationsRootCredentialsManagementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableOrganizationsRootCredentialsManagementRequest));
            CompletableFuture<DisableOrganizationsRootCredentialsManagementResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables root user sessions for privileged tasks across member accounts in your organization. When you disable
     * this feature, the management account and the delegated administrator for IAM can no longer perform privileged
     * tasks on member accounts in your organization.
     * </p>
     *
     * @param disableOrganizationsRootSessionsRequest
     * @return A Java Future containing the result of the DisableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableOrganizationsRootSessionsResponse> disableOrganizationsRootSessions(
            DisableOrganizationsRootSessionsRequest disableOrganizationsRootSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableOrganizationsRootSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableOrganizationsRootSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableOrganizationsRootSessions");

            HttpResponseHandler<DisableOrganizationsRootSessionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisableOrganizationsRootSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisableOrganizationsRootSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableOrganizationsRootSessionsRequest, DisableOrganizationsRootSessionsResponse>()
                            .withOperationName("DisableOrganizationsRootSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableOrganizationsRootSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableOrganizationsRootSessionsRequest));
            CompletableFuture<DisableOrganizationsRootSessionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     *
     * @param enableMfaDeviceRequest
     * @return A Java Future containing the result of the EnableMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>InvalidAuthenticationCodeException The request was rejected because the authentication code was not
     *         recognized. The error message describes the specific error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableMfaDeviceResponse> enableMFADevice(EnableMfaDeviceRequest enableMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableMfaDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableMFADevice");

            HttpResponseHandler<EnableMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EnableMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableMfaDeviceRequest, EnableMfaDeviceResponse>()
                            .withOperationName("EnableMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableMfaDeviceRequest));
            CompletableFuture<EnableMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the management of privileged root user credentials across member accounts in your organization. When you
     * enable root credentials management for <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >centralized root access</a>, the management account and the delegated administrator for IAM can manage root user
     * credentials for member accounts in your organization.
     * </p>
     * <p>
     * Before you enable centralized root access, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-iam.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param enableOrganizationsRootCredentialsManagementRequest
     * @return A Java Future containing the result of the EnableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableOrganizationsRootCredentialsManagementResponse> enableOrganizationsRootCredentialsManagement(
            EnableOrganizationsRootCredentialsManagementRequest enableOrganizationsRootCredentialsManagementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                enableOrganizationsRootCredentialsManagementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableOrganizationsRootCredentialsManagementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableOrganizationsRootCredentialsManagement");

            HttpResponseHandler<EnableOrganizationsRootCredentialsManagementResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableOrganizationsRootCredentialsManagementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EnableOrganizationsRootCredentialsManagementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableOrganizationsRootCredentialsManagementRequest, EnableOrganizationsRootCredentialsManagementResponse>()
                            .withOperationName("EnableOrganizationsRootCredentialsManagement")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableOrganizationsRootCredentialsManagementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableOrganizationsRootCredentialsManagementRequest));
            CompletableFuture<EnableOrganizationsRootCredentialsManagementResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the management account or delegated administrator to perform privileged tasks on member accounts in your
     * organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a> in the <i>Identity and Access Management User Guide</i>.
     * </p>
     * <p>
     * Before you enable this feature, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-ra.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param enableOrganizationsRootSessionsRequest
     * @return A Java Future containing the result of the EnableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableOrganizationsRootSessionsResponse> enableOrganizationsRootSessions(
            EnableOrganizationsRootSessionsRequest enableOrganizationsRootSessionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableOrganizationsRootSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableOrganizationsRootSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableOrganizationsRootSessions");

            HttpResponseHandler<EnableOrganizationsRootSessionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableOrganizationsRootSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EnableOrganizationsRootSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableOrganizationsRootSessionsRequest, EnableOrganizationsRootSessionsResponse>()
                            .withOperationName("EnableOrganizationsRootSessions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableOrganizationsRootSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableOrganizationsRootSessionsRequest));
            CompletableFuture<EnableOrganizationsRootSessionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateCredentialReportRequest
     * @return A Java Future containing the result of the GenerateCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GenerateCredentialReportResponse> generateCredentialReport(
            GenerateCredentialReportRequest generateCredentialReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateCredentialReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateCredentialReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateCredentialReport");

            HttpResponseHandler<GenerateCredentialReportResponse> responseHandler = protocolFactory
                    .createResponseHandler(GenerateCredentialReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GenerateCredentialReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateCredentialReportRequest, GenerateCredentialReportResponse>()
                            .withOperationName("GenerateCredentialReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GenerateCredentialReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(generateCredentialReportRequest));
            CompletableFuture<GenerateCredentialReportResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a report for service last accessed data for Organizations. You can generate a report for any entities
     * (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your Organizations management account credentials. You can
     * use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs
     * must be enabled for your organization root. You must have the required IAM and Organizations permissions. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This includes all
     * attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
     * of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not
     * mean that an account has been compromised, because the request might have been denied. Refer to your CloudTrail
     * logs as the authoritative source for information about all API calls and whether they were successful or denied
     * access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation to check the status of the report generation. To
     * check the status of this request, use the <code>JobId</code> parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation and test the <code>JobStatus</code> response
     * parameter. When the job is complete, you can retrieve the report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional Organizations policy ID. The type of entity that you specify determines the data returned in the report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the management account, because the management account is not limited by
     * SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the management account, because the management
     * account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. For each service, the report includes
     * data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the management account, because the management account
     * is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the management account, because the management account is
     * not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list
     * of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. If you specify a policy ID in the CLI
     * or API, the policy is ignored. For each service, the report includes data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope
     * by viewing user activity</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     * @return A Java Future containing the result of the GenerateOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReportGenerationLimitExceededException The request failed because the maximum number of concurrent
     *         requests for this account are already running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GenerateOrganizationsAccessReportResponse> generateOrganizationsAccessReport(
            GenerateOrganizationsAccessReportRequest generateOrganizationsAccessReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateOrganizationsAccessReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateOrganizationsAccessReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateOrganizationsAccessReport");

            HttpResponseHandler<GenerateOrganizationsAccessReportResponse> responseHandler = protocolFactory
                    .createResponseHandler(GenerateOrganizationsAccessReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GenerateOrganizationsAccessReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateOrganizationsAccessReportRequest, GenerateOrganizationsAccessReportResponse>()
                            .withOperationName("GenerateOrganizationsAccessReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GenerateOrganizationsAccessReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(generateOrganizationsAccessReportRequest));
            CompletableFuture<GenerateOrganizationsAccessReportResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM
     * reports activity for at least the last 400 days, or less if your Region began supporting this feature within the
     * last year. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a>. For more information about services and actions for which action last
     * accessed information is displayed, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-action-last-accessed.html">IAM
     * action last accessed information services and actions</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not just the
     * successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the
     * Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the
     * service last accessed data does not mean that your account has been compromised, because the request might have
     * been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and
     * whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every
     * Amazon Web Services service that the resource could access using permissions policies. For each service, the
     * response includes information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific Amazon Web Services service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a>ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     * @return A Java Future containing the result of the GenerateServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GenerateServiceLastAccessedDetailsResponse> generateServiceLastAccessedDetails(
            GenerateServiceLastAccessedDetailsRequest generateServiceLastAccessedDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateServiceLastAccessedDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateServiceLastAccessedDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateServiceLastAccessedDetails");

            HttpResponseHandler<GenerateServiceLastAccessedDetailsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GenerateServiceLastAccessedDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GenerateServiceLastAccessedDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateServiceLastAccessedDetailsRequest, GenerateServiceLastAccessedDetailsResponse>()
                            .withOperationName("GenerateServiceLastAccessedDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GenerateServiceLastAccessedDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(generateServiceLastAccessedDetailsRequest));
            CompletableFuture<GenerateServiceLastAccessedDetailsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the Amazon Web Services service and Region that were specified in the last request
     * made with that key.
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     * @return A Java Future containing the result of the GetAccessKeyLastUsed operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccessKeyLastUsed
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessKeyLastUsedResponse> getAccessKeyLastUsed(
            GetAccessKeyLastUsedRequest getAccessKeyLastUsedRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessKeyLastUsedRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessKeyLastUsedRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessKeyLastUsed");

            HttpResponseHandler<GetAccessKeyLastUsedResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetAccessKeyLastUsedResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetAccessKeyLastUsedResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessKeyLastUsedRequest, GetAccessKeyLastUsedResponse>()
                            .withOperationName("GetAccessKeyLastUsed").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessKeyLastUsedRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessKeyLastUsedRequest));
            CompletableFuture<GetAccessKeyLastUsedResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account,
     * including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM
     * permissions (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return A Java Future containing the result of the GetAccountAuthorizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountAuthorizationDetailsResponse> getAccountAuthorizationDetails(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountAuthorizationDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccountAuthorizationDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountAuthorizationDetails");

            HttpResponseHandler<GetAccountAuthorizationDetailsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetAccountAuthorizationDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetAccountAuthorizationDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountAuthorizationDetailsRequest, GetAccountAuthorizationDetailsResponse>()
                            .withOperationName("GetAccountAuthorizationDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountAuthorizationDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountAuthorizationDetailsRequest));
            CompletableFuture<GetAccountAuthorizationDetailsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and
     * mandatory rotation periods for the IAM user passwords in your account. For more information about using a
     * password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * password policy</a>.
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     * @return A Java Future containing the result of the GetAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountPasswordPolicyResponse> getAccountPasswordPolicy(
            GetAccountPasswordPolicyRequest getAccountPasswordPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountPasswordPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountPasswordPolicy");

            HttpResponseHandler<GetAccountPasswordPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetAccountPasswordPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetAccountPasswordPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountPasswordPolicyRequest, GetAccountPasswordPolicyResponse>()
                            .withOperationName("GetAccountPasswordPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountPasswordPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountPasswordPolicyRequest));
            CompletableFuture<GetAccountPasswordPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param getAccountSummaryRequest
     * @return A Java Future containing the result of the GetAccountSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountSummaryResponse> getAccountSummary(GetAccountSummaryRequest getAccountSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountSummary");

            HttpResponseHandler<GetAccountSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetAccountSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetAccountSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountSummaryRequest, GetAccountSummaryResponse>()
                            .withOperationName("GetAccountSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountSummaryRequest));
            CompletableFuture<GetAccountSummaryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value specified in an IAM
     * policy. Use <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply
     * when you call <a>SimulateCustomPolicy</a>. Note that all parameters are shown in unencoded form here for clarity
     * but must be URL encoded to be included as a part of a real HTML request.
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     * @return A Java Future containing the result of the GetContextKeysForCustomPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContextKeysForCustomPolicyResponse> getContextKeysForCustomPolicy(
            GetContextKeysForCustomPolicyRequest getContextKeysForCustomPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContextKeysForCustomPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContextKeysForCustomPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContextKeysForCustomPolicy");

            HttpResponseHandler<GetContextKeysForCustomPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetContextKeysForCustomPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetContextKeysForCustomPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContextKeysForCustomPolicyRequest, GetContextKeysForCustomPolicyResponse>()
                            .withOperationName("GetContextKeysForCustomPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContextKeysForCustomPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContextKeysForCustomPolicyRequest));
            CompletableFuture<GetContextKeysForCustomPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use
     * <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call
     * <a>SimulatePrincipalPolicy</a>.
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     * @return A Java Future containing the result of the GetContextKeysForPrincipalPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForPrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContextKeysForPrincipalPolicyResponse> getContextKeysForPrincipalPolicy(
            GetContextKeysForPrincipalPolicyRequest getContextKeysForPrincipalPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContextKeysForPrincipalPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContextKeysForPrincipalPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContextKeysForPrincipalPolicy");

            HttpResponseHandler<GetContextKeysForPrincipalPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetContextKeysForPrincipalPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetContextKeysForPrincipalPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContextKeysForPrincipalPolicyRequest, GetContextKeysForPrincipalPolicyResponse>()
                            .withOperationName("GetContextKeysForPrincipalPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContextKeysForPrincipalPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContextKeysForPrincipalPolicyRequest));
            CompletableFuture<GetContextKeysForPrincipalPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getCredentialReportRequest
     * @return A Java Future containing the result of the GetCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CredentialReportNotPresentException The request was rejected because the credential report does not
     *         exist. To generate a credential report, use <a>GenerateCredentialReport</a>.</li>
     *         <li>CredentialReportExpiredException The request was rejected because the most recent credential report
     *         has expired. To generate a new credential report, use <a>GenerateCredentialReport</a>. For more
     *         information about credential report expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.</li>
     *         <li>CredentialReportNotReadyException The request was rejected because the credential report is still
     *         being generated.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCredentialReportResponse> getCredentialReport(
            GetCredentialReportRequest getCredentialReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCredentialReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCredentialReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCredentialReport");

            HttpResponseHandler<GetCredentialReportResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetCredentialReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetCredentialReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCredentialReportRequest, GetCredentialReportResponse>()
                            .withOperationName("GetCredentialReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCredentialReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCredentialReportRequest));
            CompletableFuture<GetCredentialReportResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>().withOperationName("GetGroup")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupRequest));
            CompletableFuture<GetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a>GetPolicy</a> to determine the policy's default version, then use
     * <a>GetPolicyVersion</a> to retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getGroupPolicyRequest
     * @return A Java Future containing the result of the GetGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupPolicyResponse> getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroupPolicy");

            HttpResponseHandler<GetGroupPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupPolicyRequest, GetGroupPolicyResponse>()
                            .withOperationName("GetGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGroupPolicyRequest));
            CompletableFuture<GetGroupPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return A Java Future containing the result of the GetInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceProfileResponse> getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceProfile");

            HttpResponseHandler<GetInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceProfileRequest, GetInstanceProfileResponse>()
                            .withOperationName("GetInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInstanceProfileRequest));
            CompletableFuture<GetInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the
     * user to access the Amazon Web Services Management Console. If the user does not exist or does not have a
     * password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     * <p>
     * If you create an IAM user with access to the console, the <code>CreateDate</code> reflects the date you created
     * the initial password for the user.
     * </p>
     * <p>
     * If you create an IAM user with programmatic access, and then later add a password for the user to access the
     * Amazon Web Services Management Console, the <code>CreateDate</code> reflects the initial password creation date.
     * A user with programmatic access does not have a login profile unless you create a password for the user to access
     * the Amazon Web Services Management Console.
     * </p>
     *
     * @param getLoginProfileRequest
     * @return A Java Future containing the result of the GetLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoginProfileResponse> getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLoginProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoginProfile");

            HttpResponseHandler<GetLoginProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetLoginProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetLoginProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoginProfileRequest, GetLoginProfileResponse>()
                            .withOperationName("GetLoginProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLoginProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLoginProfileRequest));
            CompletableFuture<GetLoginProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an MFA device for a specified user.
     * </p>
     *
     * @param getMfaDeviceRequest
     * @return A Java Future containing the result of the GetMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMfaDeviceResponse> getMFADevice(GetMfaDeviceRequest getMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMfaDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMFADevice");

            HttpResponseHandler<GetMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMfaDeviceRequest, GetMfaDeviceResponse>()
                            .withOperationName("GetMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMfaDeviceRequest));
            CompletableFuture<GetMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the GetOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOpenIdConnectProviderResponse> getOpenIDConnectProvider(
            GetOpenIdConnectProviderRequest getOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpenIDConnectProvider");

            HttpResponseHandler<GetOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOpenIdConnectProviderRequest, GetOpenIdConnectProviderResponse>()
                            .withOperationName("GetOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOpenIdConnectProviderRequest));
            CompletableFuture<GetOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for Organizations that was previously generated using the
     * <code> <a>GenerateOrganizationsAccessReport</a> </code> operation. This operation retrieves the status of your
     * report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a>GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be
     * enabled for your organization root. You must have permissions to perform this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining
     * permissions using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root user, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     * @return A Java Future containing the result of the GetOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationsAccessReportResponse> getOrganizationsAccessReport(
            GetOrganizationsAccessReportRequest getOrganizationsAccessReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOrganizationsAccessReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOrganizationsAccessReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationsAccessReport");

            HttpResponseHandler<GetOrganizationsAccessReportResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetOrganizationsAccessReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetOrganizationsAccessReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationsAccessReportRequest, GetOrganizationsAccessReportResponse>()
                            .withOperationName("GetOrganizationsAccessReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOrganizationsAccessReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOrganizationsAccessReportRequest));
            CompletableFuture<GetOrganizationsAccessReportResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use <a>ListEntitiesForPolicy</a>. This operation returns
     * metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use
     * <a>GetPolicyVersion</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded with an IAM user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or
     * <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");

            HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>().withOperationName("GetPolicy")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPolicyRequest));
            CompletableFuture<GetPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded in a user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyVersionRequest
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicyVersion");

            HttpResponseHandler<GetPolicyVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetPolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetPolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPolicyVersionRequest, GetPolicyVersionResponse>()
                            .withOperationName("GetPolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPolicyVersionRequest));
            CompletableFuture<GetPolicyVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     *
     * @param getRoleRequest
     * @return A Java Future containing the result of the GetRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRoleResponse> getRole(GetRoleRequest getRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRole");

            HttpResponseHandler<GetRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRoleRequest, GetRoleResponse>().withOperationName("GetRole")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRoleRequest));
            CompletableFuture<GetRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a>GetPolicy</a> to determine the policy's default version, then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getRolePolicyRequest
     * @return A Java Future containing the result of the GetRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRolePolicyResponse> getRolePolicy(GetRolePolicyRequest getRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRolePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRolePolicy");

            HttpResponseHandler<GetRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRolePolicyRequest, GetRolePolicyResponse>()
                            .withOperationName("GetRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRolePolicyRequest));
            CompletableFuture<GetRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param getSamlProviderRequest
     * @return A Java Future containing the result of the GetSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSamlProviderResponse> getSAMLProvider(GetSamlProviderRequest getSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSAMLProvider");

            HttpResponseHandler<GetSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSamlProviderRequest, GetSamlProviderResponse>()
                            .withOperationName("GetSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSamlProviderRequest));
            CompletableFuture<GetSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param getSshPublicKeyRequest
     * @return A Java Future containing the result of the GetSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnrecognizedPublicKeyEncodingException The request was rejected because the public key encoding
     *         format is unsupported or unrecognized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSshPublicKeyResponse> getSSHPublicKey(GetSshPublicKeyRequest getSshPublicKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSshPublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSSHPublicKey");

            HttpResponseHandler<GetSshPublicKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetSshPublicKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetSshPublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSshPublicKeyRequest, GetSshPublicKeyResponse>()
                            .withOperationName("GetSSHPublicKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSshPublicKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSshPublicKeyRequest));
            CompletableFuture<GetSshPublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of Amazon Web Services services that
     * can use the server certificates that you manage with IAM.
     * </p>
     *
     * @param getServerCertificateRequest
     * @return A Java Future containing the result of the GetServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetServerCertificateResponse> getServerCertificate(
            GetServerCertificateRequest getServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServerCertificate");

            HttpResponseHandler<GetServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServerCertificateRequest, GetServerCertificateResponse>()
                            .withOperationName("GetServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServerCertificateRequest));
            CompletableFuture<GetServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that
     * the resource (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     * @return A Java Future containing the result of the GetServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceLastAccessedDetailsResponse> getServiceLastAccessedDetails(
            GetServiceLastAccessedDetailsRequest getServiceLastAccessedDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServiceLastAccessedDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLastAccessedDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLastAccessedDetails");

            HttpResponseHandler<GetServiceLastAccessedDetailsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetServiceLastAccessedDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetServiceLastAccessedDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceLastAccessedDetailsRequest, GetServiceLastAccessedDetailsResponse>()
                            .withOperationName("GetServiceLastAccessedDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetServiceLastAccessedDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServiceLastAccessedDetailsRequest));
            CompletableFuture<GetServiceLastAccessedDetailsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     * @return A Java Future containing the result of the GetServiceLastAccessedDetailsWithEntities operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceLastAccessedDetailsWithEntitiesResponse> getServiceLastAccessedDetailsWithEntities(
            GetServiceLastAccessedDetailsWithEntitiesRequest getServiceLastAccessedDetailsWithEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getServiceLastAccessedDetailsWithEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLastAccessedDetailsWithEntitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLastAccessedDetailsWithEntities");

            HttpResponseHandler<GetServiceLastAccessedDetailsWithEntitiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetServiceLastAccessedDetailsWithEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetServiceLastAccessedDetailsWithEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceLastAccessedDetailsWithEntitiesRequest, GetServiceLastAccessedDetailsWithEntitiesResponse>()
                            .withOperationName("GetServiceLastAccessedDetailsWithEntities")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetServiceLastAccessedDetailsWithEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServiceLastAccessedDetailsWithEntitiesRequest));
            CompletableFuture<GetServiceLastAccessedDetailsWithEntitiesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use <a>DeleteServiceLinkedRole</a> to submit
     * a service-linked role for deletion, you can use the <code>DeletionTaskId</code> parameter in
     * <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of the deletion. If the deletion fails, this
     * operation returns the reason that it failed, if that information is returned by the service.
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     * @return A Java Future containing the result of the GetServiceLinkedRoleDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceLinkedRoleDeletionStatusResponse> getServiceLinkedRoleDeletionStatus(
            GetServiceLinkedRoleDeletionStatusRequest getServiceLinkedRoleDeletionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getServiceLinkedRoleDeletionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLinkedRoleDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLinkedRoleDeletionStatus");

            HttpResponseHandler<GetServiceLinkedRoleDeletionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetServiceLinkedRoleDeletionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetServiceLinkedRoleDeletionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceLinkedRoleDeletionStatusRequest, GetServiceLinkedRoleDeletionStatusResponse>()
                            .withOperationName("GetServiceLinkedRoleDeletionStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetServiceLinkedRoleDeletionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getServiceLinkedRoleDeletionStatusRequest));
            CompletableFuture<GetServiceLinkedRoleDeletionStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID used to sign the request to this operation.
     * </p>
     *
     * @param getUserRequest
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");

            HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>().withOperationName("GetUser")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserRequest));
            CompletableFuture<GetUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a>GetPolicy</a> to determine the policy's default version. Then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getUserPolicyRequest
     * @return A Java Future containing the result of the GetUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserPolicyResponse> getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserPolicy");

            HttpResponseHandler<GetUserPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetUserPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetUserPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserPolicyRequest, GetUserPolicyResponse>()
                            .withOperationName("GetUserPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserPolicyRequest));
            CompletableFuture<GetUserPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. If a temporary access key is used, then <code>UserName</code> is
     * required. If a long-term key is assigned to the user, then <code>UserName</code> is not required.
     * </p>
     * <p>
     * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account
     * has no associated users, the root user returns it's own access key IDs by running this command.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation.
     * </p>
     * </note>
     *
     * @param listAccessKeysRequest
     * @return A Java Future containing the result of the ListAccessKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessKeysResponse> listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessKeys");

            HttpResponseHandler<ListAccessKeysResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAccessKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAccessKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessKeysRequest, ListAccessKeysResponse>()
                            .withOperationName("ListAccessKeys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccessKeysRequest));
            CompletableFuture<ListAccessKeysResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For
     * information about using an Amazon Web Services account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/console_account-alias.html#CreateAccountAlias">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return A Java Future containing the result of the ListAccountAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountAliasesResponse> listAccountAliases(ListAccountAliasesRequest listAccountAliasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccountAliasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAliases");

            HttpResponseHandler<ListAccountAliasesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAccountAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAccountAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountAliasesRequest, ListAccountAliasesResponse>()
                            .withOperationName("ListAccountAliases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccountAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccountAliasesRequest));
            CompletableFuture<ListAccountAliasesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use
     * <a>ListGroupPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAttachedGroupPoliciesResponse> listAttachedGroupPolicies(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachedGroupPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedGroupPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedGroupPolicies");

            HttpResponseHandler<ListAttachedGroupPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAttachedGroupPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAttachedGroupPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAttachedGroupPoliciesRequest, ListAttachedGroupPoliciesResponse>()
                            .withOperationName("ListAttachedGroupPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAttachedGroupPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAttachedGroupPoliciesRequest));
            CompletableFuture<ListAttachedGroupPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use
     * <a>ListRolePolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return A Java Future containing the result of the ListAttachedRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAttachedRolePoliciesResponse> listAttachedRolePolicies(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachedRolePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedRolePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedRolePolicies");

            HttpResponseHandler<ListAttachedRolePoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAttachedRolePoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAttachedRolePoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAttachedRolePoliciesRequest, ListAttachedRolePoliciesResponse>()
                            .withOperationName("ListAttachedRolePolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAttachedRolePoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAttachedRolePoliciesRequest));
            CompletableFuture<ListAttachedRolePoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use
     * <a>ListUserPolicies</a>. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedUserPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAttachedUserPoliciesResponse> listAttachedUserPolicies(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachedUserPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedUserPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedUserPolicies");

            HttpResponseHandler<ListAttachedUserPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAttachedUserPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAttachedUserPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAttachedUserPoliciesRequest, ListAttachedUserPoliciesResponse>()
                            .withOperationName("ListAttachedUserPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAttachedUserPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAttachedUserPoliciesRequest));
            CompletableFuture<ListAttachedUserPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return A Java Future containing the result of the ListEntitiesForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntitiesForPolicyResponse> listEntitiesForPolicy(
            ListEntitiesForPolicyRequest listEntitiesForPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitiesForPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesForPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitiesForPolicy");

            HttpResponseHandler<ListEntitiesForPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListEntitiesForPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListEntitiesForPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntitiesForPolicyRequest, ListEntitiesForPolicyResponse>()
                            .withOperationName("ListEntitiesForPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntitiesForPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntitiesForPolicyRequest));
            CompletableFuture<ListEntitiesForPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return A Java Future containing the result of the ListGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupPoliciesResponse> listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupPolicies");

            HttpResponseHandler<ListGroupPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListGroupPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListGroupPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupPoliciesRequest, ListGroupPoliciesResponse>()
                            .withOperationName("ListGroupPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupPoliciesRequest));
            CompletableFuture<ListGroupPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return A Java Future containing the result of the ListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsForUserResponse> listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupsForUser");

            HttpResponseHandler<ListGroupsForUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListGroupsForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListGroupsForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsForUserRequest, ListGroupsForUserResponse>()
                            .withOperationName("ListGroupsForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsForUserRequest));
            CompletableFuture<ListGroupsForUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     * @return A Java Future containing the result of the ListInstanceProfileTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInstanceProfileTagsResponse> listInstanceProfileTags(
            ListInstanceProfileTagsRequest listInstanceProfileTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInstanceProfileTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfileTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfileTags");

            HttpResponseHandler<ListInstanceProfileTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListInstanceProfileTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListInstanceProfileTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInstanceProfileTagsRequest, ListInstanceProfileTagsResponse>()
                            .withOperationName("ListInstanceProfileTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInstanceProfileTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInstanceProfileTagsRequest));
            CompletableFuture<ListInstanceProfileTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a>GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles(
            ListInstanceProfilesRequest listInstanceProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInstanceProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfiles");

            HttpResponseHandler<ListInstanceProfilesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListInstanceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListInstanceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInstanceProfilesRequest, ListInstanceProfilesResponse>()
                            .withOperationName("ListInstanceProfiles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInstanceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInstanceProfilesRequest));
            CompletableFuture<ListInstanceProfilesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return A Java Future containing the result of the ListInstanceProfilesForRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInstanceProfilesForRoleResponse> listInstanceProfilesForRole(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInstanceProfilesForRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfilesForRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfilesForRole");

            HttpResponseHandler<ListInstanceProfilesForRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListInstanceProfilesForRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListInstanceProfilesForRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInstanceProfilesForRoleRequest, ListInstanceProfilesForRoleResponse>()
                            .withOperationName("ListInstanceProfilesForRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInstanceProfilesForRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInstanceProfilesForRoleRequest));
            CompletableFuture<ListInstanceProfilesForRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     * @return A Java Future containing the result of the ListMFADeviceTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMfaDeviceTagsResponse> listMFADeviceTags(ListMfaDeviceTagsRequest listMfaDeviceTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMfaDeviceTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMfaDeviceTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMFADeviceTags");

            HttpResponseHandler<ListMfaDeviceTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListMfaDeviceTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListMfaDeviceTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMfaDeviceTagsRequest, ListMfaDeviceTagsResponse>()
                            .withOperationName("ListMFADeviceTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMfaDeviceTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMfaDeviceTagsRequest));
            CompletableFuture<ListMfaDeviceTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the Amazon Web Services access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return A Java Future containing the result of the ListMFADevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMfaDevicesResponse> listMFADevices(ListMfaDevicesRequest listMfaDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMfaDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMfaDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMFADevices");

            HttpResponseHandler<ListMfaDevicesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListMfaDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListMfaDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMfaDevicesRequest, ListMfaDevicesResponse>()
                            .withOperationName("ListMFADevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMfaDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMfaDevicesRequest));
            CompletableFuture<ListMfaDevicesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The
     * returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     * @return A Java Future containing the result of the ListOpenIDConnectProviderTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpenIdConnectProviderTagsResponse> listOpenIDConnectProviderTags(
            ListOpenIdConnectProviderTagsRequest listOpenIdConnectProviderTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOpenIdConnectProviderTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOpenIdConnectProviderTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpenIDConnectProviderTags");

            HttpResponseHandler<ListOpenIdConnectProviderTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListOpenIdConnectProviderTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListOpenIdConnectProviderTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpenIdConnectProviderTagsRequest, ListOpenIdConnectProviderTagsResponse>()
                            .withOperationName("ListOpenIDConnectProviderTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOpenIdConnectProviderTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOpenIdConnectProviderTagsRequest));
            CompletableFuture<ListOpenIdConnectProviderTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web
     * Services account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a>GetOpenIDConnectProvider</a>.
     * </p>
     * </note>
     *
     * @param listOpenIdConnectProvidersRequest
     * @return A Java Future containing the result of the ListOpenIDConnectProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOpenIdConnectProvidersResponse> listOpenIDConnectProviders(
            ListOpenIdConnectProvidersRequest listOpenIdConnectProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOpenIdConnectProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpenIdConnectProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpenIDConnectProviders");

            HttpResponseHandler<ListOpenIdConnectProvidersResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListOpenIdConnectProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListOpenIdConnectProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOpenIdConnectProvidersRequest, ListOpenIdConnectProvidersResponse>()
                            .withOperationName("ListOpenIDConnectProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOpenIdConnectProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOpenIdConnectProvidersRequest));
            CompletableFuture<ListOpenIdConnectProvidersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the centralized root access features enabled for your organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a>.
     * </p>
     *
     * @param listOrganizationsFeaturesRequest
     * @return A Java Future containing the result of the ListOrganizationsFeatures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOrganizationsFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOrganizationsFeatures" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationsFeaturesResponse> listOrganizationsFeatures(
            ListOrganizationsFeaturesRequest listOrganizationsFeaturesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOrganizationsFeaturesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOrganizationsFeaturesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizationsFeatures");

            HttpResponseHandler<ListOrganizationsFeaturesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListOrganizationsFeaturesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListOrganizationsFeaturesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationsFeaturesRequest, ListOrganizationsFeaturesResponse>()
                            .withOperationName("ListOrganizationsFeatures").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOrganizationsFeaturesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOrganizationsFeaturesRequest));
            CompletableFuture<ListOrganizationsFeaturesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your Amazon Web Services account, including your own
     * customer-defined managed policies and all Amazon Web Services managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your Amazon Web Services account, set <code>Scope</code> to <code>Local</code>. To list only Amazon
     * Web Services managed policies, set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a>GetPolicy</a>.
     * </p>
     * </note>
     *
     * @param listPoliciesRequest
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicies");

            HttpResponseHandler<ListPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPoliciesRequest, ListPoliciesResponse>()
                            .withOperationName("ListPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPoliciesRequest));
            CompletableFuture<ListPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation
     * of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a>GetUser</a> or
     * <a>GetRole</a> operations.
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     * @return A Java Future containing the result of the ListPoliciesGrantingServiceAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPoliciesGrantingServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPoliciesGrantingServiceAccessResponse> listPoliciesGrantingServiceAccess(
            ListPoliciesGrantingServiceAccessRequest listPoliciesGrantingServiceAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPoliciesGrantingServiceAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPoliciesGrantingServiceAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPoliciesGrantingServiceAccess");

            HttpResponseHandler<ListPoliciesGrantingServiceAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListPoliciesGrantingServiceAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListPoliciesGrantingServiceAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPoliciesGrantingServiceAccessRequest, ListPoliciesGrantingServiceAccessResponse>()
                            .withOperationName("ListPoliciesGrantingServiceAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPoliciesGrantingServiceAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPoliciesGrantingServiceAccessRequest));
            CompletableFuture<ListPoliciesGrantingServiceAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listPolicyTagsRequest
     * @return A Java Future containing the result of the ListPolicyTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPolicyTagsResponse> listPolicyTags(ListPolicyTagsRequest listPolicyTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPolicyTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPolicyTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicyTags");

            HttpResponseHandler<ListPolicyTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListPolicyTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListPolicyTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPolicyTagsRequest, ListPolicyTagsResponse>()
                            .withOperationName("ListPolicyTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPolicyTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPolicyTagsRequest));
            CompletableFuture<ListPolicyTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPolicyVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPolicyVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicyVersions");

            HttpResponseHandler<ListPolicyVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListPolicyVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListPolicyVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPolicyVersionsRequest, ListPolicyVersionsResponse>()
                            .withOperationName("ListPolicyVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPolicyVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPolicyVersionsRequest));
            CompletableFuture<ListPolicyVersionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return A Java Future containing the result of the ListRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRolePoliciesResponse> listRolePolicies(ListRolePoliciesRequest listRolePoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRolePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRolePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRolePolicies");

            HttpResponseHandler<ListRolePoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListRolePoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListRolePoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRolePoliciesRequest, ListRolePoliciesResponse>()
                            .withOperationName("ListRolePolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRolePoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRolePoliciesRequest));
            CompletableFuture<ListRolePoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM resources</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listRoleTagsRequest
     * @return A Java Future containing the result of the ListRoleTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRoleTagsResponse> listRoleTags(ListRoleTagsRequest listRoleTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRoleTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRoleTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRoleTags");

            HttpResponseHandler<ListRoleTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListRoleTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListRoleTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRoleTagsRequest, ListRoleTagsResponse>()
                            .withOperationName("ListRoleTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRoleTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRoleTagsRequest));
            CompletableFuture<ListRoleTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does
     * not return the following attributes, even though they are an attribute of the returned object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PermissionsBoundary
     * </p>
     * </li>
     * <li>
     * <p>
     * RoleLastUsed
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * </ul>
     * <p>
     * To view all of the information for a role, see <a>GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listRolesRequest
     * @return A Java Future containing the result of the ListRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRolesResponse> listRoles(ListRolesRequest listRolesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRolesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRoles");

            HttpResponseHandler<ListRolesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListRolesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListRolesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRolesRequest, ListRolesResponse>().withOperationName("ListRoles")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRolesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listRolesRequest));
            CompletableFuture<ListRolesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider.
     * The returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listSamlProviderTagsRequest
     * @return A Java Future containing the result of the ListSAMLProviderTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListSAMLProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviderTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSamlProviderTagsResponse> listSAMLProviderTags(
            ListSamlProviderTagsRequest listSamlProviderTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSamlProviderTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSamlProviderTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSAMLProviderTags");

            HttpResponseHandler<ListSamlProviderTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListSamlProviderTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListSamlProviderTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSamlProviderTagsRequest, ListSamlProviderTagsResponse>()
                            .withOperationName("ListSAMLProviderTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSamlProviderTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSamlProviderTagsRequest));
            CompletableFuture<ListSamlProviderTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a
     * subset of the available attributes for the resource. For example, this operation does not return tags, even
     * though they are an attribute of the returned object. To view all of the information for a SAML provider, see
     * <a>GetSAMLProvider</a>.
     * </p>
     * <important>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </important>
     *
     * @param listSamlProvidersRequest
     * @return A Java Future containing the result of the ListSAMLProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListSAMLProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSamlProvidersResponse> listSAMLProviders(ListSamlProvidersRequest listSamlProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSamlProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSamlProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSAMLProviders");

            HttpResponseHandler<ListSamlProvidersResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListSamlProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListSamlProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSamlProvidersRequest, ListSamlProvidersResponse>()
                            .withOperationName("ListSAMLProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSamlProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSamlProvidersRequest));
            CompletableFuture<ListSamlProvidersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an CodeCommit
     * repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit
     * for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listSshPublicKeysRequest
     * @return A Java Future containing the result of the ListSSHPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListSSHPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSshPublicKeysResponse> listSSHPublicKeys(ListSshPublicKeysRequest listSshPublicKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSshPublicKeysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSshPublicKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSSHPublicKeys");

            HttpResponseHandler<ListSshPublicKeysResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListSshPublicKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListSshPublicKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSshPublicKeysRequest, ListSshPublicKeysResponse>()
                            .withOperationName("ListSSHPublicKeys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSshPublicKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSshPublicKeysRequest));
            CompletableFuture<ListSshPublicKeysResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server
     * certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information
     * about IAM server certificates, <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param listServerCertificateTagsRequest
     * @return A Java Future containing the result of the ListServerCertificateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListServerCertificateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificateTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServerCertificateTagsResponse> listServerCertificateTags(
            ListServerCertificateTagsRequest listServerCertificateTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listServerCertificateTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServerCertificateTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServerCertificateTags");

            HttpResponseHandler<ListServerCertificateTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListServerCertificateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListServerCertificateTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServerCertificateTagsRequest, ListServerCertificateTagsResponse>()
                            .withOperationName("ListServerCertificateTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListServerCertificateTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listServerCertificateTagsRequest));
            CompletableFuture<ListServerCertificateTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of Amazon Web Services services
     * that can use the server certificates that you manage with IAM.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a servercertificate, see <a>GetServerCertificate</a>.
     * </p>
     * </note>
     *
     * @param listServerCertificatesRequest
     * @return A Java Future containing the result of the ListServerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListServerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServerCertificatesResponse> listServerCertificates(
            ListServerCertificatesRequest listServerCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listServerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServerCertificates");

            HttpResponseHandler<ListServerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListServerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListServerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServerCertificatesRequest, ListServerCertificatesResponse>()
                            .withOperationName("ListServerCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListServerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listServerCertificatesRequest));
            CompletableFuture<ListServerCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the service-specific credentials associated with the specified IAM user. If none
     * exists, the operation returns an empty list. The service-specific credentials returned by this operation are used
     * only for authenticating the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an Amazon Web Services service, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific
     * credentials</a> in the CodeCommit User Guide.
     * </p>
     *
     * @param listServiceSpecificCredentialsRequest
     * @return A Java Future containing the result of the ListServiceSpecificCredentials operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceNotSupportedException The specified service does not support service-specific credentials.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListServiceSpecificCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServiceSpecificCredentialsResponse> listServiceSpecificCredentials(
            ListServiceSpecificCredentialsRequest listServiceSpecificCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listServiceSpecificCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listServiceSpecificCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceSpecificCredentials");

            HttpResponseHandler<ListServiceSpecificCredentialsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListServiceSpecificCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListServiceSpecificCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServiceSpecificCredentialsRequest, ListServiceSpecificCredentialsResponse>()
                            .withOperationName("ListServiceSpecificCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListServiceSpecificCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listServiceSpecificCredentialsRequest));
            CompletableFuture<ListServiceSpecificCredentialsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the Amazon
     * Web Services access key ID used to sign the request for this operation. This operation works for access keys
     * under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services
     * account root user credentials even if the Amazon Web Services account has no associated users.
     * </p>
     *
     * @param listSigningCertificatesRequest
     * @return A Java Future containing the result of the ListSigningCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListSigningCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSigningCertificatesResponse> listSigningCertificates(
            ListSigningCertificatesRequest listSigningCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSigningCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSigningCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSigningCertificates");

            HttpResponseHandler<ListSigningCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListSigningCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListSigningCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSigningCertificatesRequest, ListSigningCertificatesResponse>()
                            .withOperationName("ListSigningCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSigningCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSigningCertificatesRequest));
            CompletableFuture<ListSigningCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     *
     * @param listUserPoliciesRequest
     * @return A Java Future containing the result of the ListUserPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoliciesResponse> listUserPolicies(ListUserPoliciesRequest listUserPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPolicies");

            HttpResponseHandler<ListUserPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListUserPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListUserPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserPoliciesRequest, ListUserPoliciesResponse>()
                            .withOperationName("ListUserPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserPoliciesRequest));
            CompletableFuture<ListUserPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For
     * more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listUserTagsRequest
     * @return A Java Future containing the result of the ListUserTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListUserTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserTagsResponse> listUserTags(ListUserTagsRequest listUserTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserTags");

            HttpResponseHandler<ListUserTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListUserTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListUserTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserTagsRequest, ListUserTagsResponse>()
                            .withOperationName("ListUserTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserTagsRequest));
            CompletableFuture<ListUserTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the Amazon Web Services account. If there are none, the operation returns an empty list.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does
     * not return the following attributes, even though they are an attribute of the returned object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PermissionsBoundary
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * </ul>
     * <p>
     * To view all of the information for a user, see <a>GetUser</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If you do not
     * specify an assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view tag information
     * for a virtual MFA device, see <a>ListMFADeviceTags</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     * @return A Java Future containing the result of the ListVirtualMFADevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListVirtualMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListVirtualMfaDevicesResponse> listVirtualMFADevices(
            ListVirtualMfaDevicesRequest listVirtualMfaDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVirtualMfaDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVirtualMfaDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVirtualMFADevices");

            HttpResponseHandler<ListVirtualMfaDevicesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListVirtualMfaDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListVirtualMfaDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVirtualMfaDevicesRequest, ListVirtualMfaDevicesResponse>()
                            .withOperationName("ListVirtualMFADevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVirtualMfaDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVirtualMfaDevicesRequest));
            CompletableFuture<ListVirtualMfaDevicesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To attach a managed policy to a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html">
     * <code>AttachGroupPolicy</code> </a>. To create a new managed policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html"> <code>CreatePolicy</code> </a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed in a group, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutGroupPolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putGroupPolicyRequest
     * @return A Java Future containing the result of the PutGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.PutGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutGroupPolicyResponse> putGroupPolicy(PutGroupPolicyRequest putGroupPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putGroupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGroupPolicy");

            HttpResponseHandler<PutGroupPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutGroupPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutGroupPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutGroupPolicyRequest, PutGroupPolicyResponse>()
                            .withOperationName("PutGroupPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutGroupPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putGroupPolicyRequest));
            CompletableFuture<PutGroupPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an Amazon Web
     * Services managed policy or a customer managed policy to set the boundary for a role. Use the boundary to control
     * the maximum permissions that the role can have. Setting a permissions boundary is an advanced feature that can
     * affect the permissions for the role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to
     * the role. To learn how the effective permissions for a role are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putRolePermissionsBoundaryRequest
     * @return A Java Future containing the result of the PutRolePermissionsBoundary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.PutRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRolePermissionsBoundaryResponse> putRolePermissionsBoundary(
            PutRolePermissionsBoundaryRequest putRolePermissionsBoundaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRolePermissionsBoundaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRolePermissionsBoundaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRolePermissionsBoundary");

            HttpResponseHandler<PutRolePermissionsBoundaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutRolePermissionsBoundaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutRolePermissionsBoundaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRolePermissionsBoundaryRequest, PutRolePermissionsBoundaryResponse>()
                            .withOperationName("PutRolePermissionsBoundary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRolePermissionsBoundaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRolePermissionsBoundaryRequest));
            CompletableFuture<PutRolePermissionsBoundaryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM role.
     * </p>
     * <p>
     * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions)
     * policy. The role's trust policy is created at the same time as the role, using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html"> <code>CreateRole</code> </a>. You
     * can update a role's trust policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html">
     * <code>UpdateAssumeRolePolicy</code> </a>. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">IAM roles</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <p>
     * A role can also have a managed policy attached to it. To attach a managed policy to a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html">
     * <code>AttachRolePolicy</code> </a>. To create a new managed policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html"> <code>CreatePolicy</code> </a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed with a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutRolePolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putRolePolicyRequest
     * @return A Java Future containing the result of the PutRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.PutRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutRolePolicyResponse> putRolePolicy(PutRolePolicyRequest putRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRolePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRolePolicy");

            HttpResponseHandler<PutRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRolePolicyRequest, PutRolePolicyResponse>()
                            .withOperationName("PutRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRolePolicyRequest));
            CompletableFuture<PutRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an Amazon Web
     * Services managed policy or a customer managed policy to set the boundary for a user. Use the boundary to control
     * the maximum permissions that the user can have. Setting a permissions boundary is an advanced feature that can
     * affect the permissions for the user.
     * </p>
     * <important>
     * <p>
     * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions
     * policy to the user. To learn how the effective permissions for a user are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
     * evaluation logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putUserPermissionsBoundaryRequest
     * @return A Java Future containing the result of the PutUserPermissionsBoundary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.PutUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutUserPermissionsBoundaryResponse> putUserPermissionsBoundary(
            PutUserPermissionsBoundaryRequest putUserPermissionsBoundaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putUserPermissionsBoundaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putUserPermissionsBoundaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutUserPermissionsBoundary");

            HttpResponseHandler<PutUserPermissionsBoundaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutUserPermissionsBoundaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutUserPermissionsBoundaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutUserPermissionsBoundaryRequest, PutUserPermissionsBoundaryResponse>()
                            .withOperationName("PutUserPermissionsBoundary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutUserPermissionsBoundaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putUserPermissionsBoundaryRequest));
            CompletableFuture<PutUserPermissionsBoundaryResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html">
     * <code>AttachUserPolicy</code> </a>. To create a new managed policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html"> <code>CreatePolicy</code> </a>.
     * For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of inline policies that you can embed in a user, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutUserPolicy</code>. For general information about using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putUserPolicyRequest
     * @return A Java Future containing the result of the PutUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.PutUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutUserPolicyResponse> putUserPolicy(PutUserPolicyRequest putUserPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putUserPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutUserPolicy");

            HttpResponseHandler<PutUserPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutUserPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutUserPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutUserPolicyRequest, PutUserPolicyResponse>()
                            .withOperationName("PutUserPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutUserPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putUserPolicyRequest));
            CompletableFuture<PutUserPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified
     * IAM OpenID Connect (OIDC) provider resource object.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you try to remove a client ID that does not
     * exist.
     * </p>
     *
     * @param removeClientIdFromOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the RemoveClientIDFromOpenIDConnectProvider operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.RemoveClientIDFromOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveClientIdFromOpenIdConnectProviderResponse> removeClientIDFromOpenIDConnectProvider(
            RemoveClientIdFromOpenIdConnectProviderRequest removeClientIdFromOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeClientIdFromOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeClientIdFromOpenIdConnectProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveClientIDFromOpenIDConnectProvider");

            HttpResponseHandler<RemoveClientIdFromOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveClientIdFromOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveClientIdFromOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveClientIdFromOpenIdConnectProviderRequest, RemoveClientIdFromOpenIdConnectProviderResponse>()
                            .withOperationName("RemoveClientIDFromOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveClientIdFromOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeClientIdFromOpenIdConnectProviderRequest));
            CompletableFuture<RemoveClientIdFromOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified IAM role from the specified Amazon EC2 instance profile.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to remove from the
     * instance profile. Removing a role from an instance profile that is associated with a running instance might break
     * any applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param removeRoleFromInstanceProfileRequest
     * @return A Java Future containing the result of the RemoveRoleFromInstanceProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.RemoveRoleFromInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveRoleFromInstanceProfileResponse> removeRoleFromInstanceProfile(
            RemoveRoleFromInstanceProfileRequest removeRoleFromInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeRoleFromInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeRoleFromInstanceProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromInstanceProfile");

            HttpResponseHandler<RemoveRoleFromInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveRoleFromInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveRoleFromInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromInstanceProfileRequest, RemoveRoleFromInstanceProfileResponse>()
                            .withOperationName("RemoveRoleFromInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveRoleFromInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeRoleFromInstanceProfileRequest));
            CompletableFuture<RemoveRoleFromInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     *
     * @param removeUserFromGroupRequest
     * @return A Java Future containing the result of the RemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.RemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveUserFromGroupResponse> removeUserFromGroup(
            RemoveUserFromGroupRequest removeUserFromGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeUserFromGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeUserFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveUserFromGroup");

            HttpResponseHandler<RemoveUserFromGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveUserFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveUserFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>()
                            .withOperationName("RemoveUserFromGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveUserFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeUserFromGroupRequest));
            CompletableFuture<RemoveUserFromGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the password for a service-specific credential. The new password is Amazon Web Services generated and
     * cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the
     * previous password associated with this user.
     * </p>
     *
     * @param resetServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the ResetServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ResetServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetServiceSpecificCredentialResponse> resetServiceSpecificCredential(
            ResetServiceSpecificCredentialRequest resetServiceSpecificCredentialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetServiceSpecificCredentialRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                resetServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetServiceSpecificCredential");

            HttpResponseHandler<ResetServiceSpecificCredentialResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetServiceSpecificCredentialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetServiceSpecificCredentialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetServiceSpecificCredentialRequest, ResetServiceSpecificCredentialResponse>()
                            .withOperationName("ResetServiceSpecificCredential").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResetServiceSpecificCredentialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetServiceSpecificCredentialRequest));
            CompletableFuture<ResetServiceSpecificCredentialResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA device</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param resyncMfaDeviceRequest
     * @return A Java Future containing the result of the ResyncMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidAuthenticationCodeException The request was rejected because the authentication code was not
     *         recognized. The error message describes the specific error.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ResyncMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResyncMfaDeviceResponse> resyncMFADevice(ResyncMfaDeviceRequest resyncMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resyncMfaDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resyncMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResyncMFADevice");

            HttpResponseHandler<ResyncMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResyncMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResyncMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResyncMfaDeviceRequest, ResyncMfaDeviceResponse>()
                            .withOperationName("ResyncMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResyncMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resyncMfaDeviceRequest));
            CompletableFuture<ResyncMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version.
     * </p>
     * <p>
     * This operation affects all users, groups, and roles that the policy is attached to. To list the users, groups,
     * and roles that the policy is attached to, use <a>ListEntitiesForPolicy</a>.
     * </p>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     * @return A Java Future containing the result of the SetDefaultPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.SetDefaultPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetDefaultPolicyVersionResponse> setDefaultPolicyVersion(
            SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setDefaultPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultPolicyVersion");

            HttpResponseHandler<SetDefaultPolicyVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetDefaultPolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetDefaultPolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse>()
                            .withOperationName("SetDefaultPolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetDefaultPolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setDefaultPolicyVersionRequest));
            CompletableFuture<SetDefaultPolicyVersionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified version of the global endpoint token as the token version used for the Amazon Web Services
     * account.
     * </p>
     * <p>
     * By default, Security Token Service (STS) is available as a global service, and all STS requests go to a single
     * endpoint at <code>https://sts.amazonaws.com</code>. Amazon Web Services recommends using Regional STS endpoints
     * to reduce latency, build in redundancy, and increase session token availability. For information about Regional
     * endpoints for STS, see <a href="https://docs.aws.amazon.com/general/latest/gr/sts.html">Security Token Service
     * endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * If you make an STS call to the global endpoint, the resulting session tokens might be valid in some Regions but
     * not others. It depends on the version that is set in this operation. Version 1 tokens are valid only in Amazon
     * Web Services Regions that are available by default. These tokens do not work in manually enabled Regions, such as
     * Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and
     * might affect systems where you temporarily store tokens. For information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating STS in an Amazon Web Services Region</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To view the current session token version, see the <code>GlobalEndpointTokenVersion</code> entry in the response
     * of the <a>GetAccountSummary</a> operation.
     * </p>
     *
     * @param setSecurityTokenServicePreferencesRequest
     * @return A Java Future containing the result of the SetSecurityTokenServicePreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.SetSecurityTokenServicePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetSecurityTokenServicePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSecurityTokenServicePreferencesResponse> setSecurityTokenServicePreferences(
            SetSecurityTokenServicePreferencesRequest setSecurityTokenServicePreferencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setSecurityTokenServicePreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setSecurityTokenServicePreferencesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSecurityTokenServicePreferences");

            HttpResponseHandler<SetSecurityTokenServicePreferencesResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetSecurityTokenServicePreferencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetSecurityTokenServicePreferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSecurityTokenServicePreferencesRequest, SetSecurityTokenServicePreferencesResponse>()
                            .withOperationName("SetSecurityTokenServicePreferences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetSecurityTokenServicePreferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setSecurityTokenServicePreferencesRequest));
            CompletableFuture<SetSecurityTokenServicePreferencesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and
     * Amazon Web Services resources to determine the policies' effective permissions. The policies are provided as
     * strings.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations. You can simulate resources that don't exist in your account.
     * </p>
     * <p>
     * If you want to simulate existing policies that are attached to an IAM user, group, or role, use
     * <a>SimulatePrincipalPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables that are maintained by Amazon Web Services and its services and which provide details
     * about the context of an API query request. You can use the <code>Condition</code> element of an IAM policy to
     * evaluate context keys. To get the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForCustomPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     * <note>
     * <p>
     * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during
     * simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend
     * that you check your policies against your live Amazon Web Services environment after testing using the policy
     * simulator to confirm that you have the desired results. For more information about using the policy simulator,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM
     * policies with the IAM policy simulator </a>in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param simulateCustomPolicyRequest
     * @return A Java Future containing the result of the SimulateCustomPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyEvaluationException The request failed because a provided policy could not be successfully
     *         evaluated. An additional detailed message indicates the source of the failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.SimulateCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SimulateCustomPolicyResponse> simulateCustomPolicy(
            SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(simulateCustomPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, simulateCustomPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SimulateCustomPolicy");

            HttpResponseHandler<SimulateCustomPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(SimulateCustomPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SimulateCustomPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SimulateCustomPolicyRequest, SimulateCustomPolicyResponse>()
                            .withOperationName("SimulateCustomPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SimulateCustomPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(simulateCustomPolicyRequest));
            CompletableFuture<SimulateCustomPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and Amazon Web
     * Services resources to determine the policies' effective permissions. The entity can be an IAM user, group, or
     * role. If you specify a user, then the simulation also includes all of the policies that are attached to groups
     * that the user belongs to. You can simulate resources that don't exist in your account.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies specified as strings to include in the
     * simulation. If you want to simulate only policies specified as strings, use <a>SimulateCustomPolicy</a> instead.
     * </p>
     * <p>
     * You can also optionally include one resource-based policy to be evaluated with each of the resources included in
     * the simulation for IAM users only.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use <a>SimulateCustomPolicy</a>
     * instead.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. You can use the <code>Condition</code> element of an IAM policy to evaluate
     * context keys. To get the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use the <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     * <note>
     * <p>
     * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during
     * simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend
     * that you check your policies against your live Amazon Web Services environment after testing using the policy
     * simulator to confirm that you have the desired results. For more information about using the policy simulator,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM
     * policies with the IAM policy simulator </a>in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param simulatePrincipalPolicyRequest
     * @return A Java Future containing the result of the SimulatePrincipalPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyEvaluationException The request failed because a provided policy could not be successfully
     *         evaluated. An additional detailed message indicates the source of the failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.SimulatePrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SimulatePrincipalPolicyResponse> simulatePrincipalPolicy(
            SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(simulatePrincipalPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, simulatePrincipalPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SimulatePrincipalPolicy");

            HttpResponseHandler<SimulatePrincipalPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(SimulatePrincipalPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SimulatePrincipalPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SimulatePrincipalPolicyRequest, SimulatePrincipalPolicyResponse>()
                            .withOperationName("SimulatePrincipalPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SimulatePrincipalPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(simulatePrincipalPolicyRequest));
            CompletableFuture<SimulatePrincipalPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM instance profile. If a tag with the same key name already exists, then that tag
     * is overwritten with the new value.
     * </p>
     * <p>
     * Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only an IAM instance profile that has a specified tag attached. For examples of policies that show how
     * to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagInstanceProfileRequest
     * @return A Java Future containing the result of the TagInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagInstanceProfileResponse> tagInstanceProfile(TagInstanceProfileRequest tagInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagInstanceProfile");

            HttpResponseHandler<TagInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagInstanceProfileRequest, TagInstanceProfileResponse>()
                            .withOperationName("TagInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagInstanceProfileRequest));
            CompletableFuture<TagInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag with the same key name
     * already exists, then that tag is overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only an IAM virtual MFA device that has a specified tag attached. For examples of policies that show
     * how to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagMfaDeviceRequest
     * @return A Java Future containing the result of the TagMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagMfaDeviceResponse> tagMFADevice(TagMfaDeviceRequest tagMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagMfaDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagMFADevice");

            HttpResponseHandler<TagMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagMfaDeviceRequest, TagMfaDeviceResponse>()
                            .withOperationName("TagMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagMfaDeviceRequest));
            CompletableFuture<TagMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more information about these
     * providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web
     * identity federation</a>. If a tag with the same key name already exists, then that tag is overwritten with the
     * new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM identity-based and resource-based policies. You can use tags to
     * restrict access to only an OIDC provider that has a specified tag attached. For examples of policies that show
     * how to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the TagOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagOpenIdConnectProviderResponse> tagOpenIDConnectProvider(
            TagOpenIdConnectProviderRequest tagOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagOpenIDConnectProvider");

            HttpResponseHandler<TagOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagOpenIdConnectProviderRequest, TagOpenIdConnectProviderResponse>()
                            .withOperationName("TagOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagOpenIdConnectProviderRequest));
            CompletableFuture<TagOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM customer managed policy. If a tag with the same key name already exists, then
     * that tag is overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only an IAM customer managed policy that has a specified tag attached. For examples of policies that
     * show how to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagPolicyRequest
     * @return A Java Future containing the result of the TagPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagPolicyResponse> tagPolicy(TagPolicyRequest tagPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagPolicy");

            HttpResponseHandler<TagPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagPolicyRequest, TagPolicyResponse>().withOperationName("TagPolicy")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagPolicyRequest));
            CompletableFuture<TagPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the
     * same key name already exists, then that tag is overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only an IAM role that has a specified tag attached. You can also restrict access to only those
     * resources that have a certain tag attached. For examples of policies that show how to use tags to control access,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a>
     * in the <i>IAM User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Cost allocation</b> - Use tags to help track which individuals and teams are using which Amazon Web Services
     * resources.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param tagRoleRequest
     * @return A Java Future containing the result of the TagRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagRoleResponse> tagRole(TagRoleRequest tagRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagRole");

            HttpResponseHandler<TagRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagRoleRequest, TagRoleResponse>().withOperationName("TagRole")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new TagRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagRoleRequest));
            CompletableFuture<TagRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information
     * about these providers, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation </a>. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only a SAML identity provider that has a specified tag attached. For examples of policies that show how
     * to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagSamlProviderRequest
     * @return A Java Future containing the result of the TagSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagSamlProviderResponse> tagSAMLProvider(TagSamlProviderRequest tagSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagSAMLProvider");

            HttpResponseHandler<TagSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagSamlProviderRequest, TagSamlProviderResponse>()
                            .withOperationName("TagSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagSamlProviderRequest));
            CompletableFuture<TagSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM server certificate. If a tag with the same key name already exists, then that tag
     * is overwritten with the new value.
     * </p>
     * <note>
     * <p>
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server
     * certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information
     * about IAM server certificates, <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM user-based and resource-based policies. You can use tags to restrict
     * access to only a server certificate that has a specified tag attached. For examples of policies that show how to
     * use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Cost allocation</b> - Use tags to help track which individuals and teams are using which Amazon Web Services
     * resources.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param tagServerCertificateRequest
     * @return A Java Future containing the result of the TagServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagServerCertificateResponse> tagServerCertificate(
            TagServerCertificateRequest tagServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagServerCertificate");

            HttpResponseHandler<TagServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagServerCertificateRequest, TagServerCertificateResponse>()
                            .withOperationName("TagServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagServerCertificateRequest));
            CompletableFuture<TagServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is
     * overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Include tags in IAM identity-based and resource-based policies. You can use tags to
     * restrict access to only an IAM requesting user that has a specified tag attached. You can also restrict access to
     * only those resources that have a certain tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access
     * using IAM tags</a> in the <i>IAM User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Cost allocation</b> - Use tags to help track which individuals and teams are using which Amazon Web Services
     * resources.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
     * fails and the resource is not created. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to store an
     * array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param tagUserRequest
     * @return A Java Future containing the result of the TagUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.TagUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagUserResponse> tagUser(TagUserRequest tagUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagUser");

            HttpResponseHandler<TagUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(TagUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TagUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagUserRequest, TagUserResponse>().withOperationName("TagUser")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new TagUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagUserRequest));
            CompletableFuture<TagUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the IAM instance profile. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagInstanceProfileRequest
     * @return A Java Future containing the result of the UntagInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagInstanceProfileResponse> untagInstanceProfile(
            UntagInstanceProfileRequest untagInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagInstanceProfile");

            HttpResponseHandler<UntagInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagInstanceProfileRequest, UntagInstanceProfileResponse>()
                            .withOperationName("UntagInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagInstanceProfileRequest));
            CompletableFuture<UntagInstanceProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device. For more information
     * about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM
     * resources</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param untagMfaDeviceRequest
     * @return A Java Future containing the result of the UntagMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagMfaDeviceResponse> untagMFADevice(UntagMfaDeviceRequest untagMfaDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagMfaDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagMFADevice");

            HttpResponseHandler<UntagMfaDeviceResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagMfaDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagMfaDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagMfaDeviceRequest, UntagMfaDeviceResponse>()
                            .withOperationName("UntagMFADevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagMfaDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagMfaDeviceRequest));
            CompletableFuture<UntagMfaDeviceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity provider in IAM. For more
     * information about OIDC providers, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the UntagOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagOpenIdConnectProviderResponse> untagOpenIDConnectProvider(
            UntagOpenIdConnectProviderRequest untagOpenIdConnectProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagOpenIdConnectProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagOpenIDConnectProvider");

            HttpResponseHandler<UntagOpenIdConnectProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagOpenIdConnectProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagOpenIdConnectProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagOpenIdConnectProviderRequest, UntagOpenIdConnectProviderResponse>()
                            .withOperationName("UntagOpenIDConnectProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagOpenIdConnectProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagOpenIdConnectProviderRequest));
            CompletableFuture<UntagOpenIdConnectProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the customer managed policy. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagPolicyRequest
     * @return A Java Future containing the result of the UntagPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagPolicyResponse> untagPolicy(UntagPolicyRequest untagPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagPolicy");

            HttpResponseHandler<UntagPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagPolicyRequest, UntagPolicyResponse>()
                            .withOperationName("UntagPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagPolicyRequest));
            CompletableFuture<UntagPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the role. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagRoleRequest
     * @return A Java Future containing the result of the UntagRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagRoleResponse> untagRole(UntagRoleRequest untagRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagRole");

            HttpResponseHandler<UntagRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagRoleRequest, UntagRoleResponse>().withOperationName("UntagRole")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagRoleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagRoleRequest));
            CompletableFuture<UntagRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified Security Assertion Markup Language (SAML) identity provider in IAM.
     * For more information about these providers, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagSamlProviderRequest
     * @return A Java Future containing the result of the UntagSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagSamlProviderResponse> untagSAMLProvider(UntagSamlProviderRequest untagSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagSAMLProvider");

            HttpResponseHandler<UntagSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagSamlProviderRequest, UntagSamlProviderResponse>()
                            .withOperationName("UntagSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagSamlProviderRequest));
            CompletableFuture<UntagSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the IAM server certificate. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server
     * certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information
     * about IAM server certificates, <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param untagServerCertificateRequest
     * @return A Java Future containing the result of the UntagServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagServerCertificateResponse> untagServerCertificate(
            UntagServerCertificateRequest untagServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagServerCertificate");

            HttpResponseHandler<UntagServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagServerCertificateRequest, UntagServerCertificateResponse>()
                            .withOperationName("UntagServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagServerCertificateRequest));
            CompletableFuture<UntagServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the user. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param untagUserRequest
     * @return A Java Future containing the result of the UntagUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UntagUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagUserResponse> untagUser(UntagUserRequest untagUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagUser");

            HttpResponseHandler<UntagUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(UntagUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UntagUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagUserRequest, UntagUserResponse>().withOperationName("UntagUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagUserRequest));
            CompletableFuture<UntagUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used
     * to disable a user's key as part of a key rotation workflow.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. If a temporary access key is used, then <code>UserName</code> is
     * required. If a long-term key is assigned to the user, then <code>UserName</code> is not required. This operation
     * works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage
     * Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated
     * users.
     * </p>
     * <p>
     * For information about rotating keys, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing keys and
     * certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateAccessKeyRequest
     * @return A Java Future containing the result of the UpdateAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccessKeyResponse> updateAccessKey(UpdateAccessKeyRequest updateAccessKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessKey");

            HttpResponseHandler<UpdateAccessKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateAccessKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateAccessKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccessKeyRequest, UpdateAccessKeyResponse>()
                            .withOperationName("UpdateAccessKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccessKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAccessKeyRequest));
            CompletableFuture<UpdateAccessKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the password policy settings for the Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * This operation does not support partial updates. No parameters are required, but if you do not specify a
     * parameter, that parameter's value reverts to its default value. See the <b>Request Parameters</b> section for
     * each parameter's default value. Also note that some parameters do not allow the default parameter to be
     * explicitly set. Instead, to invoke the default value, do not include that parameter when you invoke the
     * operation.
     * </p>
     * </note>
     * <p>
     * For more information about using a password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * password policy</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateAccountPasswordPolicyRequest
     * @return A Java Future containing the result of the UpdateAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccountPasswordPolicyResponse> updateAccountPasswordPolicy(
            UpdateAccountPasswordPolicyRequest updateAccountPasswordPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountPasswordPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountPasswordPolicy");

            HttpResponseHandler<UpdateAccountPasswordPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateAccountPasswordPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateAccountPasswordPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountPasswordPolicyRequest, UpdateAccountPasswordPolicyResponse>()
                            .withOperationName("UpdateAccountPasswordPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccountPasswordPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAccountPasswordPolicyRequest));
            CompletableFuture<UpdateAccountPasswordPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the
     * "role trust policy". For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions
     * and federate identities</a>.
     * </p>
     *
     * @param updateAssumeRolePolicyRequest
     * @return A Java Future containing the result of the UpdateAssumeRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateAssumeRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAssumeRolePolicyResponse> updateAssumeRolePolicy(
            UpdateAssumeRolePolicyRequest updateAssumeRolePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAssumeRolePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssumeRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssumeRolePolicy");

            HttpResponseHandler<UpdateAssumeRolePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateAssumeRolePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateAssumeRolePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAssumeRolePolicyRequest, UpdateAssumeRolePolicyResponse>()
                            .withOperationName("UpdateAssumeRolePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAssumeRolePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAssumeRolePolicyRequest));
            CompletableFuture<UpdateAssumeRolePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified IAM group.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing a group's path or name. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html">Renaming users and
     * groups</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * The person making the request (the principal), must have permission to change the role group with the old name
     * and the new name. For example, to change the group named <code>Managers</code> to <code>MGRs</code>, the
     * principal must have a policy that allows them to update both groups. If the principal has permission to update
     * the <code>Managers</code> group, but not the <code>MGRs</code> group, then the update fails. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     * management</a>.
     * </p>
     * </note>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                            .withOperationName("UpdateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGroupRequest));
            CompletableFuture<UpdateGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the
     * <b>Users</b> page in the IAM console to change the password for any IAM user. Use <a>ChangePassword</a> to change
     * your own password in the <b>My Security Credentials</b> page in the Amazon Web Services Management Console.
     * </p>
     * <p>
     * For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateLoginProfileRequest
     * @return A Java Future containing the result of the UpdateLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoginProfileResponse> updateLoginProfile(UpdateLoginProfileRequest updateLoginProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLoginProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoginProfile");

            HttpResponseHandler<UpdateLoginProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateLoginProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateLoginProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLoginProfileRequest, UpdateLoginProfileResponse>()
                            .withOperationName("UpdateLoginProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateLoginProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateLoginProfileRequest));
            CompletableFuture<UpdateLoginProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider
     * resource object with a new list of thumbprints.
     * </p>
     * <p>
     * The list that you pass with this operation completely replaces the existing list of thumbprints. (The lists are
     * not merged.)
     * </p>
     * <p>
     * Typically, you need to update a thumbprint only when the identity provider certificate changes, which occurs
     * rarely. However, if the provider's certificate <i>does</i> change, any attempt to assume an IAM role that
     * specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services secures communication with OIDC identity providers (IdPs) using our library of trusted root
     * certificate authorities (CAs) to verify the JSON Web Key Set (JWKS) endpoint's TLS certificate. If your OIDC IdP
     * relies on a certificate that is not signed by one of these trusted CAs, only then we secure communication using
     * the thumbprints set in the IdP's configuration.
     * </p>
     * </note> <note>
     * <p>
     * Trust for the OIDC provider is derived from the provider certificate and is validated by the thumbprint.
     * Therefore, it is best to limit access to the <code>UpdateOpenIDConnectProviderThumbprint</code> operation to
     * highly privileged users.
     * </p>
     * </note>
     *
     * @param updateOpenIdConnectProviderThumbprintRequest
     * @return A Java Future containing the result of the UpdateOpenIDConnectProviderThumbprint operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateOpenIDConnectProviderThumbprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOpenIdConnectProviderThumbprintResponse> updateOpenIDConnectProviderThumbprint(
            UpdateOpenIdConnectProviderThumbprintRequest updateOpenIdConnectProviderThumbprintRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOpenIdConnectProviderThumbprintRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOpenIdConnectProviderThumbprintRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpenIDConnectProviderThumbprint");

            HttpResponseHandler<UpdateOpenIdConnectProviderThumbprintResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateOpenIdConnectProviderThumbprintResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateOpenIdConnectProviderThumbprintResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOpenIdConnectProviderThumbprintRequest, UpdateOpenIdConnectProviderThumbprintResponse>()
                            .withOperationName("UpdateOpenIDConnectProviderThumbprint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOpenIdConnectProviderThumbprintRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOpenIdConnectProviderThumbprintRequest));
            CompletableFuture<UpdateOpenIdConnectProviderThumbprintResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the description or maximum session duration setting of a role.
     * </p>
     *
     * @param updateRoleRequest
     * @return A Java Future containing the result of the UpdateRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRoleResponse> updateRole(UpdateRoleRequest updateRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRole");

            HttpResponseHandler<UpdateRoleResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRoleRequest, UpdateRoleResponse>().withOperationName("UpdateRole")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRoleRequest));
            CompletableFuture<UpdateRoleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use <a>UpdateRole</a> instead.
     * </p>
     * <p>
     * Modifies only the description of a role. This operation performs the same function as the
     * <code>Description</code> parameter in the <code>UpdateRole</code> operation.
     * </p>
     *
     * @param updateRoleDescriptionRequest
     * @return A Java Future containing the result of the UpdateRoleDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateRoleDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateRoleDescription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRoleDescriptionResponse> updateRoleDescription(
            UpdateRoleDescriptionRequest updateRoleDescriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRoleDescriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRoleDescriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRoleDescription");

            HttpResponseHandler<UpdateRoleDescriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateRoleDescriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateRoleDescriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRoleDescriptionRequest, UpdateRoleDescriptionResponse>()
                            .withOperationName("UpdateRoleDescription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRoleDescriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRoleDescriptionRequest));
            CompletableFuture<UpdateRoleDescriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the metadata document, SAML encryption settings, and private keys for an existing SAML provider. To
     * rotate private keys, add your new private key and then remove the old key in a separate request.
     * </p>
     *
     * @param updateSamlProviderRequest
     * @return A Java Future containing the result of the UpdateSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSamlProviderResponse> updateSAMLProvider(UpdateSamlProviderRequest updateSamlProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSamlProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSAMLProvider");

            HttpResponseHandler<UpdateSamlProviderResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateSamlProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateSamlProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSamlProviderRequest, UpdateSamlProviderResponse>()
                            .withOperationName("UpdateSAMLProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSamlProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSamlProviderRequest));
            CompletableFuture<UpdateSamlProviderResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot
     * be used for authentication. This operation can be used to disable a user's SSH public key as part of a key
     * rotation work flow.
     * </p>
     * <p>
     * The SSH public key affected by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param updateSshPublicKeyRequest
     * @return A Java Future containing the result of the UpdateSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSshPublicKeyResponse> updateSSHPublicKey(UpdateSshPublicKeyRequest updateSshPublicKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSshPublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSSHPublicKey");

            HttpResponseHandler<UpdateSshPublicKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateSshPublicKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateSshPublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSshPublicKeyRequest, UpdateSshPublicKeyResponse>()
                            .withOperationName("UpdateSSHPublicKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSshPublicKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSshPublicKeyRequest));
            CompletableFuture<UpdateSshPublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of Amazon Web Services services
     * that can use the server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing a server certificate's path or name. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts"
     * >Renaming a server certificate</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * The person making the request (the principal), must have permission to change the server certificate with the old
     * name and the new name. For example, to change the certificate named <code>ProductionCert</code> to
     * <code>ProdCert</code>, the principal must have a policy that allows them to update both certificates. If the
     * principal has permission to update the <code>ProductionCert</code> group, but not the <code>ProdCert</code>
     * certificate, then the update fails. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </note>
     *
     * @param updateServerCertificateRequest
     * @return A Java Future containing the result of the UpdateServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateServerCertificateResponse> updateServerCertificate(
            UpdateServerCertificateRequest updateServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServerCertificate");

            HttpResponseHandler<UpdateServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateServerCertificateRequest, UpdateServerCertificateResponse>()
                            .withOperationName("UpdateServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateServerCertificateRequest));
            CompletableFuture<UpdateServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the status of a service-specific credential to <code>Active</code> or <code>Inactive</code>.
     * Service-specific credentials that are inactive cannot be used for authentication to the service. This operation
     * can be used to disable a user's service-specific credential as part of a credential rotation work flow.
     * </p>
     *
     * @param updateServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the UpdateServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateServiceSpecificCredentialResponse> updateServiceSpecificCredential(
            UpdateServiceSpecificCredentialRequest updateServiceSpecificCredentialRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateServiceSpecificCredentialRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceSpecificCredential");

            HttpResponseHandler<UpdateServiceSpecificCredentialResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateServiceSpecificCredentialResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateServiceSpecificCredentialResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateServiceSpecificCredentialRequest, UpdateServiceSpecificCredentialResponse>()
                            .withOperationName("UpdateServiceSpecificCredential").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateServiceSpecificCredentialRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateServiceSpecificCredentialRequest));
            CompletableFuture<UpdateServiceSpecificCredentialResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the status of the specified user signing certificate from active to disabled, or vice versa. This
     * operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the Amazon
     * Web Services access key ID used to sign the request. This operation works for access keys under the Amazon Web
     * Services account. Consequently, you can use this operation to manage Amazon Web Services account root user
     * credentials even if the Amazon Web Services account has no associated users.
     * </p>
     *
     * @param updateSigningCertificateRequest
     * @return A Java Future containing the result of the UpdateSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSigningCertificateResponse> updateSigningCertificate(
            UpdateSigningCertificateRequest updateSigningCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSigningCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSigningCertificate");

            HttpResponseHandler<UpdateSigningCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateSigningCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateSigningCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSigningCertificateRequest, UpdateSigningCertificateResponse>()
                            .withOperationName("UpdateSigningCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSigningCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSigningCertificateRequest));
            CompletableFuture<UpdateSigningCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified IAM user.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing an IAM user's path or name. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming">Renaming an IAM
     * user</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html">Renaming an
     * IAM group</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * To change a user name, the requester must have appropriate permissions on both the source object and the target
     * object. For example, to change Bob to Robert, the entity making the request must have permission on Bob and
     * Robert, or must have permission on all (*). For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and policies</a>.
     * </p>
     * </note>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>().withOperationName("UpdateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserRequest));
            CompletableFuture<UpdateUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads an SSH public key and associates it with the specified IAM user.
     * </p>
     * <p>
     * The SSH public key uploaded by this operation can be used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param uploadSshPublicKeyRequest
     * @return A Java Future containing the result of the UploadSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidPublicKeyException The request was rejected because the public key is malformed or otherwise
     *         invalid.</li>
     *         <li>DuplicateSshPublicKeyException The request was rejected because the SSH public key is already
     *         associated with the specified IAM user.</li>
     *         <li>UnrecognizedPublicKeyEncodingException The request was rejected because the public key encoding
     *         format is unsupported or unrecognized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UploadSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UploadSshPublicKeyResponse> uploadSSHPublicKey(UploadSshPublicKeyRequest uploadSshPublicKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadSshPublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadSSHPublicKey");

            HttpResponseHandler<UploadSshPublicKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(UploadSshPublicKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UploadSshPublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UploadSshPublicKeyRequest, UploadSshPublicKeyResponse>()
                            .withOperationName("UploadSSHPublicKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UploadSshPublicKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(uploadSshPublicKeyRequest));
            CompletableFuture<UploadSshPublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads a server certificate entity for the Amazon Web Services account. The server certificate entity includes a
     * public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
     * </p>
     * <p>
     * We recommend that you use <a href="https://docs.aws.amazon.com/acm/">Certificate Manager</a> to provision,
     * manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to Amazon Web
     * Services resources, and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For
     * more information about using ACM, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate
     * Manager User Guide</a>.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of Amazon Web Services services that
     * can use the server certificates that you manage with IAM.
     * </p>
     * <p>
     * For information about the number of server certificates you can upload, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because the body of the public key certificate, private key, and the certificate chain can be large, you should
     * use POST rather than GET when calling <code>UploadServerCertificate</code>. For information about setting up
     * signatures and authorization through the API, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing Amazon Web Services
     * API requests</a> in the <i>Amazon Web Services General Reference</i>. For general information about using the
     * Query API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html">Calling the
     * API by making HTTP query requests</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param uploadServerCertificateRequest
     * @return A Java Future containing the result of the UploadServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedCertificateException The request was rejected because the certificate was malformed or
     *         expired. The error message describes the specific error.</li>
     *         <li>KeyPairMismatchException The request was rejected because the public key certificate and the private
     *         key do not match.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UploadServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UploadServerCertificateResponse> uploadServerCertificate(
            UploadServerCertificateRequest uploadServerCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadServerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadServerCertificate");

            HttpResponseHandler<UploadServerCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(UploadServerCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UploadServerCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UploadServerCertificateRequest, UploadServerCertificateResponse>()
                            .withOperationName("UploadServerCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UploadServerCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(uploadServerCertificateRequest));
            CompletableFuture<UploadServerCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services
     * services require you to use certificates to validate requests that are signed with a corresponding private key.
     * When you upload the certificate, its default status is <code>Active</code>.
     * </p>
     * <p>
     * For information about when you would use an X.509 signing certificate, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Managing server
     * certificates in IAM</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the IAM user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. This operation works for access keys under the Amazon Web
     * Services account. Consequently, you can use this operation to manage Amazon Web Services account root user
     * credentials even if the Amazon Web Services account has no associated users.
     * </p>
     * <note>
     * <p>
     * Because the body of an X.509 certificate can be large, you should use POST rather than GET when calling
     * <code>UploadSigningCertificate</code>. For information about setting up signatures and authorization through the
     * API, see <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing Amazon Web
     * Services API requests</a> in the <i>Amazon Web Services General Reference</i>. For general information about
     * using the Query API with IAM, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param uploadSigningCertificateRequest
     * @return A Java Future containing the result of the UploadSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedCertificateException The request was rejected because the certificate was malformed or
     *         expired. The error message describes the specific error.</li>
     *         <li>InvalidCertificateException The request was rejected because the certificate is invalid.</li>
     *         <li>DuplicateCertificateException The request was rejected because the same certificate is associated
     *         with an IAM user in the account.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.UploadSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UploadSigningCertificateResponse> uploadSigningCertificate(
            UploadSigningCertificateRequest uploadSigningCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadSigningCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadSigningCertificate");

            HttpResponseHandler<UploadSigningCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(UploadSigningCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UploadSigningCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UploadSigningCertificateRequest, UploadSigningCertificateResponse>()
                            .withOperationName("UploadSigningCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UploadSigningCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(uploadSigningCertificateRequest));
            CompletableFuture<UploadSigningCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public IamAsyncWaiter waiter() {
        return IamAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final IamServiceClientConfiguration serviceClientConfiguration() {
        return new IamServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModification")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CallerIsNotManagementAccountException")
                                .exceptionBuilderSupplier(CallerIsNotManagementAccountException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnmodifiableEntity")
                                .exceptionBuilderSupplier(UnmodifiableEntityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceeded")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchEntity")
                                .exceptionBuilderSupplier(NoSuchEntityException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityTemporarilyUnmodifiable")
                                .exceptionBuilderSupplier(EntityTemporarilyUnmodifiableException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotSupportedService")
                                .exceptionBuilderSupplier(ServiceNotSupportedException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceAccessNotEnabledException")
                                .exceptionBuilderSupplier(ServiceAccessNotEnabledException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpenIdIdpCommunicationError")
                                .exceptionBuilderSupplier(OpenIdIdpCommunicationErrorException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportInProgress")
                                .exceptionBuilderSupplier(CredentialReportNotReadyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailure")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPublicKey")
                                .exceptionBuilderSupplier(InvalidPublicKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateSSHPublicKey")
                                .exceptionBuilderSupplier(DuplicateSshPublicKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyEvaluation")
                                .exceptionBuilderSupplier(PolicyEvaluationException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInput")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyNotAttachable")
                                .exceptionBuilderSupplier(PolicyNotAttachableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedCertificate")
                                .exceptionBuilderSupplier(MalformedCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedPolicyDocument")
                                .exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteConflict")
                                .exceptionBuilderSupplier(DeleteConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificate")
                                .exceptionBuilderSupplier(InvalidCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordPolicyViolation")
                                .exceptionBuilderSupplier(PasswordPolicyViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportExpired")
                                .exceptionBuilderSupplier(CredentialReportExpiredException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserType")
                                .exceptionBuilderSupplier(InvalidUserTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountNotManagementOrDelegatedAdministratorException")
                                .exceptionBuilderSupplier(AccountNotManagementOrDelegatedAdministratorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotFoundException")
                                .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateCertificate")
                                .exceptionBuilderSupplier(DuplicateCertificateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeyPairMismatch")
                                .exceptionBuilderSupplier(KeyPairMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyExists")
                                .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthenticationCode")
                                .exceptionBuilderSupplier(InvalidAuthenticationCodeException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportNotPresent")
                                .exceptionBuilderSupplier(CredentialReportNotPresentException::builder).httpStatusCode(410)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnrecognizedPublicKeyEncoding")
                                .exceptionBuilderSupplier(UnrecognizedPublicKeyEncodingException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportGenerationLimitExceeded")
                                .exceptionBuilderSupplier(ReportGenerationLimitExceededException::builder).httpStatusCode(409)
                                .build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IamException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        IamServiceClientConfigurationBuilder serviceConfigBuilder = new IamServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
