/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddClientIdToOpenIdConnectProviderRequest extends IamRequest implements
        ToCopyableBuilder<AddClientIdToOpenIdConnectProviderRequest.Builder, AddClientIdToOpenIdConnectProviderRequest> {
    private static final SdkField<String> OPEN_ID_CONNECT_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDConnectProviderArn")
            .getter(getter(AddClientIdToOpenIdConnectProviderRequest::openIDConnectProviderArn))
            .setter(setter(Builder::openIDConnectProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderArn").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientID").getter(getter(AddClientIdToOpenIdConnectProviderRequest::clientID))
            .setter(setter(Builder::clientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OPEN_ID_CONNECT_PROVIDER_ARN_FIELD, CLIENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String openIDConnectProviderArn;

    private final String clientID;

    private AddClientIdToOpenIdConnectProviderRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.clientID = builder.clientID;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID to. You
     * can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID
     *         to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.
     */
    public final String openIDConnectProviderArn() {
        return openIDConnectProviderArn;
    }

    /**
     * <p>
     * The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.
     * </p>
     * 
     * @return The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.
     */
    public final String clientID() {
        return clientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddClientIdToOpenIdConnectProviderRequest)) {
            return false;
        }
        AddClientIdToOpenIdConnectProviderRequest other = (AddClientIdToOpenIdConnectProviderRequest) obj;
        return Objects.equals(openIDConnectProviderArn(), other.openIDConnectProviderArn())
                && Objects.equals(clientID(), other.clientID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddClientIdToOpenIdConnectProviderRequest")
                .add("OpenIDConnectProviderArn", openIDConnectProviderArn()).add("ClientID", clientID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenIDConnectProviderArn":
            return Optional.ofNullable(clazz.cast(openIDConnectProviderArn()));
        case "ClientID":
            return Optional.ofNullable(clazz.cast(clientID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OpenIDConnectProviderArn", OPEN_ID_CONNECT_PROVIDER_ARN_FIELD);
        map.put("ClientID", CLIENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddClientIdToOpenIdConnectProviderRequest, T> g) {
        return obj -> g.apply((AddClientIdToOpenIdConnectProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddClientIdToOpenIdConnectProviderRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID to.
         * You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.
         * </p>
         * 
         * @param openIDConnectProviderArn
         *        The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID
         *        to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectProviderArn(String openIDConnectProviderArn);

        /**
         * <p>
         * The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.
         * </p>
         * 
         * @param clientID
         *        The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientID(String clientID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String openIDConnectProviderArn;

        private String clientID;

        private BuilderImpl() {
        }

        private BuilderImpl(AddClientIdToOpenIdConnectProviderRequest model) {
            super(model);
            openIDConnectProviderArn(model.openIDConnectProviderArn);
            clientID(model.clientID);
        }

        public final String getOpenIDConnectProviderArn() {
            return openIDConnectProviderArn;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final String getClientID() {
            return clientID;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddClientIdToOpenIdConnectProviderRequest build() {
            return new AddClientIdToOpenIdConnectProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
