/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.services.iam.model.RoleLastUsed;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Role
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Role> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(Role.getter(Role::path)).setter(Role.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(Role.getter(Role::roleName)).setter(Role.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleId").getter(Role.getter(Role::roleId)).setter(Role.setter(Builder::roleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Role.getter(Role::arn)).setter(Role.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(Role.getter(Role::createDate)).setter(Role.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssumeRolePolicyDocument").getter(Role.getter(Role::assumeRolePolicyDocument)).setter(Role.setter(Builder::assumeRolePolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Role.getter(Role::description)).setter(Role.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSessionDuration").getter(Role.getter(Role::maxSessionDuration)).setter(Role.setter(Builder::maxSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build()}).build();
    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsBoundary").getter(Role.getter(Role::permissionsBoundary)).setter(Role.setter(Builder::permissionsBoundary)).constructor(AttachedPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Role.getter(Role::tags)).setter(Role.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RoleLastUsed> ROLE_LAST_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoleLastUsed").getter(Role.getter(Role::roleLastUsed)).setter(Role.setter(Builder::roleLastUsed)).constructor(RoleLastUsed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleLastUsed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ROLE_NAME_FIELD, ROLE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ASSUME_ROLE_POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD, MAX_SESSION_DURATION_FIELD, PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD, ROLE_LAST_USED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Role.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final String description;
    private final Integer maxSessionDuration;
    private final AttachedPermissionsBoundary permissionsBoundary;
    private final List<Tag> tags;
    private final RoleLastUsed roleLastUsed;

    private Role(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
        this.roleLastUsed = builder.roleLastUsed;
    }

    public final String path() {
        return this.path;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String roleId() {
        return this.roleId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public final String description() {
        return this.description;
    }

    public final Integer maxSessionDuration() {
        return this.maxSessionDuration;
    }

    public final AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final RoleLastUsed roleLastUsed() {
        return this.roleLastUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleLastUsed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxSessionDuration(), other.maxSessionDuration()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.roleLastUsed(), other.roleLastUsed());
    }

    public final String toString() {
        return ToString.builder((String)"Role").add("Path", (Object)this.path()).add("RoleName", (Object)this.roleName()).add("RoleId", (Object)this.roleId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("AssumeRolePolicyDocument", (Object)this.assumeRolePolicyDocument()).add("Description", (Object)this.description()).add("MaxSessionDuration", (Object)this.maxSessionDuration()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).add("Tags", this.hasTags() ? this.tags() : null).add("RoleLastUsed", (Object)this.roleLastUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleId": {
                return Optional.ofNullable(clazz.cast(this.roleId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "AssumeRolePolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.maxSessionDuration()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RoleLastUsed": {
                return Optional.ofNullable(clazz.cast(this.roleLastUsed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Path", PATH_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("RoleId", ROLE_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("AssumeRolePolicyDocument", ASSUME_ROLE_POLICY_DOCUMENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MaxSessionDuration", MAX_SESSION_DURATION_FIELD);
        map.put("PermissionsBoundary", PERMISSIONS_BOUNDARY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RoleLastUsed", ROLE_LAST_USED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Role, T> g) {
        return obj -> g.apply((Role)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private String description;
        private Integer maxSessionDuration;
        private AttachedPermissionsBoundary permissionsBoundary;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private RoleLastUsed roleLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            this.path(model.path);
            this.roleName(model.roleName);
            this.roleId(model.roleId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.description(model.description);
            this.maxSessionDuration(model.maxSessionDuration);
            this.permissionsBoundary(model.permissionsBoundary);
            this.tags(model.tags);
            this.roleLastUsed(model.roleLastUsed);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RoleLastUsed.Builder getRoleLastUsed() {
            return this.roleLastUsed != null ? this.roleLastUsed.toBuilder() : null;
        }

        public final void setRoleLastUsed(RoleLastUsed.BuilderImpl roleLastUsed) {
            this.roleLastUsed = roleLastUsed != null ? roleLastUsed.build() : null;
        }

        @Override
        public final Builder roleLastUsed(RoleLastUsed roleLastUsed) {
            this.roleLastUsed = roleLastUsed;
            return this;
        }

        public Role build() {
            return new Role(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Role> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder description(String var1);

        public Builder maxSessionDuration(Integer var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder roleLastUsed(RoleLastUsed var1);

        default public Builder roleLastUsed(Consumer<RoleLastUsed.Builder> roleLastUsed) {
            return this.roleLastUsed((RoleLastUsed)((RoleLastUsed.Builder)RoleLastUsed.builder().applyMutation(roleLastUsed)).build());
        }
    }
}

