/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the user name and password create date for a user.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>CreateLoginProfile</a> and <a>GetLoginProfile</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoginProfile implements SdkPojo, Serializable, ToCopyableBuilder<LoginProfile.Builder, LoginProfile> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(LoginProfile::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(LoginProfile::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Boolean> PASSWORD_RESET_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PasswordResetRequired").getter(getter(LoginProfile::passwordResetRequired))
            .setter(setter(Builder::passwordResetRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordResetRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            CREATE_DATE_FIELD, PASSWORD_RESET_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final Instant createDate;

    private final Boolean passwordResetRequired;

    private LoginProfile(BuilderImpl builder) {
        this.userName = builder.userName;
        this.createDate = builder.createDate;
        this.passwordResetRequired = builder.passwordResetRequired;
    }

    /**
     * <p>
     * The name of the user, which can be used for signing in to the Amazon Web Services Management Console.
     * </p>
     * 
     * @return The name of the user, which can be used for signing in to the Amazon Web Services Management Console.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The date when the password for the user was created.
     * </p>
     * 
     * @return The date when the password for the user was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * Specifies whether the user is required to set a new password on next sign-in.
     * </p>
     * 
     * @return Specifies whether the user is required to set a new password on next sign-in.
     */
    public final Boolean passwordResetRequired() {
        return passwordResetRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(passwordResetRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginProfile)) {
            return false;
        }
        LoginProfile other = (LoginProfile) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(passwordResetRequired(), other.passwordResetRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoginProfile").add("UserName", userName()).add("CreateDate", createDate())
                .add("PasswordResetRequired", passwordResetRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "PasswordResetRequired":
            return Optional.ofNullable(clazz.cast(passwordResetRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("PasswordResetRequired", PASSWORD_RESET_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoginProfile, T> g) {
        return obj -> g.apply((LoginProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoginProfile> {
        /**
         * <p>
         * The name of the user, which can be used for signing in to the Amazon Web Services Management Console.
         * </p>
         * 
         * @param userName
         *        The name of the user, which can be used for signing in to the Amazon Web Services Management Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The date when the password for the user was created.
         * </p>
         * 
         * @param createDate
         *        The date when the password for the user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * Specifies whether the user is required to set a new password on next sign-in.
         * </p>
         * 
         * @param passwordResetRequired
         *        Specifies whether the user is required to set a new password on next sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordResetRequired(Boolean passwordResetRequired);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private Instant createDate;

        private Boolean passwordResetRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginProfile model) {
            userName(model.userName);
            createDate(model.createDate);
            passwordResetRequired(model.passwordResetRequired);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Boolean getPasswordResetRequired() {
            return passwordResetRequired;
        }

        public final void setPasswordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
        }

        @Override
        public final Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        @Override
        public LoginProfile build() {
            return new LoginProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
