/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSAMLProvider.html">GetSAMLProvider</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSamlProviderResponse extends IamResponse implements
        ToCopyableBuilder<GetSamlProviderResponse.Builder, GetSamlProviderResponse> {
    private static final SdkField<String> SAML_PROVIDER_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLProviderUUID").getter(getter(GetSamlProviderResponse::samlProviderUUID))
            .setter(setter(Builder::samlProviderUUID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderUUID").build()).build();

    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLMetadataDocument").getter(getter(GetSamlProviderResponse::samlMetadataDocument))
            .setter(setter(Builder::samlMetadataDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(GetSamlProviderResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil").getter(getter(GetSamlProviderResponse::validUntil)).setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetSamlProviderResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSERTION_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssertionEncryptionMode").getter(getter(GetSamlProviderResponse::assertionEncryptionModeAsString))
            .setter(setter(Builder::assertionEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionEncryptionMode").build())
            .build();

    private static final SdkField<List<SAMLPrivateKey>> PRIVATE_KEY_LIST_FIELD = SdkField
            .<List<SAMLPrivateKey>> builder(MarshallingType.LIST)
            .memberName("PrivateKeyList")
            .getter(getter(GetSamlProviderResponse::privateKeyList))
            .setter(setter(Builder::privateKeyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SAMLPrivateKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(SAMLPrivateKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_PROVIDER_UUID_FIELD,
            SAML_METADATA_DOCUMENT_FIELD, CREATE_DATE_FIELD, VALID_UNTIL_FIELD, TAGS_FIELD, ASSERTION_ENCRYPTION_MODE_FIELD,
            PRIVATE_KEY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String samlProviderUUID;

    private final String samlMetadataDocument;

    private final Instant createDate;

    private final Instant validUntil;

    private final List<Tag> tags;

    private final String assertionEncryptionMode;

    private final List<SAMLPrivateKey> privateKeyList;

    private GetSamlProviderResponse(BuilderImpl builder) {
        super(builder);
        this.samlProviderUUID = builder.samlProviderUUID;
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.createDate = builder.createDate;
        this.validUntil = builder.validUntil;
        this.tags = builder.tags;
        this.assertionEncryptionMode = builder.assertionEncryptionMode;
        this.privateKeyList = builder.privateKeyList;
    }

    /**
     * <p>
     * The unique identifier assigned to the SAML provider.
     * </p>
     * 
     * @return The unique identifier assigned to the SAML provider.
     */
    public final String samlProviderUUID() {
        return samlProviderUUID;
    }

    /**
     * <p>
     * The XML metadata document that includes information about an identity provider.
     * </p>
     * 
     * @return The XML metadata document that includes information about an identity provider.
     */
    public final String samlMetadataDocument() {
        return samlMetadataDocument;
    }

    /**
     * <p>
     * The date and time when the SAML provider was created.
     * </p>
     * 
     * @return The date and time when the SAML provider was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The expiration date and time for the SAML provider.
     * </p>
     * 
     * @return The expiration date and time for the SAML provider.
     */
    public final Instant validUntil() {
        return validUntil;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag
     * key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted
     *         by tag key. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the encryption setting for the SAML provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assertionEncryptionMode} will return {@link AssertionEncryptionModeType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #assertionEncryptionModeAsString}.
     * </p>
     * 
     * @return Specifies the encryption setting for the SAML provider.
     * @see AssertionEncryptionModeType
     */
    public final AssertionEncryptionModeType assertionEncryptionMode() {
        return AssertionEncryptionModeType.fromValue(assertionEncryptionMode);
    }

    /**
     * <p>
     * Specifies the encryption setting for the SAML provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assertionEncryptionMode} will return {@link AssertionEncryptionModeType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #assertionEncryptionModeAsString}.
     * </p>
     * 
     * @return Specifies the encryption setting for the SAML provider.
     * @see AssertionEncryptionModeType
     */
    public final String assertionEncryptionModeAsString() {
        return assertionEncryptionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateKeyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateKeyList() {
        return privateKeyList != null && !(privateKeyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private key metadata for the SAML provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateKeyList} method.
     * </p>
     * 
     * @return The private key metadata for the SAML provider.
     */
    public final List<SAMLPrivateKey> privateKeyList() {
        return privateKeyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderUUID());
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assertionEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateKeyList() ? privateKeyList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamlProviderResponse)) {
            return false;
        }
        GetSamlProviderResponse other = (GetSamlProviderResponse) obj;
        return Objects.equals(samlProviderUUID(), other.samlProviderUUID())
                && Objects.equals(samlMetadataDocument(), other.samlMetadataDocument())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(validUntil(), other.validUntil())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(assertionEncryptionModeAsString(), other.assertionEncryptionModeAsString())
                && hasPrivateKeyList() == other.hasPrivateKeyList() && Objects.equals(privateKeyList(), other.privateKeyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSamlProviderResponse").add("SAMLProviderUUID", samlProviderUUID())
                .add("SAMLMetadataDocument", samlMetadataDocument()).add("CreateDate", createDate())
                .add("ValidUntil", validUntil()).add("Tags", hasTags() ? tags() : null)
                .add("AssertionEncryptionMode", assertionEncryptionModeAsString())
                .add("PrivateKeyList", hasPrivateKeyList() ? privateKeyList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLProviderUUID":
            return Optional.ofNullable(clazz.cast(samlProviderUUID()));
        case "SAMLMetadataDocument":
            return Optional.ofNullable(clazz.cast(samlMetadataDocument()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AssertionEncryptionMode":
            return Optional.ofNullable(clazz.cast(assertionEncryptionModeAsString()));
        case "PrivateKeyList":
            return Optional.ofNullable(clazz.cast(privateKeyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SAMLProviderUUID", SAML_PROVIDER_UUID_FIELD);
        map.put("SAMLMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("ValidUntil", VALID_UNTIL_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AssertionEncryptionMode", ASSERTION_ENCRYPTION_MODE_FIELD);
        map.put("PrivateKeyList", PRIVATE_KEY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSamlProviderResponse, T> g) {
        return obj -> g.apply((GetSamlProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSamlProviderResponse> {
        /**
         * <p>
         * The unique identifier assigned to the SAML provider.
         * </p>
         * 
         * @param samlProviderUUID
         *        The unique identifier assigned to the SAML provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderUUID(String samlProviderUUID);

        /**
         * <p>
         * The XML metadata document that includes information about an identity provider.
         * </p>
         * 
         * @param samlMetadataDocument
         *        The XML metadata document that includes information about an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataDocument(String samlMetadataDocument);

        /**
         * <p>
         * The date and time when the SAML provider was created.
         * </p>
         * 
         * @param createDate
         *        The date and time when the SAML provider was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The expiration date and time for the SAML provider.
         * </p>
         * 
         * @param validUntil
         *        The expiration date and time for the SAML provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by
         * tag key. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is
         *        sorted by tag key. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by
         * tag key. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is
         *        sorted by tag key. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by
         * tag key. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iam.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iam.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iam.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies the encryption setting for the SAML provider.
         * </p>
         * 
         * @param assertionEncryptionMode
         *        Specifies the encryption setting for the SAML provider.
         * @see AssertionEncryptionModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssertionEncryptionModeType
         */
        Builder assertionEncryptionMode(String assertionEncryptionMode);

        /**
         * <p>
         * Specifies the encryption setting for the SAML provider.
         * </p>
         * 
         * @param assertionEncryptionMode
         *        Specifies the encryption setting for the SAML provider.
         * @see AssertionEncryptionModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssertionEncryptionModeType
         */
        Builder assertionEncryptionMode(AssertionEncryptionModeType assertionEncryptionMode);

        /**
         * <p>
         * The private key metadata for the SAML provider.
         * </p>
         * 
         * @param privateKeyList
         *        The private key metadata for the SAML provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyList(Collection<SAMLPrivateKey> privateKeyList);

        /**
         * <p>
         * The private key metadata for the SAML provider.
         * </p>
         * 
         * @param privateKeyList
         *        The private key metadata for the SAML provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyList(SAMLPrivateKey... privateKeyList);

        /**
         * <p>
         * The private key metadata for the SAML provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.SAMLPrivateKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.SAMLPrivateKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.SAMLPrivateKey.Builder#build()} is called immediately and
         * its result is passed to {@link #privateKeyList(List<SAMLPrivateKey>)}.
         * 
         * @param privateKeyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.SAMLPrivateKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeyList(java.util.Collection<SAMLPrivateKey>)
         */
        Builder privateKeyList(Consumer<SAMLPrivateKey.Builder>... privateKeyList);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String samlProviderUUID;

        private String samlMetadataDocument;

        private Instant createDate;

        private Instant validUntil;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String assertionEncryptionMode;

        private List<SAMLPrivateKey> privateKeyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamlProviderResponse model) {
            super(model);
            samlProviderUUID(model.samlProviderUUID);
            samlMetadataDocument(model.samlMetadataDocument);
            createDate(model.createDate);
            validUntil(model.validUntil);
            tags(model.tags);
            assertionEncryptionMode(model.assertionEncryptionMode);
            privateKeyList(model.privateKeyList);
        }

        public final String getSamlProviderUUID() {
            return samlProviderUUID;
        }

        public final void setSamlProviderUUID(String samlProviderUUID) {
            this.samlProviderUUID = samlProviderUUID;
        }

        @Override
        public final Builder samlProviderUUID(String samlProviderUUID) {
            this.samlProviderUUID = samlProviderUUID;
            return this;
        }

        public final String getSamlMetadataDocument() {
            return samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssertionEncryptionMode() {
            return assertionEncryptionMode;
        }

        public final void setAssertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
        }

        @Override
        public final Builder assertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
            return this;
        }

        @Override
        public final Builder assertionEncryptionMode(AssertionEncryptionModeType assertionEncryptionMode) {
            this.assertionEncryptionMode(assertionEncryptionMode == null ? null : assertionEncryptionMode.toString());
            return this;
        }

        public final List<SAMLPrivateKey.Builder> getPrivateKeyList() {
            List<SAMLPrivateKey.Builder> result = _privateKeyListCopier.copyToBuilder(this.privateKeyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateKeyList(Collection<SAMLPrivateKey.BuilderImpl> privateKeyList) {
            this.privateKeyList = _privateKeyListCopier.copyFromBuilder(privateKeyList);
        }

        @Override
        public final Builder privateKeyList(Collection<SAMLPrivateKey> privateKeyList) {
            this.privateKeyList = _privateKeyListCopier.copy(privateKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateKeyList(SAMLPrivateKey... privateKeyList) {
            privateKeyList(Arrays.asList(privateKeyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateKeyList(Consumer<SAMLPrivateKey.Builder>... privateKeyList) {
            privateKeyList(Stream.of(privateKeyList).map(c -> SAMLPrivateKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSamlProviderResponse build() {
            return new GetSamlProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
