/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of a service-specific credential.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSpecificCredential implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceSpecificCredential.Builder, ServiceSpecificCredential> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(ServiceSpecificCredential::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(ServiceSpecificCredential::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceSpecificCredential::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> SERVICE_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUserName").getter(getter(ServiceSpecificCredential::serviceUserName))
            .setter(setter(Builder::serviceUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUserName").build()).build();

    private static final SdkField<String> SERVICE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePassword").getter(getter(ServiceSpecificCredential::servicePassword))
            .setter(setter(Builder::servicePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePassword").build()).build();

    private static final SdkField<String> SERVICE_CREDENTIAL_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCredentialAlias").getter(getter(ServiceSpecificCredential::serviceCredentialAlias))
            .setter(setter(Builder::serviceCredentialAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCredentialAlias").build())
            .build();

    private static final SdkField<String> SERVICE_CREDENTIAL_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCredentialSecret").getter(getter(ServiceSpecificCredential::serviceCredentialSecret))
            .setter(setter(Builder::serviceCredentialSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCredentialSecret").build())
            .build();

    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceSpecificCredentialId")
            .getter(getter(ServiceSpecificCredential::serviceSpecificCredentialId))
            .setter(setter(Builder::serviceSpecificCredentialId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId")
                    .build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(ServiceSpecificCredential::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServiceSpecificCredential::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD,
            EXPIRATION_DATE_FIELD, SERVICE_NAME_FIELD, SERVICE_USER_NAME_FIELD, SERVICE_PASSWORD_FIELD,
            SERVICE_CREDENTIAL_ALIAS_FIELD, SERVICE_CREDENTIAL_SECRET_FIELD, SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD,
            USER_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createDate;

    private final Instant expirationDate;

    private final String serviceName;

    private final String serviceUserName;

    private final String servicePassword;

    private final String serviceCredentialAlias;

    private final String serviceCredentialSecret;

    private final String serviceSpecificCredentialId;

    private final String userName;

    private final String status;

    private ServiceSpecificCredential(BuilderImpl builder) {
        this.createDate = builder.createDate;
        this.expirationDate = builder.expirationDate;
        this.serviceName = builder.serviceName;
        this.serviceUserName = builder.serviceUserName;
        this.servicePassword = builder.servicePassword;
        this.serviceCredentialAlias = builder.serviceCredentialAlias;
        this.serviceCredentialSecret = builder.serviceCredentialSecret;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.userName = builder.userName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     * service-specific credential were created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         service-specific credential were created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The date and time when the service specific credential expires. This field is only present for Bedrock API keys
     * that were created with an expiration period.
     * </p>
     * 
     * @return The date and time when the service specific credential expires. This field is only present for Bedrock
     *         API keys that were created with an expiration period.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The name of the service associated with the service-specific credential.
     * </p>
     * 
     * @return The name of the service associated with the service-specific credential.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The generated user name for the service-specific credential. This value is generated by combining the IAM user's
     * name combined with the ID number of the Amazon Web Services account, as in <code>jane-at-123456789012</code>, for
     * example. This value cannot be configured by the user.
     * </p>
     * 
     * @return The generated user name for the service-specific credential. This value is generated by combining the IAM
     *         user's name combined with the ID number of the Amazon Web Services account, as in
     *         <code>jane-at-123456789012</code>, for example. This value cannot be configured by the user.
     */
    public final String serviceUserName() {
        return serviceUserName;
    }

    /**
     * <p>
     * The generated password for the service-specific credential.
     * </p>
     * 
     * @return The generated password for the service-specific credential.
     */
    public final String servicePassword() {
        return servicePassword;
    }

    /**
     * <p>
     * For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a suffix
     * containing version and creation information.
     * </p>
     * 
     * @return For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a
     *         suffix containing version and creation information.
     */
    public final String serviceCredentialAlias() {
        return serviceCredentialAlias;
    }

    /**
     * <p>
     * For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API calls.
     * This value is returned only when the credential is created.
     * </p>
     * 
     * @return For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate
     *         API calls. This value is returned only when the credential is created.
     */
    public final String serviceCredentialSecret() {
        return serviceCredentialSecret;
    }

    /**
     * <p>
     * The unique identifier for the service-specific credential.
     * </p>
     * 
     * @return The unique identifier for the service-specific credential.
     */
    public final String serviceSpecificCredentialId() {
        return serviceSpecificCredentialId;
    }

    /**
     * <p>
     * The name of the IAM user associated with the service-specific credential.
     * </p>
     * 
     * @return The name of the IAM user associated with the service-specific credential.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
     * while <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service-specific credential. <code>Active</code> means that the key is valid for API
     *         calls, while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public final StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
     * while <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service-specific credential. <code>Active</code> means that the key is valid for API
     *         calls, while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUserName());
        hashCode = 31 * hashCode + Objects.hashCode(servicePassword());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCredentialAlias());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCredentialSecret());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecificCredentialId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredential)) {
            return false;
        }
        ServiceSpecificCredential other = (ServiceSpecificCredential) obj;
        return Objects.equals(createDate(), other.createDate()) && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceUserName(), other.serviceUserName())
                && Objects.equals(servicePassword(), other.servicePassword())
                && Objects.equals(serviceCredentialAlias(), other.serviceCredentialAlias())
                && Objects.equals(serviceCredentialSecret(), other.serviceCredentialSecret())
                && Objects.equals(serviceSpecificCredentialId(), other.serviceSpecificCredentialId())
                && Objects.equals(userName(), other.userName()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSpecificCredential").add("CreateDate", createDate())
                .add("ExpirationDate", expirationDate()).add("ServiceName", serviceName())
                .add("ServiceUserName", serviceUserName())
                .add("ServicePassword", servicePassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ServiceCredentialAlias", serviceCredentialAlias())
                .add("ServiceCredentialSecret", serviceCredentialSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ServiceSpecificCredentialId", serviceSpecificCredentialId()).add("UserName", userName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceUserName":
            return Optional.ofNullable(clazz.cast(serviceUserName()));
        case "ServicePassword":
            return Optional.ofNullable(clazz.cast(servicePassword()));
        case "ServiceCredentialAlias":
            return Optional.ofNullable(clazz.cast(serviceCredentialAlias()));
        case "ServiceCredentialSecret":
            return Optional.ofNullable(clazz.cast(serviceCredentialSecret()));
        case "ServiceSpecificCredentialId":
            return Optional.ofNullable(clazz.cast(serviceSpecificCredentialId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("ServiceUserName", SERVICE_USER_NAME_FIELD);
        map.put("ServicePassword", SERVICE_PASSWORD_FIELD);
        map.put("ServiceCredentialAlias", SERVICE_CREDENTIAL_ALIAS_FIELD);
        map.put("ServiceCredentialSecret", SERVICE_CREDENTIAL_SECRET_FIELD);
        map.put("ServiceSpecificCredentialId", SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceSpecificCredential, T> g) {
        return obj -> g.apply((ServiceSpecificCredential) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSpecificCredential> {
        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         * service-specific credential were created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        service-specific credential were created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The date and time when the service specific credential expires. This field is only present for Bedrock API
         * keys that were created with an expiration period.
         * </p>
         * 
         * @param expirationDate
         *        The date and time when the service specific credential expires. This field is only present for Bedrock
         *        API keys that were created with an expiration period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The name of the service associated with the service-specific credential.
         * </p>
         * 
         * @param serviceName
         *        The name of the service associated with the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The generated user name for the service-specific credential. This value is generated by combining the IAM
         * user's name combined with the ID number of the Amazon Web Services account, as in
         * <code>jane-at-123456789012</code>, for example. This value cannot be configured by the user.
         * </p>
         * 
         * @param serviceUserName
         *        The generated user name for the service-specific credential. This value is generated by combining the
         *        IAM user's name combined with the ID number of the Amazon Web Services account, as in
         *        <code>jane-at-123456789012</code>, for example. This value cannot be configured by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUserName(String serviceUserName);

        /**
         * <p>
         * The generated password for the service-specific credential.
         * </p>
         * 
         * @param servicePassword
         *        The generated password for the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePassword(String servicePassword);

        /**
         * <p>
         * For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a
         * suffix containing version and creation information.
         * </p>
         * 
         * @param serviceCredentialAlias
         *        For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and
         *        a suffix containing version and creation information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCredentialAlias(String serviceCredentialAlias);

        /**
         * <p>
         * For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API
         * calls. This value is returned only when the credential is created.
         * </p>
         * 
         * @param serviceCredentialSecret
         *        For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate
         *        API calls. This value is returned only when the credential is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCredentialSecret(String serviceCredentialSecret);

        /**
         * <p>
         * The unique identifier for the service-specific credential.
         * </p>
         * 
         * @param serviceSpecificCredentialId
         *        The unique identifier for the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredentialId(String serviceSpecificCredentialId);

        /**
         * <p>
         * The name of the IAM user associated with the service-specific credential.
         * </p>
         * 
         * @param userName
         *        The name of the IAM user associated with the service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
         * while <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the service-specific credential. <code>Active</code> means that the key is valid for API
         *        calls, while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service-specific credential. <code>Active</code> means that the key is valid for API calls,
         * while <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the service-specific credential. <code>Active</code> means that the key is valid for API
         *        calls, while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);
    }

    static final class BuilderImpl implements Builder {
        private Instant createDate;

        private Instant expirationDate;

        private String serviceName;

        private String serviceUserName;

        private String servicePassword;

        private String serviceCredentialAlias;

        private String serviceCredentialSecret;

        private String serviceSpecificCredentialId;

        private String userName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredential model) {
            createDate(model.createDate);
            expirationDate(model.expirationDate);
            serviceName(model.serviceName);
            serviceUserName(model.serviceUserName);
            servicePassword(model.servicePassword);
            serviceCredentialAlias(model.serviceCredentialAlias);
            serviceCredentialSecret(model.serviceCredentialSecret);
            serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            userName(model.userName);
            status(model.status);
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceUserName() {
            return serviceUserName;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final String getServicePassword() {
            return servicePassword;
        }

        public final void setServicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
        }

        @Override
        public final Builder servicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
            return this;
        }

        public final String getServiceCredentialAlias() {
            return serviceCredentialAlias;
        }

        public final void setServiceCredentialAlias(String serviceCredentialAlias) {
            this.serviceCredentialAlias = serviceCredentialAlias;
        }

        @Override
        public final Builder serviceCredentialAlias(String serviceCredentialAlias) {
            this.serviceCredentialAlias = serviceCredentialAlias;
            return this;
        }

        public final String getServiceCredentialSecret() {
            return serviceCredentialSecret;
        }

        public final void setServiceCredentialSecret(String serviceCredentialSecret) {
            this.serviceCredentialSecret = serviceCredentialSecret;
        }

        @Override
        public final Builder serviceCredentialSecret(String serviceCredentialSecret) {
            this.serviceCredentialSecret = serviceCredentialSecret;
            return this;
        }

        public final String getServiceSpecificCredentialId() {
            return serviceSpecificCredentialId;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ServiceSpecificCredential build() {
            return new ServiceSpecificCredential(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
