/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListRoleTagsIterable
implements SdkIterable<ListRoleTagsResponse> {
    private final IamClient client;
    private final ListRoleTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoleTagsIterable(IamClient client, ListRoleTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoleTagsResponseFetcher();
    }

    public Iterator<ListRoleTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListRoleTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoleTagsResponseFetcher
    implements SyncPageFetcher<ListRoleTagsResponse> {
        private ListRoleTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListRoleTagsResponse nextPage(ListRoleTagsResponse previousPage) {
            if (previousPage == null) {
                return ListRoleTagsIterable.this.client.listRoleTags(ListRoleTagsIterable.this.firstRequest);
            }
            return ListRoleTagsIterable.this.client.listRoleTags((ListRoleTagsRequest)((Object)ListRoleTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

