/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.services.iam.model.AddUserToGroupResponse;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.ChangePasswordRequest;
import software.amazon.awssdk.services.iam.model.ChangePasswordResponse;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;
import software.amazon.awssdk.services.iam.model.CreateGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupResponse;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserResponse;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootCredentialsManagementRequest;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootCredentialsManagementResponse;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootSessionsRequest;
import software.amazon.awssdk.services.iam.model.DisableOrganizationsRootSessionsResponse;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootCredentialsManagementRequest;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootCredentialsManagementResponse;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootSessionsRequest;
import software.amazon.awssdk.services.iam.model.EnableOrganizationsRootSessionsResponse;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryRequest;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GetCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.GetLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.GetSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.GetServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.GetServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListOrganizationsFeaturesRequest;
import software.amazon.awssdk.services.iam.model.ListOrganizationsFeaturesResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProviderTagsResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.PutRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupRequest;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupResponse;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesRequest;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesResponse;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.TagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.TagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.TagPolicyRequest;
import software.amazon.awssdk.services.iam.model.TagPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagRoleRequest;
import software.amazon.awssdk.services.iam.model.TagRoleResponse;
import software.amazon.awssdk.services.iam.model.TagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.TagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.TagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.TagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.TagUserRequest;
import software.amazon.awssdk.services.iam.model.TagUserResponse;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.UntagInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.UntagMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagPolicyRequest;
import software.amazon.awssdk.services.iam.model.UntagPolicyResponse;
import software.amazon.awssdk.services.iam.model.UntagRoleRequest;
import software.amazon.awssdk.services.iam.model.UntagRoleResponse;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UntagSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UntagServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UntagUserRequest;
import software.amazon.awssdk.services.iam.model.UntagUserResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.services.iam.model.UpdateGroupResponse;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleResponse;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;
import software.amazon.awssdk.services.iam.model.UpdateUserResponse;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher;
import software.amazon.awssdk.services.iam.paginators.GetGroupPublisher;
import software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher;
import software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyPublisher;
import software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListGroupsForUserPublisher;
import software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfileTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRolePublisher;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListMFADeviceTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListOpenIDConnectProviderTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListPolicyTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListRolePoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListRoleTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListRolesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListSAMLProviderTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysPublisher;
import software.amazon.awssdk.services.iam.paginators.ListServerCertificateTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListServerCertificatesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListUserPoliciesPublisher;
import software.amazon.awssdk.services.iam.paginators.ListUserTagsPublisher;
import software.amazon.awssdk.services.iam.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesPublisher;
import software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyPublisher;
import software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyPublisher;
import software.amazon.awssdk.services.iam.waiters.IamAsyncWaiter;

/**
 * Service client for accessing IAM asynchronously. This can be created using the static {@link #builder()} method.The
 * asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient} supported in the
 * SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in some cases such
 * as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Identity and Access Management</fullname>
 * <p>
 * Identity and Access Management (IAM) is a web service for securely controlling access to Amazon Web Services
 * services. With IAM, you can centrally manage users, security credentials such as access keys, and permissions that
 * control which Amazon Web Services resources users and applications can access. For more information about IAM, see <a
 * href="http://aws.amazon.com/iam/">Identity and Access Management (IAM)</a> and the <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/">Identity and Access Management User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IamAsyncClient extends AwsClient {
    String SERVICE_NAME = "iam";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iam";

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the AddClientIDToOpenIDConnectProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddClientIdToOpenIdConnectProviderResponse> addClientIDToOpenIDConnectProvider(
            AddClientIdToOpenIdConnectProviderRequest addClientIdToOpenIdConnectProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddClientIdToOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link AddClientIdToOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddClientIDToOpenIDConnectProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddClientIdToOpenIdConnectProviderResponse> addClientIDToOpenIDConnectProvider(
            Consumer<AddClientIdToOpenIdConnectProviderRequest.Builder> addClientIdToOpenIdConnectProviderRequest) {
        return addClientIDToOpenIDConnectProvider(AddClientIdToOpenIdConnectProviderRequest.builder()
                .applyMutation(addClientIdToOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and
     * this quota cannot be increased. You can remove the existing role and then add a different role to an instance
     * profile. You must then wait for the change to appear across all of Amazon Web Services because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this operation must be granted the <code>PassRole</code> permission on the IAM role by a
     * permissions policy.
     * </p>
     * </note> <important>
     * <p>
     * When using the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#available-keys-for-iam"
     * >iam:AssociatedResourceArn</a> condition in a policy to restrict the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> IAM action,
     * special considerations apply if the policy is intended to define access for the
     * <code>AddRoleToInstanceProfile</code> action. In this case, you cannot specify a Region or instance ID in the EC2
     * instance ARN. The ARN value must be <code>arn:aws:ec2:*:CallerAccountId:instance/*</code>. Using any other ARN
     * value may lead to unexpected evaluation results.
     * </p>
     * </important>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     * @return A Java Future containing the result of the AddRoleToInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddRoleToInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddRoleToInstanceProfileResponse> addRoleToInstanceProfile(
            AddRoleToInstanceProfileRequest addRoleToInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and
     * this quota cannot be increased. You can remove the existing role and then add a different role to an instance
     * profile. You must then wait for the change to appear across all of Amazon Web Services because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this operation must be granted the <code>PassRole</code> permission on the IAM role by a
     * permissions policy.
     * </p>
     * </note> <important>
     * <p>
     * When using the <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#available-keys-for-iam"
     * >iam:AssociatedResourceArn</a> condition in a policy to restrict the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> IAM action,
     * special considerations apply if the policy is intended to define access for the
     * <code>AddRoleToInstanceProfile</code> action. In this case, you cannot specify a Region or instance ID in the EC2
     * instance ARN. The ARN value must be <code>arn:aws:ec2:*:CallerAccountId:instance/*</code>. Using any other ARN
     * value may lead to unexpected evaluation results.
     * </p>
     * </important>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToInstanceProfileRequest.Builder} avoiding
     * the need to create one manually via {@link AddRoleToInstanceProfileRequest#builder()}
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddRoleToInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddRoleToInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddRoleToInstanceProfileResponse> addRoleToInstanceProfile(
            Consumer<AddRoleToInstanceProfileRequest.Builder> addRoleToInstanceProfileRequest) {
        return addRoleToInstanceProfile(AddRoleToInstanceProfileRequest.builder().applyMutation(addRoleToInstanceProfileRequest)
                .build());
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     *
     * @param addUserToGroupRequest
     * @return A Java Future containing the result of the AddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddUserToGroupResponse> addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddUserToGroupRequest.Builder} avoiding the need to
     * create one manually via {@link AddUserToGroupRequest#builder()}
     * </p>
     *
     * @param addUserToGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AddUserToGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddUserToGroupResponse> addUserToGroup(Consumer<AddUserToGroupRequest.Builder> addUserToGroupRequest) {
        return addUserToGroup(AddUserToGroupRequest.builder().applyMutation(addUserToGroupRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html"> <code>PutGroupPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachGroupPolicyRequest
     * @return A Java Future containing the result of the AttachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachGroupPolicyResponse> attachGroupPolicy(AttachGroupPolicyRequest attachGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html"> <code>PutGroupPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachGroupPolicyRequest#builder()}
     * </p>
     *
     * @param attachGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachGroupPolicyResponse> attachGroupPolicy(
            Consumer<AttachGroupPolicyRequest.Builder> attachGroupPolicyRequest) {
        return attachGroupPolicy(AttachGroupPolicyRequest.builder().applyMutation(attachGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">
     * <code>CreateRole</code> </a>. You can update a role's trust policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html">
     * <code>UpdateAssumerolePolicy</code> </a>.
     * </p>
     * </note>
     * <p>
     * Use this operation to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html"> <code>PutRolePolicy</code>
     * </a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachRolePolicyRequest
     * @return A Java Future containing the result of the AttachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachRolePolicyResponse> attachRolePolicy(AttachRolePolicyRequest attachRolePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">
     * <code>CreateRole</code> </a>. You can update a role's trust policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html">
     * <code>UpdateAssumerolePolicy</code> </a>.
     * </p>
     * </note>
     * <p>
     * Use this operation to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html"> <code>PutRolePolicy</code>
     * </a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachRolePolicyRequest#builder()}
     * </p>
     *
     * @param attachRolePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachRolePolicyResponse> attachRolePolicy(
            Consumer<AttachRolePolicyRequest.Builder> attachRolePolicyRequest) {
        return attachRolePolicy(AttachRolePolicyRequest.builder().applyMutation(attachRolePolicyRequest).build());
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this operation to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html"> <code>PutUserPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachUserPolicyRequest
     * @return A Java Future containing the result of the AttachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachUserPolicyResponse> attachUserPolicy(AttachUserPolicyRequest attachUserPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this operation to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html"> <code>PutUserPolicy</code>
     * </a>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link AttachUserPolicyRequest#builder()}
     * </p>
     *
     * @param attachUserPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>PolicyNotAttachableException The request failed because Amazon Web Services service role policies can
     *         only be attached to the service-linked role for that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.AttachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AttachUserPolicyResponse> attachUserPolicy(
            Consumer<AttachUserPolicyRequest.Builder> attachUserPolicyRequest) {
        return attachUserPolicy(AttachUserPolicyRequest.builder().applyMutation(attachUserPolicyRequest).build());
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the
     * CLI, the Amazon Web Services API, or the <b>My Security Credentials</b> page in the Amazon Web Services
     * Management Console. The Amazon Web Services account root user password is not affected by this operation.
     * </p>
     * <p>
     * Use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateLoginProfile.html">UpdateLoginProfile</a> to
     * use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to change the password for
     * any IAM user. For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param changePasswordRequest
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidUserTypeException The request was rejected because the type of user for the transaction was
     *         incorrect.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the
     * CLI, the Amazon Web Services API, or the <b>My Security Credentials</b> page in the Amazon Web Services
     * Management Console. The Amazon Web Services account root user password is not affected by this operation.
     * </p>
     * <p>
     * Use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateLoginProfile.html">UpdateLoginProfile</a> to
     * use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to change the password for
     * any IAM user. For more information about modifying passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangePasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ChangePasswordRequest#builder()}
     * </p>
     *
     * @param changePasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ChangePasswordRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidUserTypeException The request was rejected because the type of user for the transaction was
     *         incorrect.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(Consumer<ChangePasswordRequest.Builder> changePasswordRequest) {
        return changePassword(ChangePasswordRequest.builder().applyMutation(changePasswordRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is
     * true even if the Amazon Web Services account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation. You must save the key (for example, in a text file) if you want to be able to access it again.
     * If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @param createAccessKeyRequest
     * @return A Java Future containing the result of the CreateAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccessKeyResponse> createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is
     * true even if the Amazon Web Services account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation. You must save the key (for example, in a text file) if you want to be able to access it again.
     * If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccessKeyRequest#builder()}
     * </p>
     *
     * @param createAccessKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccessKeyResponse> createAccessKey(
            Consumer<CreateAccessKeyRequest.Builder> createAccessKeyRequest) {
        return createAccessKey(CreateAccessKeyRequest.builder().applyMutation(createAccessKeyRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
     * specified user. The default status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is
     * true even if the Amazon Web Services account has no associated users.
     * </p>
     * <p>
     * For information about quotas on the number of keys you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation. You must save the key (for example, in a text file) if you want to be able to access it again.
     * If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the CreateAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccessKeyResponse> createAccessKey() {
        return createAccessKey(CreateAccessKeyRequest.builder().build());
    }

    /**
     * <p>
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
     * alias, see <a href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User
     * Guide</i>.
     * </p>
     *
     * @param createAccountAliasRequest
     * @return A Java Future containing the result of the CreateAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccountAliasResponse> createAccountAlias(CreateAccountAliasRequest createAccountAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
     * alias, see <a href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccountAliasRequest#builder()}
     * </p>
     *
     * @param createAccountAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccountAliasResponse> createAccountAlias(
            Consumer<CreateAccountAliasRequest.Builder> createAccountAliasRequest) {
        return createAccountAlias(CreateAccountAliasRequest.builder().applyMutation(createAccountAliasRequest).build());
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * For information about the number of groups you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * For information about the number of groups you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using roles for
     * applications on Amazon EC2</a> in the <i>IAM User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile"
     * >Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about the number of instance profiles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            CreateInstanceProfileRequest createInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using roles for
     * applications on Amazon EC2</a> in the <i>IAM User Guide</i>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile"
     * >Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about the number of instance profiles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services
     * services through the Amazon Web Services Management Console.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to create a
     * password for any IAM user. Use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html">ChangePassword</a> to update
     * your own existing password in the <b>My Security Credentials</b> page in the Amazon Web Services Management
     * Console.
     * </p>
     * <p>
     * For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createLoginProfileRequest
     * @return A Java Future containing the result of the CreateLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLoginProfileResponse> createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services
     * services through the Amazon Web Services Management Console.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to create a
     * password for any IAM user. Use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html">ChangePassword</a> to update
     * your own existing password in the <b>My Security Credentials</b> page in the Amazon Web Services Management
     * Console.
     * </p>
     * <p>
     * For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLoginProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLoginProfileRequest#builder()}
     * </p>
     *
     * @param createLoginProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>PasswordPolicyViolationException The request was rejected because the provided password did not meet
     *         the requirements imposed by the account password policy.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLoginProfileResponse> createLoginProfile(
            Consumer<CreateLoginProfileRequest.Builder> createLoginProfileRequest) {
        return createLoginProfile(CreateLoginProfileRequest.builder().applyMutation(createLoginProfileRequest).build());
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between Amazon Web Services and the OIDC provider.
     * </p>
     * <p>
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a
     * separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are
     * available for your use. Instead, you can move directly to creating new roles using your identity provider. To
     * learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating a role for web
     * identity or OpenID connect federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of tags that are attached to the specified IAM OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP you want to use to access Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services secures communication with OIDC identity providers (IdPs) using our library of trusted root
     * certificate authorities (CAs) to verify the JSON Web Key Set (JWKS) endpoint's TLS certificate. If your OIDC IdP
     * relies on a certificate that is not signed by one of these trusted CAs, only then we secure communication using
     * the thumbprints set in the IdP's configuration.
     * </p>
     * </note> <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html"
     * >CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note>
     *
     * @param createOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the CreateOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>OpenIdIdpCommunicationErrorException The request failed because IAM cannot connect to the OpenID
     *         Connect identity provider URL.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOpenIdConnectProviderResponse> createOpenIDConnectProvider(
            CreateOpenIdConnectProviderRequest createOpenIdConnectProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between Amazon Web Services and the OIDC provider.
     * </p>
     * <p>
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a
     * separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are
     * available for your use. Instead, you can move directly to creating new roles using your identity provider. To
     * learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating a role for web
     * identity or OpenID connect federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of tags that are attached to the specified IAM OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP you want to use to access Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services secures communication with OIDC identity providers (IdPs) using our library of trusted root
     * certificate authorities (CAs) to verify the JSON Web Key Set (JWKS) endpoint's TLS certificate. If your OIDC IdP
     * relies on a certificate that is not signed by one of these trusted CAs, only then we secure communication using
     * the thumbprints set in the IdP's configuration.
     * </p>
     * </note> <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html"
     * >CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param createOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>OpenIdIdpCommunicationErrorException The request failed because IAM cannot connect to the OpenID
     *         Connect identity provider URL.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOpenIdConnectProviderResponse> createOpenIDConnectProvider(
            Consumer<CreateOpenIdConnectProviderRequest.Builder> createOpenIdConnectProviderRequest) {
        return createOpenIDConnectProvider(CreateOpenIdConnectProviderRequest.builder()
                .applyMutation(createOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Creates a new managed policy for your Amazon Web Services account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyRequest
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new managed policy for your Amazon Web Services account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * As a best practice, you can validate your IAM policies. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePolicyRequest#builder()}
     * </p>
     *
     * @param createPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreatePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(Consumer<CreatePolicyRequest.Builder> createPolicyRequest) {
        return createPolicy(CreatePolicyRequest.builder().applyMutation(createPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>
     * before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyVersionRequest
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            CreatePolicyVersionRequest createPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>
     * before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePolicyVersionRequest#builder()}
     * </p>
     *
     * @param createPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreatePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            Consumer<CreatePolicyVersionRequest.Builder> createPolicyVersionRequest) {
        return createPolicyVersion(CreatePolicyVersionRequest.builder().applyMutation(createPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new role for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For information about quotas for role names and the number of roles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createRoleRequest
     * @return A Java Future containing the result of the CreateRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoleResponse> createRole(CreateRoleRequest createRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new role for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * For information about quotas for role names and the number of roles you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRoleRequest#builder()}
     * </p>
     *
     * @param createRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>MalformedPolicyDocumentException The request was rejected because the policy document was malformed.
     *         The error message describes the specific error.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRoleResponse> createRole(Consumer<CreateRoleRequest.Builder> createRoleRequest) {
        return createRole(CreateRoleRequest.builder().applyMutation(createRoleRequest).build());
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or
     * one that supports API access to Amazon Web Services.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 federated users to access the Amazon Web Services Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createSamlProviderRequest
     * @return A Java Future containing the result of the CreateSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSamlProviderResponse> createSAMLProvider(CreateSamlProviderRequest createSamlProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or
     * one that supports API access to Amazon Web Services.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 federated users to access the Amazon Web Services Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * federation</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSamlProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSamlProviderRequest#builder()}
     * </p>
     *
     * @param createSamlProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSamlProviderResponse> createSAMLProvider(
            Consumer<CreateSamlProviderRequest.Builder> createSamlProviderRequest) {
        return createSAMLProvider(CreateSamlProviderRequest.builder().applyMutation(createSamlProviderRequest).build());
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached
     * policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly
     * changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the
     * service to control the role helps improve service stability and proper cleanup when a service and its role are no
     * longer needed. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
     * roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the Amazon Web Services service
     * that depends on this role.
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     * @return A Java Future containing the result of the CreateServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceLinkedRoleResponse> createServiceLinkedRole(
            CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached
     * policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly
     * changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the
     * service to control the role helps improve service stability and proper cleanup when a service and its role are no
     * longer needed. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
     * roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the Amazon Web Services service
     * that depends on this role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceLinkedRoleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateServiceLinkedRoleRequest#builder()}
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceLinkedRoleResponse> createServiceLinkedRole(
            Consumer<CreateServiceLinkedRoleRequest.Builder> createServiceLinkedRoleRequest) {
        return createServiceLinkedRole(CreateServiceLinkedRoleRequest.builder().applyMutation(createServiceLinkedRoleRequest)
                .build());
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * You can create service-specific credentials for Amazon Bedrock, CodeCommit and Amazon Keyspaces (for Apache
     * Cassandra).
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResetServiceSpecificCredential.html"
     * >ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_bedrock.html">Service-specific credentials
     * for IAM users</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the CreateServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceNotSupportedException The specified service does not support service-specific credentials.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceSpecificCredentialResponse> createServiceSpecificCredential(
            CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * You can create service-specific credentials for Amazon Bedrock, CodeCommit and Amazon Keyspaces (for Apache
     * Cassandra).
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResetServiceSpecificCredential.html"
     * >ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_bedrock.html">Service-specific credentials
     * for IAM users</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceSpecificCredentialRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceSpecificCredentialRequest#builder()}
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceNotSupportedException The specified service does not support service-specific credentials.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceSpecificCredentialResponse> createServiceSpecificCredential(
            Consumer<CreateServiceSpecificCredentialRequest.Builder> createServiceSpecificCredentialRequest) {
        return createServiceSpecificCredential(CreateServiceSpecificCredentialRequest.builder()
                .applyMutation(createServiceSpecificCredentialRequest).build());
    }

    /**
     * <p>
     * Creates a new IAM user for your Amazon Web Services account.
     * </p>
     * <p>
     * For information about quotas for the number of IAM users you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IAM user for your Amazon Web Services account.
     * </p>
     * <p>
     * For information about quotas for the number of IAM users you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html">EnableMFADevice</a> to attach
     * the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA device</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of MFA devices you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your Amazon Web Services access
     * keys or your passwords. After you provision your virtual device, you should ensure that the information is
     * destroyed following secure procedures.
     * </p>
     * </important>
     *
     * @param createVirtualMfaDeviceRequest
     * @return A Java Future containing the result of the CreateVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualMfaDeviceResponse> createVirtualMFADevice(
            CreateVirtualMfaDeviceRequest createVirtualMfaDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html">EnableMFADevice</a> to attach
     * the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA device</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about the maximum number of MFA devices you can create, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your Amazon Web Services access
     * keys or your passwords. After you provision your virtual device, you should ensure that the information is
     * destroyed following secure procedures.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVirtualMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVirtualMfaDeviceRequest#builder()}
     * </p>
     *
     * @param createVirtualMfaDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.CreateVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVirtualMfaDeviceResponse> createVirtualMFADevice(
            Consumer<CreateVirtualMfaDeviceRequest.Builder> createVirtualMfaDeviceRequest) {
        return createVirtualMFADevice(CreateVirtualMfaDeviceRequest.builder().applyMutation(createVirtualMfaDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual multi-factor
     * authentication (MFA) device</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     * @return A Java Future containing the result of the DeactivateMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeactivateMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeactivateMfaDeviceResponse> deactivateMFADevice(
            DeactivateMfaDeviceRequest deactivateMfaDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual multi-factor
     * authentication (MFA) device</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeactivateMfaDeviceRequest#builder()}
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeactivateMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeactivateMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeactivateMfaDeviceResponse> deactivateMFADevice(
            Consumer<DeactivateMfaDeviceRequest.Builder> deactivateMfaDeviceRequest) {
        return deactivateMFADevice(DeactivateMfaDeviceRequest.builder().applyMutation(deactivateMfaDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated users.
     * </p>
     *
     * @param deleteAccessKeyRequest
     * @return A Java Future containing the result of the DeleteAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccessKeyResponse> deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccessKeyRequest#builder()}
     * </p>
     *
     * @param deleteAccessKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccessKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccessKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccessKeyResponse> deleteAccessKey(
            Consumer<DeleteAccessKeyRequest.Builder> deleteAccessKeyRequest) {
        return deleteAccessKey(DeleteAccessKeyRequest.builder().applyMutation(deleteAccessKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
     * account alias, see <a
     * href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating, deleting, and
     * listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User Guide</i>.
     * </p>
     *
     * @param deleteAccountAliasRequest
     * @return A Java Future containing the result of the DeleteAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountAliasResponse> deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
     * account alias, see <a
     * href="https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html">Creating, deleting, and
     * listing an Amazon Web Services account alias</a> in the <i>Amazon Web Services Sign-In User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccountAliasRequest#builder()}
     * </p>
     *
     * @param deleteAccountAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccountAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccountAliasResponse> deleteAccountAlias(
            Consumer<DeleteAccountAliasRequest.Builder> deleteAccountAliasRequest) {
        return deleteAccountAlias(DeleteAccountAliasRequest.builder().applyMutation(deleteAccountAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     * @return A Java Future containing the result of the DeleteAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountPasswordPolicyResponse> deleteAccountPasswordPolicy(
            DeleteAccountPasswordPolicyRequest deleteAccountPasswordPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountPasswordPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccountPasswordPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountPasswordPolicyResponse> deleteAccountPasswordPolicy(
            Consumer<DeleteAccountPasswordPolicyRequest.Builder> deleteAccountPasswordPolicyRequest) {
        return deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.builder()
                .applyMutation(deleteAccountPasswordPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountPasswordPolicyResponse> deleteAccountPasswordPolicy() {
        return deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html">DetachGroupPolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupPolicyResponse> deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html">DetachGroupPolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGroupPolicyRequest#builder()}
     * </p>
     *
     * @param deleteGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupPolicyResponse> deleteGroupPolicy(
            Consumer<DeleteGroupPolicyRequest.Builder> deleteGroupPolicyRequest) {
        return deleteGroupPolicy(DeleteGroupPolicyRequest.builder().applyMutation(deleteGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            DeleteInstanceProfileRequest deleteInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user or root user, For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html">Managing
     * passwords for IAM users</a>.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to delete a
     * password for any IAM user. You can use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html">ChangePassword</a> to update,
     * but not delete, your own password in the <b>My Security Credentials</b> page in the Amazon Web Services
     * Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line
     * interface or the API. To prevent all user access, you must also either make any access keys inactive or delete
     * them. For more information about making keys inactive or deleting them, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccessKey.html">UpdateAccessKey</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html">DeleteAccessKey</a>.
     * </p>
     * </important>
     *
     * @param deleteLoginProfileRequest
     * @return A Java Future containing the result of the DeleteLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLoginProfileResponse> deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user or root user, For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html">Managing
     * passwords for IAM users</a>.
     * </p>
     * <p>
     * You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to delete a
     * password for any IAM user. You can use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html">ChangePassword</a> to update,
     * but not delete, your own password in the <b>My Security Credentials</b> page in the Amazon Web Services
     * Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line
     * interface or the API. To prevent all user access, you must also either make any access keys inactive or delete
     * them. For more information about making keys inactive or deleting them, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccessKey.html">UpdateAccessKey</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html">DeleteAccessKey</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoginProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLoginProfileRequest#builder()}
     * </p>
     *
     * @param deleteLoginProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLoginProfileResponse> deleteLoginProfile(
            Consumer<DeleteLoginProfileRequest.Builder> deleteLoginProfileRequest) {
        return deleteLoginProfile(DeleteLoginProfileRequest.builder().applyMutation(deleteLoginProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the DeleteOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOpenIdConnectProviderResponse> deleteOpenIDConnectProvider(
            DeleteOpenIdConnectProviderRequest deleteOpenIdConnectProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOpenIdConnectProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOpenIdConnectProviderResponse> deleteOpenIDConnectProvider(
            Consumer<DeleteOpenIdConnectProviderRequest.Builder> deleteOpenIdConnectProviderRequest) {
        return deleteOpenIDConnectProvider(DeleteOpenIdConnectProviderRequest.builder()
                .applyMutation(deleteOpenIdConnectProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html">DetachGroupPolicy</a>, or
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>. To
     * list all the users, groups, and roles that a policy is attached to, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html"
     * >ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>.
     * To list the policy's versions, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * You cannot use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>
     * to delete the version that is marked as the default version. You delete the policy's default version in the next
     * step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html">DetachGroupPolicy</a>, or
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>. To
     * list all the users, groups, and roles that a policy is attached to, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html"
     * >ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>.
     * To list the policy's versions, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * You cannot use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html">DeletePolicyVersion</a>
     * to delete the version that is marked as the default version. You delete the policy's default version in the next
     * step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeletePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this operation. To delete the default version from a
     * policy, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.
     * To find out which version of a policy is marked as the default version, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyVersionRequest
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            DeletePolicyVersionRequest deletePolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this operation. To delete the default version from a
     * policy, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.
     * To find out which version of a policy is marked as the default version, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePolicyVersionRequest#builder()}
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeletePolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            Consumer<DeletePolicyVersionRequest.Builder> deletePolicyVersionRequest) {
        return deletePolicyVersion(DeletePolicyVersionRequest.builder().applyMutation(deletePolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role
     * programmatically, you must delete the items attached to the role manually, or the deletion fails. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli"
     * >Deleting an IAM role</a>. Before attempting to delete a role, remove the following attached items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html">DeleteRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance profile (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveRoleFromInstanceProfile.html"
     * >RemoveRoleFromInstanceProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional – Delete instance profile after detaching from role for resource clean up (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html"
     * >DeleteInstanceProfile</a>)
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important>
     *
     * @param deleteRoleRequest
     * @return A Java Future containing the result of the DeleteRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoleResponse> deleteRole(DeleteRoleRequest deleteRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role
     * programmatically, you must delete the items attached to the role manually, or the deletion fails. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli"
     * >Deleting an IAM role</a>. Before attempting to delete a role, remove the following attached items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html">DeleteRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance profile (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveRoleFromInstanceProfile.html"
     * >RemoveRoleFromInstanceProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional – Delete instance profile after detaching from role for resource clean up (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html"
     * >DeleteInstanceProfile</a>)
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRoleRequest#builder()}
     * </p>
     *
     * @param deleteRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRoleResponse> deleteRole(Consumer<DeleteRoleRequest.Builder> deleteRoleRequest) {
        return deleteRole(DeleteRoleRequest.builder().applyMutation(deleteRoleRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteRolePermissionsBoundaryRequest
     * @return A Java Future containing the result of the DeleteRolePermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRolePermissionsBoundaryResponse> deleteRolePermissionsBoundary(
            DeleteRolePermissionsBoundaryRequest deleteRolePermissionsBoundaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRolePermissionsBoundaryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRolePermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param deleteRolePermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRolePermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRolePermissionsBoundaryResponse> deleteRolePermissionsBoundary(
            Consumer<DeleteRolePermissionsBoundaryRequest.Builder> deleteRolePermissionsBoundaryRequest) {
        return deleteRolePermissionsBoundary(DeleteRolePermissionsBoundaryRequest.builder()
                .applyMutation(deleteRolePermissionsBoundaryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteRolePolicyRequest
     * @return A Java Future containing the result of the DeleteRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRolePolicyResponse> deleteRolePolicy(DeleteRolePolicyRequest deleteRolePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html">DetachRolePolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRolePolicyRequest#builder()}
     * </p>
     *
     * @param deleteRolePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRolePolicyResponse> deleteRolePolicy(
            Consumer<DeleteRolePolicyRequest.Builder> deleteRolePolicyRequest) {
        return deleteRolePolicy(DeleteRolePolicyRequest.builder().applyMutation(deleteRolePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param deleteSamlProviderRequest
     * @return A Java Future containing the result of the DeleteSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSamlProviderResponse> deleteSAMLProvider(DeleteSamlProviderRequest deleteSamlProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSamlProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSamlProviderRequest#builder()}
     * </p>
     *
     * @param deleteSamlProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSamlProviderResponse> deleteSAMLProvider(
            Consumer<DeleteSamlProviderRequest.Builder> deleteSamlProviderRequest) {
        return deleteSAMLProvider(DeleteSamlProviderRequest.builder().applyMutation(deleteSamlProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return A Java Future containing the result of the DeleteSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSshPublicKeyResponse> deleteSSHPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSshPublicKeyResponse> deleteSSHPublicKey(
            Consumer<DeleteSshPublicKeyRequest.Builder> deleteSshPublicKeyRequest) {
        return deleteSSHPublicKey(DeleteSshPublicKeyRequest.builder().applyMutation(deleteSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of Amazon Web Services services
     * that can use the server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important>
     *
     * @param deleteServerCertificateRequest
     * @return A Java Future containing the result of the DeleteServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServerCertificateResponse> deleteServerCertificate(
            DeleteServerCertificateRequest deleteServerCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of Amazon Web Services services
     * that can use the server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServerCertificateRequest#builder()}
     * </p>
     *
     * @param deleteServerCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServerCertificateResponse> deleteServerCertificate(
            Consumer<DeleteServerCertificateRequest.Builder> deleteServerCertificateRequest) {
        return deleteServerCertificate(DeleteServerCertificateRequest.builder().applyMutation(deleteServerCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLinkedRoleDeletionStatus.html"
     * >GetServiceLinkedRoleDeletionStatus</a> operation returns the reason for the failure, usually including the
     * resources that must be deleted. To delete the service-linked role, you must first remove those resources from the
     * linked service and then submit the deletion request again. Resources are specific to the service that is linked
     * to the role. For more information about removing resources from a service, see the <a
     * href="http://docs.aws.amazon.com/">Amazon Web Services documentation</a> for your service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles terms and concepts: Amazon Web Services service-linked role</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     * @return A Java Future containing the result of the DeleteServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceLinkedRoleResponse> deleteServiceLinkedRole(
            DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLinkedRoleDeletionStatus.html"
     * >GetServiceLinkedRoleDeletionStatus</a> operation returns the reason for the failure, usually including the
     * resources that must be deleted. To delete the service-linked role, you must first remove those resources from the
     * linked service and then submit the deletion request again. Resources are specific to the service that is linked
     * to the role. For more information about removing resources from a service, see the <a
     * href="http://docs.aws.amazon.com/">Amazon Web Services documentation</a> for your service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles terms and concepts: Amazon Web Services service-linked role</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceLinkedRoleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteServiceLinkedRoleRequest#builder()}
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceLinkedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceLinkedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceLinkedRoleResponse> deleteServiceLinkedRole(
            Consumer<DeleteServiceLinkedRoleRequest.Builder> deleteServiceLinkedRoleRequest) {
        return deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest.builder().applyMutation(deleteServiceLinkedRoleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     * @return A Java Future containing the result of the DeleteServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceSpecificCredentialResponse> deleteServiceSpecificCredential(
            DeleteServiceSpecificCredentialRequest deleteServiceSpecificCredentialRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceSpecificCredentialRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceSpecificCredentialRequest#builder()}
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteServiceSpecificCredential operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteServiceSpecificCredential
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceSpecificCredentialResponse> deleteServiceSpecificCredential(
            Consumer<DeleteServiceSpecificCredentialRequest.Builder> deleteServiceSpecificCredentialRequest) {
        return deleteServiceSpecificCredential(DeleteServiceSpecificCredentialRequest.builder()
                .applyMutation(deleteServiceSpecificCredentialRequest).build());
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated IAM users.
     * </p>
     *
     * @param deleteSigningCertificateRequest
     * @return A Java Future containing the result of the DeleteSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSigningCertificateResponse> deleteSigningCertificate(
            DeleteSigningCertificateRequest deleteSigningCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID signing the request. This operation works for access keys under the Amazon Web Services account.
     * Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the
     * Amazon Web Services account has no associated IAM users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSigningCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSigningCertificateRequest#builder()}
     * </p>
     *
     * @param deleteSigningCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSigningCertificateResponse> deleteSigningCertificate(
            Consumer<DeleteSigningCertificateRequest.Builder> deleteSigningCertificateRequest) {
        return deleteSigningCertificate(DeleteSigningCertificateRequest.builder().applyMutation(deleteSigningCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
     * programmatically, you must delete the items attached to the user manually, or the deletion fails. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM user</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteLoginProfile.html">DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html">DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSigningCertificate.html"
     * >DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSSHPublicKey.html">DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceSpecificCredential.html"
     * >DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html">DeactivateMFADevice</a>,
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteVirtualMFADevice.html">
     * DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html">DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveUserFromGroup.html">RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
     * programmatically, you must delete the items attached to the user manually, or the deletion fails. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM user</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteLoginProfile.html">DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html">DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSigningCertificate.html"
     * >DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSSHPublicKey.html">DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceSpecificCredential.html"
     * >DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html">DeactivateMFADevice</a>,
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteVirtualMFADevice.html">
     * DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html">DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveUserFromGroup.html">RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteUserPermissionsBoundaryRequest
     * @return A Java Future containing the result of the DeleteUserPermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPermissionsBoundaryResponse> deleteUserPermissionsBoundary(
            DeleteUserPermissionsBoundaryRequest deleteUserPermissionsBoundaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPermissionsBoundaryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteUserPermissionsBoundaryRequest#builder()}
     * </p>
     *
     * @param deleteUserPermissionsBoundaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserPermissionsBoundary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPermissionsBoundary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPermissionsBoundaryResponse> deleteUserPermissionsBoundary(
            Consumer<DeleteUserPermissionsBoundaryRequest.Builder> deleteUserPermissionsBoundaryRequest) {
        return deleteUserPermissionsBoundary(DeleteUserPermissionsBoundaryRequest.builder()
                .applyMutation(deleteUserPermissionsBoundaryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteUserPolicyRequest
     * @return A Java Future containing the result of the DeleteUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserPolicyResponse> deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html">DetachUserPolicy</a>. For
     * more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUserPolicyRequest#builder()}
     * </p>
     *
     * @param deleteUserPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserPolicyResponse> deleteUserPolicy(
            Consumer<DeleteUserPolicyRequest.Builder> deleteUserPolicyRequest) {
        return deleteUserPolicy(DeleteUserPolicyRequest.builder().applyMutation(deleteUserPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html">DeactivateMFADevice</a>.
     * </p>
     * </note>
     *
     * @param deleteVirtualMfaDeviceRequest
     * @return A Java Future containing the result of the DeleteVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualMfaDeviceResponse> deleteVirtualMFADevice(
            DeleteVirtualMfaDeviceRequest deleteVirtualMfaDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html">DeactivateMFADevice</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualMfaDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualMfaDeviceRequest#builder()}
     * </p>
     *
     * @param deleteVirtualMfaDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVirtualMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>DeleteConflictException The request was rejected because it attempted to delete a resource that has
     *         attached subordinate entities. The error message describes these entities.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DeleteVirtualMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVirtualMfaDeviceResponse> deleteVirtualMFADevice(
            Consumer<DeleteVirtualMfaDeviceRequest.Builder> deleteVirtualMfaDeviceRequest) {
        return deleteVirtualMFADevice(DeleteVirtualMfaDeviceRequest.builder().applyMutation(deleteVirtualMfaDeviceRequest)
                .build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroupPolicy.html">DeleteGroupPolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachGroupPolicyRequest
     * @return A Java Future containing the result of the DetachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachGroupPolicyResponse> detachGroupPolicy(DetachGroupPolicyRequest detachGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroupPolicy.html">DeleteGroupPolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachGroupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachGroupPolicyRequest#builder()}
     * </p>
     *
     * @param detachGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachGroupPolicyResponse> detachGroupPolicy(
            Consumer<DetachGroupPolicyRequest.Builder> detachGroupPolicyRequest) {
        return detachGroupPolicy(DetachGroupPolicyRequest.builder().applyMutation(detachGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html">DeleteRolePolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachRolePolicyRequest
     * @return A Java Future containing the result of the DetachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachRolePolicyResponse> detachRolePolicy(DetachRolePolicyRequest detachRolePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html">DeleteRolePolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachRolePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachRolePolicyRequest#builder()}
     * </p>
     *
     * @param detachRolePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>UnmodifiableEntityException The request was rejected because service-linked roles are protected
     *         Amazon Web Services resources. Only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachRolePolicyResponse> detachRolePolicy(
            Consumer<DetachRolePolicyRequest.Builder> detachRolePolicyRequest) {
        return detachRolePolicy(DetachRolePolicyRequest.builder().applyMutation(detachRolePolicyRequest).build());
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html">DeleteUserPolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachUserPolicyRequest
     * @return A Java Future containing the result of the DetachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachUserPolicyResponse> detachUserPolicy(DetachUserPolicyRequest detachUserPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html">DeleteUserPolicy</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachUserPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DetachUserPolicyRequest#builder()}
     * </p>
     *
     * @param detachUserPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DetachUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DetachUserPolicyResponse> detachUserPolicy(
            Consumer<DetachUserPolicyRequest.Builder> detachUserPolicyRequest) {
        return detachUserPolicy(DetachUserPolicyRequest.builder().applyMutation(detachUserPolicyRequest).build());
    }

    /**
     * <p>
     * Disables the management of privileged root user credentials across member accounts in your organization. When you
     * disable this feature, the management account and the delegated administrator for IAM can no longer manage root
     * user credentials for member accounts in your organization.
     * </p>
     *
     * @param disableOrganizationsRootCredentialsManagementRequest
     * @return A Java Future containing the result of the DisableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationsRootCredentialsManagementResponse> disableOrganizationsRootCredentialsManagement(
            DisableOrganizationsRootCredentialsManagementRequest disableOrganizationsRootCredentialsManagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the management of privileged root user credentials across member accounts in your organization. When you
     * disable this feature, the management account and the delegated administrator for IAM can no longer manage root
     * user credentials for member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableOrganizationsRootCredentialsManagementRequest.Builder} avoiding the need to create one manually via
     * {@link DisableOrganizationsRootCredentialsManagementRequest#builder()}
     * </p>
     *
     * @param disableOrganizationsRootCredentialsManagementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DisableOrganizationsRootCredentialsManagementRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationsRootCredentialsManagementResponse> disableOrganizationsRootCredentialsManagement(
            Consumer<DisableOrganizationsRootCredentialsManagementRequest.Builder> disableOrganizationsRootCredentialsManagementRequest) {
        return disableOrganizationsRootCredentialsManagement(DisableOrganizationsRootCredentialsManagementRequest.builder()
                .applyMutation(disableOrganizationsRootCredentialsManagementRequest).build());
    }

    /**
     * <p>
     * Disables root user sessions for privileged tasks across member accounts in your organization. When you disable
     * this feature, the management account and the delegated administrator for IAM can no longer perform privileged
     * tasks on member accounts in your organization.
     * </p>
     *
     * @param disableOrganizationsRootSessionsRequest
     * @return A Java Future containing the result of the DisableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationsRootSessionsResponse> disableOrganizationsRootSessions(
            DisableOrganizationsRootSessionsRequest disableOrganizationsRootSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables root user sessions for privileged tasks across member accounts in your organization. When you disable
     * this feature, the management account and the delegated administrator for IAM can no longer perform privileged
     * tasks on member accounts in your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationsRootSessionsRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationsRootSessionsRequest#builder()}
     * </p>
     *
     * @param disableOrganizationsRootSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.DisableOrganizationsRootSessionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.DisableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DisableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationsRootSessionsResponse> disableOrganizationsRootSessions(
            Consumer<DisableOrganizationsRootSessionsRequest.Builder> disableOrganizationsRootSessionsRequest) {
        return disableOrganizationsRootSessions(DisableOrganizationsRootSessionsRequest.builder()
                .applyMutation(disableOrganizationsRootSessionsRequest).build());
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     *
     * @param enableMfaDeviceRequest
     * @return A Java Future containing the result of the EnableMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>InvalidAuthenticationCodeException The request was rejected because the authentication code was not
     *         recognized. The error message describes the specific error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableMfaDeviceResponse> enableMFADevice(EnableMfaDeviceRequest enableMfaDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableMfaDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link EnableMfaDeviceRequest#builder()}
     * </p>
     *
     * @param enableMfaDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The request was rejected because it attempted to create a resource that
     *         already exists.</li>
     *         <li>EntityTemporarilyUnmodifiableException The request was rejected because it referenced an entity that
     *         is temporarily unmodifiable, such as a user name that was deleted and then recreated. The error indicates
     *         that the request is likely to succeed if you try again after waiting several minutes. The error message
     *         describes the entity.</li>
     *         <li>InvalidAuthenticationCodeException The request was rejected because the authentication code was not
     *         recognized. The error message describes the specific error.</li>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConcurrentModificationException The request was rejected because multiple requests to change this
     *         object were submitted simultaneously. Wait a few minutes and submit your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableMfaDeviceResponse> enableMFADevice(
            Consumer<EnableMfaDeviceRequest.Builder> enableMfaDeviceRequest) {
        return enableMFADevice(EnableMfaDeviceRequest.builder().applyMutation(enableMfaDeviceRequest).build());
    }

    /**
     * <p>
     * Enables the management of privileged root user credentials across member accounts in your organization. When you
     * enable root credentials management for <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >centralized root access</a>, the management account and the delegated administrator for IAM can manage root user
     * credentials for member accounts in your organization.
     * </p>
     * <p>
     * Before you enable centralized root access, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-iam.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param enableOrganizationsRootCredentialsManagementRequest
     * @return A Java Future containing the result of the EnableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationsRootCredentialsManagementResponse> enableOrganizationsRootCredentialsManagement(
            EnableOrganizationsRootCredentialsManagementRequest enableOrganizationsRootCredentialsManagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the management of privileged root user credentials across member accounts in your organization. When you
     * enable root credentials management for <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >centralized root access</a>, the management account and the delegated administrator for IAM can manage root user
     * credentials for member accounts in your organization.
     * </p>
     * <p>
     * Before you enable centralized root access, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-iam.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableOrganizationsRootCredentialsManagementRequest.Builder} avoiding the need to create one manually via
     * {@link EnableOrganizationsRootCredentialsManagementRequest#builder()}
     * </p>
     *
     * @param enableOrganizationsRootCredentialsManagementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.EnableOrganizationsRootCredentialsManagementRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the EnableOrganizationsRootCredentialsManagement operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootCredentialsManagement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootCredentialsManagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationsRootCredentialsManagementResponse> enableOrganizationsRootCredentialsManagement(
            Consumer<EnableOrganizationsRootCredentialsManagementRequest.Builder> enableOrganizationsRootCredentialsManagementRequest) {
        return enableOrganizationsRootCredentialsManagement(EnableOrganizationsRootCredentialsManagementRequest.builder()
                .applyMutation(enableOrganizationsRootCredentialsManagementRequest).build());
    }

    /**
     * <p>
     * Allows the management account or delegated administrator to perform privileged tasks on member accounts in your
     * organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a> in the <i>Identity and Access Management User Guide</i>.
     * </p>
     * <p>
     * Before you enable this feature, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-ra.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param enableOrganizationsRootSessionsRequest
     * @return A Java Future containing the result of the EnableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationsRootSessionsResponse> enableOrganizationsRootSessions(
            EnableOrganizationsRootSessionsRequest enableOrganizationsRootSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the management account or delegated administrator to perform privileged tasks on member accounts in your
     * organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a> in the <i>Identity and Access Management User Guide</i>.
     * </p>
     * <p>
     * Before you enable this feature, you must have an account configured with the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must manage your Amazon Web Services accounts in <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">Organizations</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable trusted access for Identity and Access Management in Organizations. For details, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/services-that-can-integrate-ra.html">IAM and
     * Organizations</a> in the <i>Organizations User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationsRootSessionsRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationsRootSessionsRequest#builder()}
     * </p>
     *
     * @param enableOrganizationsRootSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.EnableOrganizationsRootSessionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the EnableOrganizationsRootSessions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>CallerIsNotManagementAccountException The request was rejected because the account making the request
     *         is not the management account for the organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.EnableOrganizationsRootSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableOrganizationsRootSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationsRootSessionsResponse> enableOrganizationsRootSessions(
            Consumer<EnableOrganizationsRootSessionsRequest.Builder> enableOrganizationsRootSessionsRequest) {
        return enableOrganizationsRootSessions(EnableOrganizationsRootSessionsRequest.builder()
                .applyMutation(enableOrganizationsRootSessionsRequest).build());
    }

    /**
     * <p>
     * Generates a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateCredentialReportRequest
     * @return A Java Future containing the result of the GenerateCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GenerateCredentialReportResponse> generateCredentialReport(
            GenerateCredentialReportRequest generateCredentialReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateCredentialReportRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateCredentialReportRequest#builder()}
     * </p>
     *
     * @param generateCredentialReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GenerateCredentialReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GenerateCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GenerateCredentialReportResponse> generateCredentialReport(
            Consumer<GenerateCredentialReportRequest.Builder> generateCredentialReportRequest) {
        return generateCredentialReport(GenerateCredentialReportRequest.builder().applyMutation(generateCredentialReportRequest)
                .build());
    }

    /**
     * <p>
     * Generates a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the GenerateCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request was rejected because it attempted to create resources beyond the
     *         current Amazon Web Services account limits. The error message describes the limit exceeded.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GenerateCredentialReportResponse> generateCredentialReport() {
        return generateCredentialReport(GenerateCredentialReportRequest.builder().build());
    }

    /**
     * <p>
     * Generates a report for service last accessed data for Organizations. You can generate a report for any entities
     * (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your Organizations management account credentials. You can
     * use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs
     * must be enabled for your organization root. You must have the required IAM and Organizations permissions. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This includes all
     * attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
     * of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not
     * mean that an account has been compromised, because the request might have been denied. Refer to your CloudTrail
     * logs as the authoritative source for information about all API calls and whether they were successful or denied
     * access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html">GetOrganizationsAccessReport</a> </code>
     * operation to check the status of the report generation. To check the status of this request, use the
     * <code>JobId</code> parameter in the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html">GetOrganizationsAccessReport</a> </code>
     * operation and test the <code>JobStatus</code> response parameter. When the job is complete, you can retrieve the
     * report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional Organizations policy ID. The type of entity that you specify determines the data returned in the report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the management account, because the management account is not limited by
     * SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the management account, because the management
     * account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. For each service, the report includes
     * data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the management account, because the management account
     * is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the management account, because the management account is
     * not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list
     * of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. If you specify a policy ID in the CLI
     * or API, the policy is ignored. For each service, the report includes data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope
     * by viewing user activity</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     * @return A Java Future containing the result of the GenerateOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReportGenerationLimitExceededException The request failed because the maximum number of concurrent
     *         requests for this account are already running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateOrganizationsAccessReportResponse> generateOrganizationsAccessReport(
            GenerateOrganizationsAccessReportRequest generateOrganizationsAccessReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a report for service last accessed data for Organizations. You can generate a report for any entities
     * (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your Organizations management account credentials. You can
     * use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs
     * must be enabled for your organization root. You must have the required IAM and Organizations permissions. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This includes all
     * attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
     * of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not
     * mean that an account has been compromised, because the request might have been denied. Refer to your CloudTrail
     * logs as the authoritative source for information about all API calls and whether they were successful or denied
     * access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html">GetOrganizationsAccessReport</a> </code>
     * operation to check the status of the report generation. To check the status of this request, use the
     * <code>JobId</code> parameter in the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html">GetOrganizationsAccessReport</a> </code>
     * operation and test the <code>JobStatus</code> response parameter. When the job is complete, you can retrieve the
     * report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional Organizations policy ID. The type of entity that you specify determines the data returned in the report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the management account, because the management account is not limited by
     * SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the management account, because the management
     * account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. For each service, the report includes
     * data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the management account, because the management account
     * is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will
     * return a list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the management account, because the management account is
     * not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list
     * of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>management account</b> – When you specify the management account, the resulting report lists all Amazon Web
     * Services services, because the management account is not limited by SCPs. If you specify a policy ID in the CLI
     * or API, the policy is ignored. For each service, the report includes data for only the management account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope
     * by viewing user activity</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateOrganizationsAccessReportRequest.Builder}
     * avoiding the need to create one manually via {@link GenerateOrganizationsAccessReportRequest#builder()}
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GenerateOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReportGenerationLimitExceededException The request failed because the maximum number of concurrent
     *         requests for this account are already running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateOrganizationsAccessReportResponse> generateOrganizationsAccessReport(
            Consumer<GenerateOrganizationsAccessReportRequest.Builder> generateOrganizationsAccessReportRequest) {
        return generateOrganizationsAccessReport(GenerateOrganizationsAccessReportRequest.builder()
                .applyMutation(generateOrganizationsAccessReportRequest).build());
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM
     * reports activity for at least the last 400 days, or less if your Region began supporting this feature within the
     * last year. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a>. For more information about services and actions for which action last
     * accessed information is displayed, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-action-last-accessed.html">IAM
     * action last accessed information services and actions</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not just the
     * successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the
     * Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the
     * service last accessed data does not mean that your account has been compromised, because the request might have
     * been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and
     * whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetails.html">
     * GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every Amazon
     * Web Services service that the resource could access using permissions policies. For each service, the response
     * includes information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetailsWithEntities.html">
     * GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific Amazon Web Services service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPoliciesGrantingServiceAccess.html"
     * >ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     * @return A Java Future containing the result of the GenerateServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateServiceLastAccessedDetailsResponse> generateServiceLastAccessedDetails(
            GenerateServiceLastAccessedDetailsRequest generateServiceLastAccessedDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM
     * reports activity for at least the last 400 days, or less if your Region began supporting this feature within the
     * last year. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a>. For more information about services and actions for which action last
     * accessed information is displayed, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-action-last-accessed.html">IAM
     * action last accessed information services and actions</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not just the
     * successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the
     * Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the
     * service last accessed data does not mean that your account has been compromised, because the request might have
     * been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and
     * whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetails.html">
     * GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every Amazon
     * Web Services service that the resource could access using permissions policies. For each service, the response
     * includes information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetailsWithEntities.html">
     * GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific Amazon Web Services service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPoliciesGrantingServiceAccess.html"
     * >ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateServiceLastAccessedDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GenerateServiceLastAccessedDetailsRequest#builder()}
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GenerateServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GenerateServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateServiceLastAccessedDetailsResponse> generateServiceLastAccessedDetails(
            Consumer<GenerateServiceLastAccessedDetailsRequest.Builder> generateServiceLastAccessedDetailsRequest) {
        return generateServiceLastAccessedDetails(GenerateServiceLastAccessedDetailsRequest.builder()
                .applyMutation(generateServiceLastAccessedDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the Amazon Web Services service and Region that were specified in the last request
     * made with that key.
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     * @return A Java Future containing the result of the GetAccessKeyLastUsed operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccessKeyLastUsed
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccessKeyLastUsedResponse> getAccessKeyLastUsed(
            GetAccessKeyLastUsedRequest getAccessKeyLastUsedRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the Amazon Web Services service and Region that were specified in the last request
     * made with that key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessKeyLastUsedRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccessKeyLastUsedRequest#builder()}
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccessKeyLastUsed operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccessKeyLastUsed
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccessKeyLastUsedResponse> getAccessKeyLastUsed(
            Consumer<GetAccessKeyLastUsedRequest.Builder> getAccessKeyLastUsedRequest) {
        return getAccessKeyLastUsed(GetAccessKeyLastUsedRequest.builder().applyMutation(getAccessKeyLastUsedRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account,
     * including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM
     * permissions (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return A Java Future containing the result of the GetAccountAuthorizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountAuthorizationDetailsResponse> getAccountAuthorizationDetails(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account,
     * including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM
     * permissions (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAuthorizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAccountAuthorizationDetailsRequest#builder()}
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAccountAuthorizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountAuthorizationDetailsResponse> getAccountAuthorizationDetails(
            Consumer<GetAccountAuthorizationDetailsRequest.Builder> getAccountAuthorizationDetailsRequest) {
        return getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.builder()
                .applyMutation(getAccountAuthorizationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account,
     * including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM
     * permissions (users, groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountAuthorizationDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountAuthorizationDetailsResponse> getAccountAuthorizationDetails() {
        return getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsPublisher getAccountAuthorizationDetailsPaginator() {
        return getAccountAuthorizationDetailsPaginator(GetAccountAuthorizationDetailsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsPublisher getAccountAuthorizationDetailsPaginator(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) {
        return new GetAccountAuthorizationDetailsPublisher(this, getAccountAuthorizationDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsPublisher publisher = client.getAccountAuthorizationDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAuthorizationDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAccountAuthorizationDetailsRequest#builder()}
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountAuthorizationDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAuthorizationDetailsPublisher getAccountAuthorizationDetailsPaginator(
            Consumer<GetAccountAuthorizationDetailsRequest.Builder> getAccountAuthorizationDetailsRequest) {
        return getAccountAuthorizationDetailsPaginator(GetAccountAuthorizationDetailsRequest.builder()
                .applyMutation(getAccountAuthorizationDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and
     * mandatory rotation periods for the IAM user passwords in your account. For more information about using a
     * password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * password policy</a>.
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     * @return A Java Future containing the result of the GetAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountPasswordPolicyResponse> getAccountPasswordPolicy(
            GetAccountPasswordPolicyRequest getAccountPasswordPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and
     * mandatory rotation periods for the IAM user passwords in your account. For more information about using a
     * password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * password policy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPasswordPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccountPasswordPolicyRequest#builder()}
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountPasswordPolicyResponse> getAccountPasswordPolicy(
            Consumer<GetAccountPasswordPolicyRequest.Builder> getAccountPasswordPolicyRequest) {
        return getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.builder().applyMutation(getAccountPasswordPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and
     * mandatory rotation periods for the IAM user passwords in your account. For more information about using a
     * password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * password policy</a>.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountPasswordPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountPasswordPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountPasswordPolicyResponse> getAccountPasswordPolicy() {
        return getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param getAccountSummaryRequest
     * @return A Java Future containing the result of the GetAccountSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSummaryResponse> getAccountSummary(GetAccountSummaryRequest getAccountSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountSummaryRequest#builder()}
     * </p>
     *
     * @param getAccountSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetAccountSummaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccountSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSummaryResponse> getAccountSummary(
            Consumer<GetAccountSummaryRequest.Builder> getAccountSummaryRequest) {
        return getAccountSummary(GetAccountSummaryRequest.builder().applyMutation(getAccountSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
     * </p>
     * <p>
     * For information about IAM quotas, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetAccountSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSummaryResponse> getAccountSummary() {
        return getAccountSummary(GetAccountSummaryRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html">
     * GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value specified in an IAM
     * policy. Use <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply
     * when you call <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulateCustomPolicy.html">SimulateCustomPolicy
     * </a>. Note that all parameters are shown in unencoded form here for clarity but must be URL encoded to be
     * included as a part of a real HTML request.
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     * @return A Java Future containing the result of the GetContextKeysForCustomPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContextKeysForCustomPolicyResponse> getContextKeysForCustomPolicy(
            GetContextKeysForCustomPolicyRequest getContextKeysForCustomPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html">
     * GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value specified in an IAM
     * policy. Use <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply
     * when you call <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulateCustomPolicy.html">SimulateCustomPolicy
     * </a>. Note that all parameters are shown in unencoded form here for clarity but must be URL encoded to be
     * included as a part of a real HTML request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContextKeysForCustomPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetContextKeysForCustomPolicyRequest#builder()}
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContextKeysForCustomPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForCustomPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContextKeysForCustomPolicyResponse> getContextKeysForCustomPolicy(
            Consumer<GetContextKeysForCustomPolicyRequest.Builder> getContextKeysForCustomPolicyRequest) {
        return getContextKeysForCustomPolicy(GetContextKeysForCustomPolicyRequest.builder()
                .applyMutation(getContextKeysForCustomPolicyRequest).build());
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html"
     * >GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html"
     * >GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html">
     * GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call <a
     * href
     * ="https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html">SimulatePrincipalPolicy
     * </a>.
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     * @return A Java Future containing the result of the GetContextKeysForPrincipalPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForPrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContextKeysForPrincipalPolicyResponse> getContextKeysForPrincipalPolicy(
            GetContextKeysForPrincipalPolicyRequest getContextKeysForPrincipalPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html"
     * >GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This operation discloses information about the permissions granted to other users. If you do not
     * want users to see other user's permissions, then consider allowing them to use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html"
     * >GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the
     * context of an API query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html">
     * GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call <a
     * href
     * ="https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html">SimulatePrincipalPolicy
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContextKeysForPrincipalPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetContextKeysForPrincipalPolicyRequest#builder()}
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetContextKeysForPrincipalPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetContextKeysForPrincipalPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContextKeysForPrincipalPolicyResponse> getContextKeysForPrincipalPolicy(
            Consumer<GetContextKeysForPrincipalPolicyRequest.Builder> getContextKeysForPrincipalPolicyRequest) {
        return getContextKeysForPrincipalPolicy(GetContextKeysForPrincipalPolicyRequest.builder()
                .applyMutation(getContextKeysForPrincipalPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getCredentialReportRequest
     * @return A Java Future containing the result of the GetCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CredentialReportNotPresentException The request was rejected because the credential report does not
     *         exist. To generate a credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>.</li>
     *         <li>CredentialReportExpiredException The request was rejected because the most recent credential report
     *         has expired. To generate a new credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>. For more information about credential report expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.</li>
     *         <li>CredentialReportNotReadyException The request was rejected because the credential report is still
     *         being generated.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCredentialReportResponse> getCredentialReport(
            GetCredentialReportRequest getCredentialReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetCredentialReportRequest#builder()}
     * </p>
     *
     * @param getCredentialReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetCredentialReportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CredentialReportNotPresentException The request was rejected because the credential report does not
     *         exist. To generate a credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>.</li>
     *         <li>CredentialReportExpiredException The request was rejected because the most recent credential report
     *         has expired. To generate a new credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>. For more information about credential report expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.</li>
     *         <li>CredentialReportNotReadyException The request was rejected because the credential report is still
     *         being generated.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCredentialReportResponse> getCredentialReport(
            Consumer<GetCredentialReportRequest.Builder> getCredentialReportRequest) {
        return getCredentialReport(GetCredentialReportRequest.builder().applyMutation(getCredentialReportRequest).build());
    }

    /**
     * <p>
     * Retrieves a credential report for the Amazon Web Services account. For more information about the credential
     * report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     * reports</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the GetCredentialReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CredentialReportNotPresentException The request was rejected because the credential report does not
     *         exist. To generate a credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>.</li>
     *         <li>CredentialReportExpiredException The request was rejected because the most recent credential report
     *         has expired. To generate a new credential report, use <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html"
     *         >GenerateCredentialReport</a>. For more information about credential report expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential
     *         reports</a> in the <i>IAM User Guide</i>.</li>
     *         <li>CredentialReportNotReadyException The request was rejected because the credential report is still
     *         being generated.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetCredentialReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCredentialReportResponse> getCredentialReport() {
        return getCredentialReport(GetCredentialReportRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupPublisher publisher = client.getGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupPublisher publisher = client.getGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.GetGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.GetGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation.</b>
     * </p>
     *
     * @param getGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupPublisher getGroupPaginator(GetGroupRequest getGroupRequest) {
        return new GetGroupPublisher(this, getGroupRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupPublisher publisher = client.getGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupPublisher publisher = client.getGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.GetGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.GetGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetGroupRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupPublisher getGroupPaginator(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroupPaginator(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to determine the
     * policy's default version, then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getGroupPolicyRequest
     * @return A Java Future containing the result of the GetGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupPolicyResponse> getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to determine the
     * policy's default version, then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupPolicyResponse> getGroupPolicy(Consumer<GetGroupPolicyRequest.Builder> getGroupPolicyRequest) {
        return getGroupPolicy(GetGroupPolicyRequest.builder().applyMutation(getGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return A Java Future containing the result of the GetInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceProfileResponse> getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceProfileRequest#builder()}
     * </p>
     *
     * @param getInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInstanceProfileResponse> getInstanceProfile(
            Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest) {
        return getInstanceProfile(GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the
     * user to access the Amazon Web Services Management Console. If the user does not exist or does not have a
     * password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     * <p>
     * If you create an IAM user with access to the console, the <code>CreateDate</code> reflects the date you created
     * the initial password for the user.
     * </p>
     * <p>
     * If you create an IAM user with programmatic access, and then later add a password for the user to access the
     * Amazon Web Services Management Console, the <code>CreateDate</code> reflects the initial password creation date.
     * A user with programmatic access does not have a login profile unless you create a password for the user to access
     * the Amazon Web Services Management Console.
     * </p>
     *
     * @param getLoginProfileRequest
     * @return A Java Future containing the result of the GetLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoginProfileResponse> getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the
     * user to access the Amazon Web Services Management Console. If the user does not exist or does not have a
     * password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     * <p>
     * If you create an IAM user with access to the console, the <code>CreateDate</code> reflects the date you created
     * the initial password for the user.
     * </p>
     * <p>
     * If you create an IAM user with programmatic access, and then later add a password for the user to access the
     * Amazon Web Services Management Console, the <code>CreateDate</code> reflects the initial password creation date.
     * A user with programmatic access does not have a login profile unless you create a password for the user to access
     * the Amazon Web Services Management Console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoginProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoginProfileRequest#builder()}
     * </p>
     *
     * @param getLoginProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetLoginProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLoginProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetLoginProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLoginProfileResponse> getLoginProfile(
            Consumer<GetLoginProfileRequest.Builder> getLoginProfileRequest) {
        return getLoginProfile(GetLoginProfileRequest.builder().applyMutation(getLoginProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an MFA device for a specified user.
     * </p>
     *
     * @param getMfaDeviceRequest
     * @return A Java Future containing the result of the GetMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMfaDeviceResponse> getMFADevice(GetMfaDeviceRequest getMfaDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an MFA device for a specified user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMfaDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetMfaDeviceRequest#builder()}
     * </p>
     *
     * @param getMfaDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMFADevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetMFADevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMfaDeviceResponse> getMFADevice(Consumer<GetMfaDeviceRequest.Builder> getMfaDeviceRequest) {
        return getMFADevice(GetMfaDeviceRequest.builder().applyMutation(getMfaDeviceRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     * @return A Java Future containing the result of the GetOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOpenIdConnectProviderResponse> getOpenIDConnectProvider(
            GetOpenIdConnectProviderRequest getOpenIdConnectProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenIdConnectProviderRequest.Builder} avoiding
     * the need to create one manually via {@link GetOpenIdConnectProviderRequest#builder()}
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOpenIDConnectProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOpenIDConnectProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOpenIdConnectProviderResponse> getOpenIDConnectProvider(
            Consumer<GetOpenIdConnectProviderRequest.Builder> getOpenIdConnectProviderRequest) {
        return getOpenIDConnectProvider(GetOpenIdConnectProviderRequest.builder().applyMutation(getOpenIdConnectProviderRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for Organizations that was previously generated using the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html">GenerateOrganizationsAccessReport</a> </code>
     * operation. This operation retrieves the status of your report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html"
     * >GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be
     * enabled for your organization root. You must have permissions to perform this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining
     * permissions using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root user, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     * @return A Java Future containing the result of the GetOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationsAccessReportResponse> getOrganizationsAccessReport(
            GetOrganizationsAccessReportRequest getOrganizationsAccessReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for Organizations that was previously generated using the
     * <code> <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html">GenerateOrganizationsAccessReport</a> </code>
     * operation. This operation retrieves the status of your report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html"
     * >GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be
     * enabled for your organization root. You must have permissions to perform this operation. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining
     * permissions using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root user, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationsAccessReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationsAccessReportRequest#builder()}
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOrganizationsAccessReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetOrganizationsAccessReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationsAccessReportResponse> getOrganizationsAccessReport(
            Consumer<GetOrganizationsAccessReportRequest.Builder> getOrganizationsAccessReportRequest) {
        return getOrganizationsAccessReport(GetOrganizationsAccessReportRequest.builder()
                .applyMutation(getOrganizationsAccessReportRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html"
     * >ListEntitiesForPolicy</a>. This operation returns metadata about the policy. To retrieve the actual policy
     * document for a specific version of the policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded with an IAM user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html">GetUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html">GetGroupPolicy</a>, or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html">GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html"
     * >ListEntitiesForPolicy</a>. This operation returns metadata about the policy. To retrieve the actual policy
     * document for a specific version of the policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded with an IAM user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html">GetUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html">GetGroupPolicy</a>, or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html">GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded in a user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html">GetUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html">GetGroupPolicy</a>, or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html">GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyVersionRequest
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html">ListPolicyVersions</a>.
     * </p>
     * <p>
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that
     * is embedded in a user, group, or role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html">GetUserPolicy</a>, <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html">GetGroupPolicy</a>, or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html">GetRolePolicy</a>.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
     * policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPolicyVersionRequest#builder()}
     * </p>
     *
     * @param getPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetPolicyVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(
            Consumer<GetPolicyVersionRequest.Builder> getPolicyVersionRequest) {
        return getPolicyVersion(GetPolicyVersionRequest.builder().applyMutation(getPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     *
     * @param getRoleRequest
     * @return A Java Future containing the result of the GetRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoleResponse> getRole(GetRoleRequest getRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRoleRequest#builder()}
     * </p>
     *
     * @param getRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoleResponse> getRole(Consumer<GetRoleRequest.Builder> getRoleRequest) {
        return getRole(GetRoleRequest.builder().applyMutation(getRoleRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to
     * determine the policy's default version, then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getRolePolicyRequest
     * @return A Java Future containing the result of the GetRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRolePolicyResponse> getRolePolicy(GetRolePolicyRequest getRolePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to
     * determine the policy's default version, then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRolePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetRolePolicyRequest#builder()}
     * </p>
     *
     * @param getRolePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetRolePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRolePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetRolePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRolePolicyResponse> getRolePolicy(Consumer<GetRolePolicyRequest.Builder> getRolePolicyRequest) {
        return getRolePolicy(GetRolePolicyRequest.builder().applyMutation(getRolePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param getSamlProviderRequest
     * @return A Java Future containing the result of the GetSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSamlProviderResponse> getSAMLProvider(GetSamlProviderRequest getSamlProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamlProviderRequest.Builder} avoiding the need
     * to create one manually via {@link GetSamlProviderRequest#builder()}
     * </p>
     *
     * @param getSamlProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetSamlProviderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSAMLProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSAMLProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSamlProviderResponse> getSAMLProvider(
            Consumer<GetSamlProviderRequest.Builder> getSamlProviderRequest) {
        return getSAMLProvider(GetSamlProviderRequest.builder().applyMutation(getSamlProviderRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     *
     * @param getSshPublicKeyRequest
     * @return A Java Future containing the result of the GetSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnrecognizedPublicKeyEncodingException The request was rejected because the public key encoding
     *         format is unsupported or unrecognized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSshPublicKeyResponse> getSSHPublicKey(GetSshPublicKeyRequest getSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an
     * CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see
     * <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up
     * CodeCommit for SSH connections</a> in the <i>CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSshPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param getSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>UnrecognizedPublicKeyEncodingException The request was rejected because the public key encoding
     *         format is unsupported or unrecognized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSshPublicKeyResponse> getSSHPublicKey(
            Consumer<GetSshPublicKeyRequest.Builder> getSshPublicKeyRequest) {
        return getSSHPublicKey(GetSshPublicKeyRequest.builder().applyMutation(getSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of Amazon Web Services services that
     * can use the server certificates that you manage with IAM.
     * </p>
     *
     * @param getServerCertificateRequest
     * @return A Java Future containing the result of the GetServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServerCertificateResponse> getServerCertificate(
            GetServerCertificateRequest getServerCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
     * certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of Amazon Web Services services that
     * can use the server certificates that you manage with IAM.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServerCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetServerCertificateRequest#builder()}
     * </p>
     *
     * @param getServerCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetServerCertificateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServerCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServerCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServerCertificateResponse> getServerCertificate(
            Consumer<GetServerCertificateRequest.Builder> getServerCertificateRequest) {
        return getServerCertificate(GetServerCertificateRequest.builder().applyMutation(getServerCertificateRequest).build());
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that
     * the resource (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     * @return A Java Future containing the result of the GetServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLastAccessedDetailsResponse> getServiceLastAccessedDetails(
            GetServiceLastAccessedDetailsRequest getServiceLastAccessedDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that
     * the resource (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, Organizations policies,
     * IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions
     * using service last accessed data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceLastAccessedDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceLastAccessedDetailsRequest#builder()}
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceLastAccessedDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLastAccessedDetailsResponse> getServiceLastAccessedDetails(
            Consumer<GetServiceLastAccessedDetailsRequest.Builder> getServiceLastAccessedDetailsRequest) {
        return getServiceLastAccessedDetails(GetServiceLastAccessedDetailsRequest.builder()
                .applyMutation(getServiceLastAccessedDetailsRequest).build());
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     * @return A Java Future containing the result of the GetServiceLastAccessedDetailsWithEntities operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLastAccessedDetailsWithEntitiesResponse> getServiceLastAccessedDetailsWithEntities(
            GetServiceLastAccessedDetailsWithEntitiesRequest getServiceLastAccessedDetailsWithEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceLastAccessedDetailsWithEntitiesRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceLastAccessedDetailsWithEntitiesRequest#builder()}
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetServiceLastAccessedDetailsWithEntities operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLastAccessedDetailsWithEntitiesResponse> getServiceLastAccessedDetailsWithEntities(
            Consumer<GetServiceLastAccessedDetailsWithEntitiesRequest.Builder> getServiceLastAccessedDetailsWithEntitiesRequest) {
        return getServiceLastAccessedDetailsWithEntities(GetServiceLastAccessedDetailsWithEntitiesRequest.builder()
                .applyMutation(getServiceLastAccessedDetailsWithEntitiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> to submit a service-linked role for deletion, you can use the
     * <code>DeletionTaskId</code> parameter in <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of
     * the deletion. If the deletion fails, this operation returns the reason that it failed, if that information is
     * returned by the service.
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     * @return A Java Future containing the result of the GetServiceLinkedRoleDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLinkedRoleDeletionStatusResponse> getServiceLinkedRoleDeletionStatus(
            GetServiceLinkedRoleDeletionStatusRequest getServiceLinkedRoleDeletionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html"
     * >DeleteServiceLinkedRole</a> to submit a service-linked role for deletion, you can use the
     * <code>DeletionTaskId</code> parameter in <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of
     * the deletion. If the deletion fails, this operation returns the reason that it failed, if that information is
     * returned by the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceLinkedRoleDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceLinkedRoleDeletionStatusRequest#builder()}
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetServiceLinkedRoleDeletionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceLinkedRoleDeletionStatusResponse> getServiceLinkedRoleDeletionStatus(
            Consumer<GetServiceLinkedRoleDeletionStatusRequest.Builder> getServiceLinkedRoleDeletionStatusRequest) {
        return getServiceLinkedRoleDeletionStatus(GetServiceLinkedRoleDeletionStatusRequest.builder()
                .applyMutation(getServiceLinkedRoleDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID used to sign the request to this operation.
     * </p>
     *
     * @param getUserRequest
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID used to sign the request to this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(Consumer<GetUserRequest.Builder> getUserRequest) {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
     * access key ID used to sign the request to this operation.
     * </p>
     *
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser() {
        return getUser(GetUserRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to
     * determine the policy's default version. Then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getUserPolicyRequest
     * @return A Java Future containing the result of the GetUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserPolicyResponse> getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this operation are URL-encoded compliant with <a
     * href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding method to convert the policy
     * back to plain JSON text. For example, if you use Java, you can use the <code>decode</code> method of the
     * <code>java.net.URLDecoder</code> utility class in the Java SDK. Other languages and SDKs provide similar
     * functionality, and some SDKs do this decoding automatically.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a> to
     * determine the policy's default version. Then use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html">GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetUserPolicyRequest#builder()}
     * </p>
     *
     * @param getUserPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.GetUserPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.GetUserPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserPolicyResponse> getUserPolicy(Consumer<GetUserPolicyRequest.Builder> getUserPolicyRequest) {
        return getUserPolicy(GetUserPolicyRequest.builder().applyMutation(getUserPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. If a temporary access key is used, then <code>UserName</code> is
     * required. If a long-term key is assigned to the user, then <code>UserName</code> is not required.
     * </p>
     * <p>
     * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account
     * has no associated users, the root user returns it's own access key IDs by running this command.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation.
     * </p>
     * </note>
     *
     * @param listAccessKeysRequest
     * @return A Java Future containing the result of the ListAccessKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccessKeysResponse> listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. If a temporary access key is used, then <code>UserName</code> is
     * required. If a long-term key is assigned to the user, then <code>UserName</code> is not required.
     * </p>
     * <p>
     * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account
     * has no associated users, the root user returns it's own access key IDs by running this command.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessKeysRequest#builder()}
     * </p>
     *
     * @param listAccessKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAccessKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccessKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccessKeysResponse> listAccessKeys(Consumer<ListAccessKeysRequest.Builder> listAccessKeysRequest) {
        return listAccessKeys(ListAccessKeysRequest.builder().applyMutation(listAccessKeysRequest).build());
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the Amazon Web
     * Services access key ID used to sign the request. If a temporary access key is used, then <code>UserName</code> is
     * required. If a long-term key is assigned to the user, then <code>UserName</code> is not required.
     * </p>
     * <p>
     * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account
     * has no associated users, the root user returns it's own access key IDs by running this command.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key
     * and user creation.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListAccessKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccessKeysResponse> listAccessKeys() {
        return listAccessKeys(ListAccessKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccessKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysPublisher listAccessKeysPaginator() {
        return listAccessKeysPaginator(ListAccessKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccessKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     *
     * @param listAccessKeysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysPublisher listAccessKeysPaginator(ListAccessKeysRequest listAccessKeysRequest) {
        return new ListAccessKeysPublisher(this, listAccessKeysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysPublisher publisher = client.listAccessKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccessKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessKeysRequest#builder()}
     * </p>
     *
     * @param listAccessKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAccessKeysRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccessKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessKeysPublisher listAccessKeysPaginator(Consumer<ListAccessKeysRequest.Builder> listAccessKeysRequest) {
        return listAccessKeysPaginator(ListAccessKeysRequest.builder().applyMutation(listAccessKeysRequest).build());
    }

    /**
     * <p>
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For
     * information about using an Amazon Web Services account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/console_account-alias.html#CreateAccountAlias">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return A Java Future containing the result of the ListAccountAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountAliasesResponse> listAccountAliases(ListAccountAliasesRequest listAccountAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For
     * information about using an Amazon Web Services account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/console_account-alias.html#CreateAccountAlias">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAliasesRequest#builder()}
     * </p>
     *
     * @param listAccountAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccountAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountAliasesResponse> listAccountAliases(
            Consumer<ListAccountAliasesRequest.Builder> listAccountAliasesRequest) {
        return listAccountAliases(ListAccountAliasesRequest.builder().applyMutation(listAccountAliasesRequest).build());
    }

    /**
     * <p>
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For
     * information about using an Amazon Web Services account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/console_account-alias.html#CreateAccountAlias">Creating,
     * deleting, and listing an Amazon Web Services account alias</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the ListAccountAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccountAliasesResponse> listAccountAliases() {
        return listAccountAliases(ListAccountAliasesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesPublisher listAccountAliasesPaginator() {
        return listAccountAliasesPaginator(ListAccountAliasesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesPublisher listAccountAliasesPaginator(ListAccountAliasesRequest listAccountAliasesRequest) {
        return new ListAccountAliasesPublisher(this, listAccountAliasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesPublisher publisher = client.listAccountAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAliasesRequest#builder()}
     * </p>
     *
     * @param listAccountAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAccountAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccountAliasesPublisher listAccountAliasesPaginator(
            Consumer<ListAccountAliasesRequest.Builder> listAccountAliasesRequest) {
        return listAccountAliasesPaginator(ListAccountAliasesRequest.builder().applyMutation(listAccountAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupPolicies.html">ListGroupPolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedGroupPoliciesResponse> listAttachedGroupPolicies(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupPolicies.html">ListGroupPolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedGroupPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachedGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedGroupPoliciesResponse> listAttachedGroupPolicies(
            Consumer<ListAttachedGroupPoliciesRequest.Builder> listAttachedGroupPoliciesRequest) {
        return listAttachedGroupPolicies(ListAttachedGroupPoliciesRequest.builder()
                .applyMutation(listAttachedGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesPublisher publisher = client.listAttachedGroupPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesPublisher publisher = client.listAttachedGroupPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesPublisher listAttachedGroupPoliciesPaginator(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) {
        return new ListAttachedGroupPoliciesPublisher(this, listAttachedGroupPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesPublisher publisher = client.listAttachedGroupPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesPublisher publisher = client.listAttachedGroupPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedGroupPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedGroupPoliciesPublisher listAttachedGroupPoliciesPaginator(
            Consumer<ListAttachedGroupPoliciesRequest.Builder> listAttachedGroupPoliciesRequest) {
        return listAttachedGroupPoliciesPaginator(ListAttachedGroupPoliciesRequest.builder()
                .applyMutation(listAttachedGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRolePolicies.html">ListRolePolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return A Java Future containing the result of the ListAttachedRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedRolePoliciesResponse> listAttachedRolePolicies(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRolePolicies.html">ListRolePolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedRolePoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachedRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedRolePoliciesResponse> listAttachedRolePolicies(
            Consumer<ListAttachedRolePoliciesRequest.Builder> listAttachedRolePoliciesRequest) {
        return listAttachedRolePolicies(ListAttachedRolePoliciesRequest.builder().applyMutation(listAttachedRolePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesPublisher publisher = client.listAttachedRolePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesPublisher publisher = client.listAttachedRolePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesPublisher listAttachedRolePoliciesPaginator(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) {
        return new ListAttachedRolePoliciesPublisher(this, listAttachedRolePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesPublisher publisher = client.listAttachedRolePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesPublisher publisher = client.listAttachedRolePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedRolePoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedRolePoliciesPublisher listAttachedRolePoliciesPaginator(
            Consumer<ListAttachedRolePoliciesRequest.Builder> listAttachedRolePoliciesRequest) {
        return listAttachedRolePoliciesPaginator(ListAttachedRolePoliciesRequest.builder()
                .applyMutation(listAttachedRolePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserPolicies.html">ListUserPolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedUserPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedUserPoliciesResponse> listAttachedUserPolicies(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserPolicies.html">ListUserPolicies</a>. For
     * information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedUserPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachedUserPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAttachedUserPoliciesResponse> listAttachedUserPolicies(
            Consumer<ListAttachedUserPoliciesRequest.Builder> listAttachedUserPoliciesRequest) {
        return listAttachedUserPolicies(ListAttachedUserPoliciesRequest.builder().applyMutation(listAttachedUserPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesPublisher publisher = client.listAttachedUserPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesPublisher publisher = client.listAttachedUserPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesPublisher listAttachedUserPoliciesPaginator(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) {
        return new ListAttachedUserPoliciesPublisher(this, listAttachedUserPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesPublisher publisher = client.listAttachedUserPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesPublisher publisher = client.listAttachedUserPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedUserPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAttachedUserPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListAttachedUserPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAttachedUserPoliciesPublisher listAttachedUserPoliciesPaginator(
            Consumer<ListAttachedUserPoliciesRequest.Builder> listAttachedUserPoliciesRequest) {
        return listAttachedUserPoliciesPaginator(ListAttachedUserPoliciesRequest.builder()
                .applyMutation(listAttachedUserPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return A Java Future containing the result of the ListEntitiesForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntitiesForPolicyResponse> listEntitiesForPolicy(
            ListEntitiesForPolicyRequest listEntitiesForPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesForPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntitiesForPolicyRequest#builder()}
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntitiesForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEntitiesForPolicyResponse> listEntitiesForPolicy(
            Consumer<ListEntitiesForPolicyRequest.Builder> listEntitiesForPolicyRequest) {
        return listEntitiesForPolicy(ListEntitiesForPolicyRequest.builder().applyMutation(listEntitiesForPolicyRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyPublisher publisher = client.listEntitiesForPolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyPublisher publisher = client.listEntitiesForPolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyPublisher listEntitiesForPolicyPaginator(
            ListEntitiesForPolicyRequest listEntitiesForPolicyRequest) {
        return new ListEntitiesForPolicyPublisher(this, listEntitiesForPolicyRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyPublisher publisher = client.listEntitiesForPolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyPublisher publisher = client.listEntitiesForPolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesForPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ListEntitiesForPolicyRequest#builder()}
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListEntitiesForPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEntitiesForPolicyPublisher listEntitiesForPolicyPaginator(
            Consumer<ListEntitiesForPolicyRequest.Builder> listEntitiesForPolicyRequest) {
        return listEntitiesForPolicyPaginator(ListEntitiesForPolicyRequest.builder().applyMutation(listEntitiesForPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedGroupPolicies.html">
     * ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return A Java Future containing the result of the ListGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupPoliciesResponse> listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedGroupPolicies.html">
     * ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroupPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupPoliciesResponse> listGroupPolicies(
            Consumer<ListGroupPoliciesRequest.Builder> listGroupPoliciesRequest) {
        return listGroupPolicies(ListGroupPoliciesRequest.builder().applyMutation(listGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesPublisher publisher = client.listGroupPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesPublisher publisher = client.listGroupPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesPublisher listGroupPoliciesPaginator(ListGroupPoliciesRequest listGroupPoliciesRequest) {
        return new ListGroupPoliciesPublisher(this, listGroupPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesPublisher publisher = client.listGroupPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesPublisher publisher = client.listGroupPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupPoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupPoliciesRequest#builder()}
     * </p>
     *
     * @param listGroupPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupPoliciesPublisher listGroupPoliciesPaginator(
            Consumer<ListGroupPoliciesRequest.Builder> listGroupPoliciesRequest) {
        return listGroupPoliciesPaginator(ListGroupPoliciesRequest.builder().applyMutation(listGroupPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups() {
        return listGroups(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return A Java Future containing the result of the ListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsForUserResponse> listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForUserRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param listGroupsForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsForUserResponse> listGroupsForUser(
            Consumer<ListGroupsForUserRequest.Builder> listGroupsForUserRequest) {
        return listGroupsForUser(ListGroupsForUserRequest.builder().applyMutation(listGroupsForUserRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserPublisher publisher = client.listGroupsForUserPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserPublisher publisher = client.listGroupsForUserPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserPublisher listGroupsForUserPaginator(ListGroupsForUserRequest listGroupsForUserRequest) {
        return new ListGroupsForUserPublisher(this, listGroupsForUserRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserPublisher publisher = client.listGroupsForUserPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserPublisher publisher = client.listGroupsForUserPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForUserRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param listGroupsForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsForUserPublisher listGroupsForUserPaginator(
            Consumer<ListGroupsForUserRequest.Builder> listGroupsForUserRequest) {
        return listGroupsForUserPaginator(ListGroupsForUserRequest.builder().applyMutation(listGroupsForUserRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator() {
        return listGroupsPaginator(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     * @return A Java Future containing the result of the ListInstanceProfileTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfileTagsResponse> listInstanceProfileTags(
            ListInstanceProfileTagsRequest listInstanceProfileTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by
     * tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfileTagsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceProfileTagsRequest#builder()}
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInstanceProfileTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfileTagsResponse> listInstanceProfileTags(
            Consumer<ListInstanceProfileTagsRequest.Builder> listInstanceProfileTagsRequest) {
        return listInstanceProfileTags(ListInstanceProfileTagsRequest.builder().applyMutation(listInstanceProfileTagsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfileTags(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfileTagsPublisher publisher = client.listInstanceProfileTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfileTagsPublisher publisher = client.listInstanceProfileTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfileTags(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstanceProfileTagsPublisher listInstanceProfileTagsPaginator(
            ListInstanceProfileTagsRequest listInstanceProfileTagsRequest) {
        return new ListInstanceProfileTagsPublisher(this, listInstanceProfileTagsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfileTags(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfileTagsPublisher publisher = client.listInstanceProfileTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfileTagsPublisher publisher = client.listInstanceProfileTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfileTags(software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfileTagsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceProfileTagsRequest#builder()}
     * </p>
     *
     * @param listInstanceProfileTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfileTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfileTags" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstanceProfileTagsPublisher listInstanceProfileTagsPaginator(
            Consumer<ListInstanceProfileTagsRequest.Builder> listInstanceProfileTagsRequest) {
        return listInstanceProfileTagsPaginator(ListInstanceProfileTagsRequest.builder()
                .applyMutation(listInstanceProfileTagsRequest).build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html">GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles(
            ListInstanceProfilesRequest listInstanceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html">GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an instance profile, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html">GetInstanceProfile</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles() {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return A Java Future containing the result of the ListInstanceProfilesForRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesForRoleResponse> listInstanceProfilesForRole(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html">Using
     * instance profiles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesForRoleRequest.Builder}
     * avoiding the need to create one manually via {@link ListInstanceProfilesForRoleRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInstanceProfilesForRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesForRoleResponse> listInstanceProfilesForRole(
            Consumer<ListInstanceProfilesForRoleRequest.Builder> listInstanceProfilesForRoleRequest) {
        return listInstanceProfilesForRole(ListInstanceProfilesForRoleRequest.builder()
                .applyMutation(listInstanceProfilesForRoleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRolePublisher publisher = client.listInstanceProfilesForRolePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRolePublisher publisher = client.listInstanceProfilesForRolePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRolePublisher listInstanceProfilesForRolePaginator(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) {
        return new ListInstanceProfilesForRolePublisher(this, listInstanceProfilesForRoleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRolePublisher publisher = client.listInstanceProfilesForRolePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRolePublisher publisher = client.listInstanceProfilesForRolePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesForRoleRequest.Builder}
     * avoiding the need to create one manually via {@link ListInstanceProfilesForRoleRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfilesForRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesForRolePublisher listInstanceProfilesForRolePaginator(
            Consumer<ListInstanceProfilesForRoleRequest.Builder> listInstanceProfilesForRoleRequest) {
        return listInstanceProfilesForRolePaginator(ListInstanceProfilesForRoleRequest.builder()
                .applyMutation(listInstanceProfilesForRoleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesPublisher listInstanceProfilesPaginator() {
        return listInstanceProfilesPaginator(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesPublisher listInstanceProfilesPaginator(ListInstanceProfilesRequest listInstanceProfilesRequest) {
        return new ListInstanceProfilesPublisher(this, listInstanceProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesPublisher publisher = client.listInstanceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstanceProfilesPublisher listInstanceProfilesPaginator(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) {
        return listInstanceProfilesPaginator(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     * @return A Java Future containing the result of the ListMFADeviceTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMfaDeviceTagsResponse> listMFADeviceTags(ListMfaDeviceTagsRequest listMfaDeviceTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The
     * returned list of tags is sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDeviceTagsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMfaDeviceTagsRequest#builder()}
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMFADeviceTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMfaDeviceTagsResponse> listMFADeviceTags(
            Consumer<ListMfaDeviceTagsRequest.Builder> listMfaDeviceTagsRequest) {
        return listMFADeviceTags(ListMfaDeviceTagsRequest.builder().applyMutation(listMfaDeviceTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMFADeviceTags(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADeviceTagsPublisher publisher = client.listMFADeviceTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADeviceTagsPublisher publisher = client.listMFADeviceTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADeviceTags(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest)} operation.</b>
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADeviceTagsPublisher listMFADeviceTagsPaginator(ListMfaDeviceTagsRequest listMfaDeviceTagsRequest) {
        return new ListMFADeviceTagsPublisher(this, listMfaDeviceTagsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMFADeviceTags(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADeviceTagsPublisher publisher = client.listMFADeviceTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADeviceTagsPublisher publisher = client.listMFADeviceTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADeviceTags(software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDeviceTagsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMfaDeviceTagsRequest#builder()}
     * </p>
     *
     * @param listMfaDeviceTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADeviceTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADeviceTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADeviceTagsPublisher listMFADeviceTagsPaginator(
            Consumer<ListMfaDeviceTagsRequest.Builder> listMfaDeviceTagsRequest) {
        return listMFADeviceTagsPaginator(ListMfaDeviceTagsRequest.builder().applyMutation(listMfaDeviceTagsRequest).build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the Amazon Web Services access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return A Java Future containing the result of the ListMFADevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMfaDevicesResponse> listMFADevices(ListMfaDevicesRequest listMfaDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the Amazon Web Services access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listMfaDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMFADevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMfaDevicesResponse> listMFADevices(Consumer<ListMfaDevicesRequest.Builder> listMfaDevicesRequest) {
        return listMFADevices(ListMfaDevicesRequest.builder().applyMutation(listMfaDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the Amazon Web Services access key ID signing the request for this operation.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return A Java Future containing the result of the ListMFADevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMfaDevicesResponse> listMFADevices() {
        return listMFADevices(ListMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesPublisher listMFADevicesPaginator() {
        return listMFADevicesPaginator(ListMfaDevicesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesPublisher listMFADevicesPaginator(ListMfaDevicesRequest listMfaDevicesRequest) {
        return new ListMFADevicesPublisher(this, listMfaDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesPublisher publisher = client.listMFADevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMfaDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMfaDevicesRequest#builder()}
     * </p>
     *
     * @param listMfaDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListMFADevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMFADevicesPublisher listMFADevicesPaginator(Consumer<ListMfaDevicesRequest.Builder> listMfaDevicesRequest) {
        return listMFADevicesPaginator(ListMfaDevicesRequest.builder().applyMutation(listMfaDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The
     * returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     * @return A Java Future containing the result of the ListOpenIDConnectProviderTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenIdConnectProviderTagsResponse> listOpenIDConnectProviderTags(
            ListOpenIdConnectProviderTagsRequest listOpenIdConnectProviderTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The
     * returned list of tags is sorted by tag key. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
     * federation</a>.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenIdConnectProviderTagsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOpenIdConnectProviderTagsRequest#builder()}
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOpenIDConnectProviderTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenIdConnectProviderTagsResponse> listOpenIDConnectProviderTags(
            Consumer<ListOpenIdConnectProviderTagsRequest.Builder> listOpenIdConnectProviderTagsRequest) {
        return listOpenIDConnectProviderTags(ListOpenIdConnectProviderTagsRequest.builder()
                .applyMutation(listOpenIdConnectProviderTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOpenIDConnectProviderTags(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListOpenIDConnectProviderTagsPublisher publisher = client.listOpenIDConnectProviderTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListOpenIDConnectProviderTagsPublisher publisher = client.listOpenIDConnectProviderTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpenIDConnectProviderTags(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIDConnectProviderTagsPublisher listOpenIDConnectProviderTagsPaginator(
            ListOpenIdConnectProviderTagsRequest listOpenIdConnectProviderTagsRequest) {
        return new ListOpenIDConnectProviderTagsPublisher(this, listOpenIdConnectProviderTagsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOpenIDConnectProviderTags(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListOpenIDConnectProviderTagsPublisher publisher = client.listOpenIDConnectProviderTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListOpenIDConnectProviderTagsPublisher publisher = client.listOpenIDConnectProviderTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpenIDConnectProviderTags(software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenIdConnectProviderTagsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOpenIdConnectProviderTagsRequest#builder()}
     * </p>
     *
     * @param listOpenIdConnectProviderTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListOpenIdConnectProviderTagsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviderTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviderTags"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenIDConnectProviderTagsPublisher listOpenIDConnectProviderTagsPaginator(
            Consumer<ListOpenIdConnectProviderTagsRequest.Builder> listOpenIdConnectProviderTagsRequest) {
        return listOpenIDConnectProviderTagsPaginator(ListOpenIdConnectProviderTagsRequest.builder()
                .applyMutation(listOpenIdConnectProviderTagsRequest).build());
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web
     * Services account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html"
     * >GetOpenIDConnectProvider</a>.
     * </p>
     * </note>
     *
     * @param listOpenIdConnectProvidersRequest
     * @return A Java Future containing the result of the ListOpenIDConnectProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenIdConnectProvidersResponse> listOpenIDConnectProviders(
            ListOpenIdConnectProvidersRequest listOpenIdConnectProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web
     * Services account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html"
     * >GetOpenIDConnectProvider</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenIdConnectProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListOpenIdConnectProvidersRequest#builder()}
     * </p>
     *
     * @param listOpenIdConnectProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOpenIDConnectProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenIdConnectProvidersResponse> listOpenIDConnectProviders(
            Consumer<ListOpenIdConnectProvidersRequest.Builder> listOpenIdConnectProvidersRequest) {
        return listOpenIDConnectProviders(ListOpenIdConnectProvidersRequest.builder()
                .applyMutation(listOpenIdConnectProvidersRequest).build());
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web
     * Services account.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for an OIDC provider, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html"
     * >GetOpenIDConnectProvider</a>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListOpenIDConnectProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOpenIDConnectProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOpenIdConnectProvidersResponse> listOpenIDConnectProviders() {
        return listOpenIDConnectProviders(ListOpenIdConnectProvidersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the centralized root access features enabled for your organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a>.
     * </p>
     *
     * @param listOrganizationsFeaturesRequest
     * @return A Java Future containing the result of the ListOrganizationsFeatures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOrganizationsFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOrganizationsFeatures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrganizationsFeaturesResponse> listOrganizationsFeatures(
            ListOrganizationsFeaturesRequest listOrganizationsFeaturesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the centralized root access features enabled for your organization. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     * >Centrally manage root access for member accounts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationsFeaturesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationsFeaturesRequest#builder()}
     * </p>
     *
     * @param listOrganizationsFeaturesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListOrganizationsFeaturesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOrganizationsFeatures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceAccessNotEnabledException The request was rejected because trusted access is not enabled for
     *         IAM in Organizations. For details, see IAM and Organizations in the <i>Organizations User Guide</i>.</li>
     *         <li>AccountNotManagementOrDelegatedAdministratorException The request was rejected because the account
     *         making the request is not the management account or delegated administrator account for <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management"
     *         >centralized root access</a>.</li>
     *         <li>OrganizationNotFoundException The request was rejected because no organization is associated with
     *         your account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The request was rejected because your organization does not
     *         have All features enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set"
     *         >Available feature sets</a> in the <i>Organizations User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListOrganizationsFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOrganizationsFeatures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrganizationsFeaturesResponse> listOrganizationsFeatures(
            Consumer<ListOrganizationsFeaturesRequest.Builder> listOrganizationsFeaturesRequest) {
        return listOrganizationsFeatures(ListOrganizationsFeaturesRequest.builder()
                .applyMutation(listOrganizationsFeaturesRequest).build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your Amazon Web Services account, including your own
     * customer-defined managed policies and all Amazon Web Services managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your Amazon Web Services account, set <code>Scope</code> to <code>Local</code>. To list only Amazon
     * Web Services managed policies, set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a>.
     * </p>
     * </note>
     *
     * @param listPoliciesRequest
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your Amazon Web Services account, including your own
     * customer-defined managed policies and all Amazon Web Services managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your Amazon Web Services account, set <code>Scope</code> to <code>Local</code>. To list only Amazon
     * Web Services managed policies, set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your Amazon Web Services account, including your own
     * customer-defined managed policies and all Amazon Web Services managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your Amazon Web Services account, set <code>Scope</code> to <code>Local</code>. To list only Amazon
     * Web Services managed policies, set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this
     * operation does not return tags, even though they are an attribute of the returned object. To view all of the
     * information for a customer manged policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html">GetPolicy</a>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies() {
        return listPolicies(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation
     * of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUser.html">GetUser</a> or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html">GetRole</a> operations.
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     * @return A Java Future containing the result of the ListPoliciesGrantingServiceAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPoliciesGrantingServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPoliciesGrantingServiceAccessResponse> listPoliciesGrantingServiceAccess(
            ListPoliciesGrantingServiceAccessRequest listPoliciesGrantingServiceAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions
     * boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation
     * of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies
     * and inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUser.html">GetUser</a> or <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html">GetRole</a> operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesGrantingServiceAccessRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoliciesGrantingServiceAccessRequest#builder()}
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPoliciesGrantingServiceAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPoliciesGrantingServiceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPoliciesGrantingServiceAccessResponse> listPoliciesGrantingServiceAccess(
            Consumer<ListPoliciesGrantingServiceAccessRequest.Builder> listPoliciesGrantingServiceAccessRequest) {
        return listPoliciesGrantingServiceAccess(ListPoliciesGrantingServiceAccessRequest.builder()
                .applyMutation(listPoliciesGrantingServiceAccessRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator() {
        return listPoliciesPaginator(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) {
        return new ListPoliciesPublisher(this, listPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesPublisher publisher = client.listPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesPublisher listPoliciesPaginator(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPoliciesPaginator(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     *
     * @param listPolicyTagsRequest
     * @return A Java Future containing the result of the ListPolicyTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyTagsResponse> listPolicyTags(ListPolicyTagsRequest listPolicyTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is
     * sorted by tag key. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPolicyTagsRequest#builder()}
     * </p>
     *
     * @param listPolicyTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicyTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyTagsResponse> listPolicyTags(Consumer<ListPolicyTagsRequest.Builder> listPolicyTagsRequest) {
        return listPolicyTags(ListPolicyTagsRequest.builder().applyMutation(listPolicyTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicyTags(software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyTagsPublisher publisher = client.listPolicyTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyTagsPublisher publisher = client.listPolicyTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyTags(software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyTagsPublisher listPolicyTagsPaginator(ListPolicyTagsRequest listPolicyTagsRequest) {
        return new ListPolicyTagsPublisher(this, listPolicyTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPolicyTags(software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyTagsPublisher publisher = client.listPolicyTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyTagsPublisher publisher = client.listPolicyTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyTags(software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPolicyTagsRequest#builder()}
     * </p>
     *
     * @param listPolicyTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyTagsPublisher listPolicyTagsPaginator(Consumer<ListPolicyTagsRequest.Builder> listPolicyTagsRequest) {
        return listPolicyTagsPaginator(ListPolicyTagsRequest.builder().applyMutation(listPolicyTagsRequest).build());
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) {
        return listPolicyVersions(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsPublisher listPolicyVersionsPaginator(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        return new ListPolicyVersionsPublisher(this, listPolicyVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsPublisher publisher = client.listPolicyVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>InvalidInputException The request was rejected because an invalid or out-of-range value was supplied
     *         for an input parameter.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListPolicyVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPolicyVersionsPublisher listPolicyVersionsPaginator(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) {
        return listPolicyVersionsPaginator(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedRolePolicies.html">
     * ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return A Java Future containing the result of the ListRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRolePoliciesResponse> listRolePolicies(ListRolePoliciesRequest listRolePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedRolePolicies.html">
     * ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and
     * inline policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listRolePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRolePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRolePoliciesResponse> listRolePolicies(
            Consumer<ListRolePoliciesRequest.Builder> listRolePoliciesRequest) {
        return listRolePolicies(ListRolePoliciesRequest.builder().applyMutation(listRolePoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesPublisher publisher = client.listRolePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesPublisher publisher = client.listRolePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesPublisher listRolePoliciesPaginator(ListRolePoliciesRequest listRolePoliciesRequest) {
        return new ListRolePoliciesPublisher(this, listRolePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesPublisher publisher = client.listRolePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesPublisher publisher = client.listRolePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRolePoliciesRequest#builder()}
     * </p>
     *
     * @param listRolePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRolePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolePoliciesPublisher listRolePoliciesPaginator(Consumer<ListRolePoliciesRequest.Builder> listRolePoliciesRequest) {
        return listRolePoliciesPaginator(ListRolePoliciesRequest.builder().applyMutation(listRolePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM resources</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listRoleTagsRequest
     * @return A Java Future containing the result of the ListRoleTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoleTagsResponse> listRoleTags(ListRoleTagsRequest listRoleTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM resources</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoleTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoleTagsRequest#builder()}
     * </p>
     *
     * @param listRoleTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListRoleTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRoleTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRoleTagsResponse> listRoleTags(Consumer<ListRoleTagsRequest.Builder> listRoleTagsRequest) {
        return listRoleTags(ListRoleTagsRequest.builder().applyMutation(listRoleTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRoleTags(software.amazon.awssdk.services.iam.model.ListRoleTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRoleTagsPublisher publisher = client.listRoleTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRoleTagsPublisher publisher = client.listRoleTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRoleTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRoleTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoleTags(software.amazon.awssdk.services.iam.model.ListRoleTagsRequest)} operation.</b>
     * </p>
     *
     * @param listRoleTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoleTagsPublisher listRoleTagsPaginator(ListRoleTagsRequest listRoleTagsRequest) {
        return new ListRoleTagsPublisher(this, listRoleTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRoleTags(software.amazon.awssdk.services.iam.model.ListRoleTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRoleTagsPublisher publisher = client.listRoleTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRoleTagsPublisher publisher = client.listRoleTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRoleTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRoleTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoleTags(software.amazon.awssdk.services.iam.model.ListRoleTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoleTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRoleTagsRequest#builder()}
     * </p>
     *
     * @param listRoleTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListRoleTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchEntityException The request was rejected because it referenced a resource entity that does not
     *         exist. The error message describes the resource.</li>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoleTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRoleTagsPublisher listRoleTagsPaginator(Consumer<ListRoleTagsRequest.Builder> listRoleTagsRequest) {
        return listRoleTagsPaginator(ListRoleTagsRequest.builder().applyMutation(listRoleTagsRequest).build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does
     * not return the following attributes, even though they are an attribute of the returned object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PermissionsBoundary
     * </p>
     * </li>
     * <li>
     * <p>
     * RoleLastUsed
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * </ul>
     * <p>
     * To view all of the information for a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html">GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listRolesRequest
     * @return A Java Future containing the result of the ListRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRolesResponse> listRoles(ListRolesRequest listRolesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does
     * not return the following attributes, even though they are an attribute of the returned object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PermissionsBoundary
     * </p>
     * </li>
     * <li>
     * <p>
     * RoleLastUsed
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * </ul>
     * <p>
     * To view all of the information for a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html">GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRolesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRolesRequest#builder()}
     * </p>
     *
     * @param listRolesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iam.model.ListRolesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRolesResponse> listRoles(Consumer<ListRolesRequest.Builder> listRolesRequest) {
        return listRoles(ListRolesRequest.builder().applyMutation(listRolesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does
     * not return the following attributes, even though they are an attribute of the returned object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PermissionsBoundary
     * </p>
     * </li>
     * <li>
     * <p>
     * RoleLastUsed
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * </ul>
     * <p>
     * To view all of the information for a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html">GetRole</a>.
     * </p>
     * </note>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @return A Java Future containing the result of the ListRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRolesResponse> listRoles() {
        return listRoles(ListRolesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesPublisher publisher = client.listRolesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesPublisher publisher = client.listRolesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRolesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRolesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesPublisher listRolesPaginator() {
        return listRolesPaginator(ListRolesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesPublisher publisher = client.listRolesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesPublisher publisher = client.listRolesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iam.model.ListRolesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iam.model.ListRolesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     *
     * @param listRolesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceFailureException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IamAsyncClient.ListRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRolesPublisher listRolesPaginator(ListRolesRequest listRolesRequest) {
        return new ListRolesPublisher(this, listRolesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestr