/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDelegationRequestRequest extends IamRequest implements
        ToCopyableBuilder<CreateDelegationRequestRequest.Builder, CreateDelegationRequestRequest> {
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(CreateDelegationRequestRequest::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDelegationRequestRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DelegationPermission> PERMISSIONS_FIELD = SdkField
            .<DelegationPermission> builder(MarshallingType.SDK_POJO).memberName("Permissions")
            .getter(getter(CreateDelegationRequestRequest::permissions)).setter(setter(Builder::permissions))
            .constructor(DelegationPermission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()).build();

    private static final SdkField<String> REQUEST_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestMessage").getter(getter(CreateDelegationRequestRequest::requestMessage))
            .setter(setter(Builder::requestMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestMessage").build()).build();

    private static final SdkField<String> REQUESTOR_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestorWorkflowId").getter(getter(CreateDelegationRequestRequest::requestorWorkflowId))
            .setter(setter(Builder::requestorWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestorWorkflowId").build())
            .build();

    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectUrl").getter(getter(CreateDelegationRequestRequest::redirectUrl))
            .setter(setter(Builder::redirectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()).build();

    private static final SdkField<String> NOTIFICATION_CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationChannel").getter(getter(CreateDelegationRequestRequest::notificationChannel))
            .setter(setter(Builder::notificationChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final SdkField<Integer> SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionDuration").getter(getter(CreateDelegationRequestRequest::sessionDuration))
            .setter(setter(Builder::sessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDuration").build()).build();

    private static final SdkField<Boolean> ONLY_SEND_BY_OWNER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OnlySendByOwner").getter(getter(CreateDelegationRequestRequest::onlySendByOwner))
            .setter(setter(Builder::onlySendByOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlySendByOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_ID_FIELD,
            DESCRIPTION_FIELD, PERMISSIONS_FIELD, REQUEST_MESSAGE_FIELD, REQUESTOR_WORKFLOW_ID_FIELD, REDIRECT_URL_FIELD,
            NOTIFICATION_CHANNEL_FIELD, SESSION_DURATION_FIELD, ONLY_SEND_BY_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ownerAccountId;

    private final String description;

    private final DelegationPermission permissions;

    private final String requestMessage;

    private final String requestorWorkflowId;

    private final String redirectUrl;

    private final String notificationChannel;

    private final Integer sessionDuration;

    private final Boolean onlySendByOwner;

    private CreateDelegationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.ownerAccountId = builder.ownerAccountId;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.requestMessage = builder.requestMessage;
        this.requestorWorkflowId = builder.requestorWorkflowId;
        this.redirectUrl = builder.redirectUrl;
        this.notificationChannel = builder.notificationChannel;
        this.sessionDuration = builder.sessionDuration;
        this.onlySendByOwner = builder.onlySendByOwner;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String description() {
        return description;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final DelegationPermission permissions() {
        return permissions;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String requestMessage() {
        return requestMessage;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String requestorWorkflowId() {
        return requestorWorkflowId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String redirectUrl() {
        return redirectUrl;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String notificationChannel() {
        return notificationChannel;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Integer sessionDuration() {
        return sessionDuration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Boolean onlySendByOwner() {
        return onlySendByOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(requestMessage());
        hashCode = 31 * hashCode + Objects.hashCode(requestorWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(sessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(onlySendByOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDelegationRequestRequest)) {
            return false;
        }
        CreateDelegationRequestRequest other = (CreateDelegationRequestRequest) obj;
        return Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(description(), other.description())
                && Objects.equals(permissions(), other.permissions()) && Objects.equals(requestMessage(), other.requestMessage())
                && Objects.equals(requestorWorkflowId(), other.requestorWorkflowId())
                && Objects.equals(redirectUrl(), other.redirectUrl())
                && Objects.equals(notificationChannel(), other.notificationChannel())
                && Objects.equals(sessionDuration(), other.sessionDuration())
                && Objects.equals(onlySendByOwner(), other.onlySendByOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDelegationRequestRequest").add("OwnerAccountId", ownerAccountId())
                .add("Description", description()).add("Permissions", permissions()).add("RequestMessage", requestMessage())
                .add("RequestorWorkflowId", requestorWorkflowId()).add("RedirectUrl", redirectUrl())
                .add("NotificationChannel", notificationChannel()).add("SessionDuration", sessionDuration())
                .add("OnlySendByOwner", onlySendByOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "RequestMessage":
            return Optional.ofNullable(clazz.cast(requestMessage()));
        case "RequestorWorkflowId":
            return Optional.ofNullable(clazz.cast(requestorWorkflowId()));
        case "RedirectUrl":
            return Optional.ofNullable(clazz.cast(redirectUrl()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        case "SessionDuration":
            return Optional.ofNullable(clazz.cast(sessionDuration()));
        case "OnlySendByOwner":
            return Optional.ofNullable(clazz.cast(onlySendByOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("RequestMessage", REQUEST_MESSAGE_FIELD);
        map.put("RequestorWorkflowId", REQUESTOR_WORKFLOW_ID_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("SessionDuration", SESSION_DURATION_FIELD);
        map.put("OnlySendByOwner", ONLY_SEND_BY_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDelegationRequestRequest, T> g) {
        return obj -> g.apply((CreateDelegationRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDelegationRequestRequest> {
        /**
         * <p/>
         * 
         * @param ownerAccountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p/>
         * 
         * @param description
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p/>
         * 
         * @param permissions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(DelegationPermission permissions);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link DelegationPermission.Builder} avoiding
         * the need to create one manually via {@link DelegationPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DelegationPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #permissions(DelegationPermission)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link DelegationPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(DelegationPermission)
         */
        default Builder permissions(Consumer<DelegationPermission.Builder> permissions) {
            return permissions(DelegationPermission.builder().applyMutation(permissions).build());
        }

        /**
         * <p/>
         * 
         * @param requestMessage
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMessage(String requestMessage);

        /**
         * <p/>
         * 
         * @param requestorWorkflowId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestorWorkflowId(String requestorWorkflowId);

        /**
         * <p/>
         * 
         * @param redirectUrl
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUrl(String redirectUrl);

        /**
         * <p/>
         * 
         * @param notificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(String notificationChannel);

        /**
         * <p/>
         * 
         * @param sessionDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionDuration(Integer sessionDuration);

        /**
         * <p/>
         * 
         * @param onlySendByOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlySendByOwner(Boolean onlySendByOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String ownerAccountId;

        private String description;

        private DelegationPermission permissions;

        private String requestMessage;

        private String requestorWorkflowId;

        private String redirectUrl;

        private String notificationChannel;

        private Integer sessionDuration;

        private Boolean onlySendByOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDelegationRequestRequest model) {
            super(model);
            ownerAccountId(model.ownerAccountId);
            description(model.description);
            permissions(model.permissions);
            requestMessage(model.requestMessage);
            requestorWorkflowId(model.requestorWorkflowId);
            redirectUrl(model.redirectUrl);
            notificationChannel(model.notificationChannel);
            sessionDuration(model.sessionDuration);
            onlySendByOwner(model.onlySendByOwner);
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DelegationPermission.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(DelegationPermission.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(DelegationPermission permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getRequestMessage() {
            return requestMessage;
        }

        public final void setRequestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
        }

        @Override
        public final Builder requestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
            return this;
        }

        public final String getRequestorWorkflowId() {
            return requestorWorkflowId;
        }

        public final void setRequestorWorkflowId(String requestorWorkflowId) {
            this.requestorWorkflowId = requestorWorkflowId;
        }

        @Override
        public final Builder requestorWorkflowId(String requestorWorkflowId) {
            this.requestorWorkflowId = requestorWorkflowId;
            return this;
        }

        public final String getRedirectUrl() {
            return redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final String getNotificationChannel() {
            return notificationChannel;
        }

        public final void setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
        }

        @Override
        public final Builder notificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final Integer getSessionDuration() {
            return sessionDuration;
        }

        public final void setSessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
        }

        @Override
        public final Builder sessionDuration(Integer sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        public final Boolean getOnlySendByOwner() {
            return onlySendByOwner;
        }

        public final void setOnlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
        }

        @Override
        public final Builder onlySendByOwner(Boolean onlySendByOwner) {
            this.onlySendByOwner = onlySendByOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDelegationRequestRequest build() {
            return new CreateDelegationRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
