/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelegationPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<DelegationPermission.Builder, DelegationPermission> {
    private static final SdkField<String> POLICY_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyTemplateArn").getter(getter(DelegationPermission::policyTemplateArn))
            .setter(setter(Builder::policyTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTemplateArn").build()).build();

    private static final SdkField<List<PolicyParameter>> PARAMETERS_FIELD = SdkField
            .<List<PolicyParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(DelegationPermission::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TEMPLATE_ARN_FIELD,
            PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyTemplateArn;

    private final List<PolicyParameter> parameters;

    private DelegationPermission(BuilderImpl builder) {
        this.policyTemplateArn = builder.policyTemplateArn;
        this.parameters = builder.parameters;
    }

    /**
     * Returns the value of the PolicyTemplateArn property for this object.
     * 
     * @return The value of the PolicyTemplateArn property for this object.
     */
    public final String policyTemplateArn() {
        return policyTemplateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return
     */
    public final List<PolicyParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission other = (DelegationPermission) obj;
        return Objects.equals(policyTemplateArn(), other.policyTemplateArn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DelegationPermission").add("PolicyTemplateArn", policyTemplateArn())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyTemplateArn":
            return Optional.ofNullable(clazz.cast(policyTemplateArn()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyTemplateArn", POLICY_TEMPLATE_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DelegationPermission, T> g) {
        return obj -> g.apply((DelegationPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelegationPermission> {
        /**
         * Sets the value of the PolicyTemplateArn property for this object.
         *
         * @param policyTemplateArn
         *        The new value for the PolicyTemplateArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTemplateArn(String policyTemplateArn);

        /**
         * <p/>
         * 
         * @param parameters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<PolicyParameter> parameters);

        /**
         * <p/>
         * 
         * @param parameters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PolicyParameter... parameters);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iam.model.PolicyParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iam.model.PolicyParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iam.model.PolicyParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<PolicyParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iam.model.PolicyParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<PolicyParameter>)
         */
        Builder parameters(Consumer<PolicyParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String policyTemplateArn;

        private List<PolicyParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationPermission model) {
            policyTemplateArn(model.policyTemplateArn);
            parameters(model.parameters);
        }

        public final String getPolicyTemplateArn() {
            return policyTemplateArn;
        }

        public final void setPolicyTemplateArn(String policyTemplateArn) {
            this.policyTemplateArn = policyTemplateArn;
        }

        @Override
        public final Builder policyTemplateArn(String policyTemplateArn) {
            this.policyTemplateArn = policyTemplateArn;
            return this;
        }

        public final List<PolicyParameter.Builder> getParameters() {
            List<PolicyParameter.Builder> result = _policyParameterListTypeCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<PolicyParameter.BuilderImpl> parameters) {
            this.parameters = _policyParameterListTypeCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<PolicyParameter> parameters) {
            this.parameters = _policyParameterListTypeCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(PolicyParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<PolicyParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> PolicyParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DelegationPermission build() {
            return new DelegationPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
