/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDelegationRequestResponse
extends IamResponse
implements ToCopyableBuilder<Builder, CreateDelegationRequestResponse> {
    private static final SdkField<String> CONSOLE_DEEP_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsoleDeepLink").getter(CreateDelegationRequestResponse.getter(CreateDelegationRequestResponse::consoleDeepLink)).setter(CreateDelegationRequestResponse.setter(Builder::consoleDeepLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsoleDeepLink").build()}).build();
    private static final SdkField<String> DELEGATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DelegationRequestId").getter(CreateDelegationRequestResponse.getter(CreateDelegationRequestResponse::delegationRequestId)).setter(CreateDelegationRequestResponse.setter(Builder::delegationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_DEEP_LINK_FIELD, DELEGATION_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDelegationRequestResponse.memberNameToFieldInitializer();
    private final String consoleDeepLink;
    private final String delegationRequestId;

    private CreateDelegationRequestResponse(BuilderImpl builder) {
        super(builder);
        this.consoleDeepLink = builder.consoleDeepLink;
        this.delegationRequestId = builder.delegationRequestId;
    }

    public final String consoleDeepLink() {
        return this.consoleDeepLink;
    }

    public final String delegationRequestId() {
        return this.delegationRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleDeepLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDelegationRequestResponse)) {
            return false;
        }
        CreateDelegationRequestResponse other = (CreateDelegationRequestResponse)((Object)obj);
        return Objects.equals(this.consoleDeepLink(), other.consoleDeepLink()) && Objects.equals(this.delegationRequestId(), other.delegationRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDelegationRequestResponse").add("ConsoleDeepLink", (Object)this.consoleDeepLink()).add("DelegationRequestId", (Object)this.delegationRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleDeepLink": {
                return Optional.ofNullable(clazz.cast(this.consoleDeepLink()));
            }
            case "DelegationRequestId": {
                return Optional.ofNullable(clazz.cast(this.delegationRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConsoleDeepLink", CONSOLE_DEEP_LINK_FIELD);
        map.put("DelegationRequestId", DELEGATION_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDelegationRequestResponse, T> g) {
        return obj -> g.apply((CreateDelegationRequestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String consoleDeepLink;
        private String delegationRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDelegationRequestResponse model) {
            super(model);
            this.consoleDeepLink(model.consoleDeepLink);
            this.delegationRequestId(model.delegationRequestId);
        }

        public final String getConsoleDeepLink() {
            return this.consoleDeepLink;
        }

        public final void setConsoleDeepLink(String consoleDeepLink) {
            this.consoleDeepLink = consoleDeepLink;
        }

        @Override
        public final Builder consoleDeepLink(String consoleDeepLink) {
            this.consoleDeepLink = consoleDeepLink;
            return this;
        }

        public final String getDelegationRequestId() {
            return this.delegationRequestId;
        }

        public final void setDelegationRequestId(String delegationRequestId) {
            this.delegationRequestId = delegationRequestId;
        }

        @Override
        public final Builder delegationRequestId(String delegationRequestId) {
            this.delegationRequestId = delegationRequestId;
            return this;
        }

        @Override
        public CreateDelegationRequestResponse build() {
            return new CreateDelegationRequestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDelegationRequestResponse> {
        public Builder consoleDeepLink(String var1);

        public Builder delegationRequestId(String var1);
    }
}

