/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupResponse
extends IdentitystoreResponse
implements ToCopyableBuilder<Builder, DescribeGroupResponse> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DescribeGroupResponse.getter(DescribeGroupResponse::groupId)).setter(DescribeGroupResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeGroupResponse.getter(DescribeGroupResponse::displayName)).setter(DescribeGroupResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, DISPLAY_NAME_FIELD));
    private final String groupId;
    private final String displayName;

    private DescribeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.displayName = builder.displayName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupResponse)) {
            return false;
        }
        DescribeGroupResponse other = (DescribeGroupResponse)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.displayName(), other.displayName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGroupResponse").add("GroupId", (Object)this.groupId()).add("DisplayName", (Object)this.displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupResponse, T> g) {
        return obj -> g.apply((DescribeGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreResponse.BuilderImpl
    implements Builder {
        private String groupId;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupResponse model) {
            super(model);
            this.groupId(model.groupId);
            this.displayName(model.displayName);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public DescribeGroupResponse build() {
            return new DescribeGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IdentitystoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupResponse> {
        public Builder groupId(String var1);

        public Builder displayName(String var1);
    }
}

