/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group object, which contains a specified group’s metadata and attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements SdkPojo, Serializable, ToCopyableBuilder<Group.Builder, Group> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(Group::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Group::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            DISPLAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String displayName;

    private Group(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The identifier for a group in the identity store.
     * </p>
     * 
     * @return The identifier for a group in the identity store.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Contains the group’s display name value. The length limit is 1,024 characters. This value can consist of letters,
     * accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space
     * in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is specified at the time the
     * group is created and stored as an attribute of the group object in the identity store.
     * </p>
     * 
     * @return Contains the group’s display name value. The length limit is 1,024 characters. This value can consist of
     *         letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and
     *         nonbreaking space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is
     *         specified at the time the group is created and stored as an attribute of the group object in the identity
     *         store.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Group").add("GroupId", groupId()).add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * The identifier for a group in the identity store.
         * </p>
         * 
         * @param groupId
         *        The identifier for a group in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Contains the group’s display name value. The length limit is 1,024 characters. This value can consist of
         * letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and
         * nonbreaking space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This value is
         * specified at the time the group is created and stored as an attribute of the group object in the identity
         * store.
         * </p>
         * 
         * @param displayName
         *        Contains the group’s display name value. The length limit is 1,024 characters. This value can consist
         *        of letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space,
         *        and nonbreaking space in this attribute. The characters <code>&lt;&gt;;:%</code> are excluded. This
         *        value is specified at the time the group is created and stored as an attribute of the group object in
         *        the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            groupId(model.groupId);
            displayName(model.displayName);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
