/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupMembershipsForMemberRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<ListGroupMembershipsForMemberRequest.Builder, ListGroupMembershipsForMemberRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(ListGroupMembershipsForMemberRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.<MemberId> builder(MarshallingType.SDK_POJO)
            .memberName("MemberId").getter(getter(ListGroupMembershipsForMemberRequest::memberId))
            .setter(setter(Builder::memberId)).constructor(MemberId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupMembershipsForMemberRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupMembershipsForMemberRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            MEMBER_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String identityStoreId;

    private final MemberId memberId;

    private final Integer maxResults;

    private final String nextToken;

    private ListGroupMembershipsForMemberRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.memberId = builder.memberId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @return An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *         specific identifier for a user indicates that the user is a member of the group.
     */
    public final MemberId memberId() {
        return memberId;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @return The maximum number of results to be returned per request. This parameter is used in the
     *         <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *         page. The length limit is 50 characters.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @return The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
     *         <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *         It is returned in the API response if the total results are more than the size of one page. This token is
     *         also returned when it is used in the API request to search for the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembershipsForMemberRequest)) {
            return false;
        }
        ListGroupMembershipsForMemberRequest other = (ListGroupMembershipsForMemberRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(memberId(), other.memberId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupMembershipsForMemberRequest").add("IdentityStoreId", identityStoreId())
                .add("MemberId", memberId()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembershipsForMemberRequest, T> g) {
        return obj -> g.apply((ListGroupMembershipsForMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupMembershipsForMemberRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * 
         * @param memberId
         *        An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         *        specific identifier for a user indicates that the user is a member of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(MemberId memberId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberId.Builder} avoiding the need to
         * create one manually via {@link MemberId#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberId.Builder#build()} is called immediately and its result is
         * passed to {@link #memberId(MemberId)}.
         * 
         * @param memberId
         *        a consumer that will call methods on {@link MemberId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberId(MemberId)
         */
        default Builder memberId(Consumer<MemberId.Builder> memberId) {
            return memberId(MemberId.builder().applyMutation(memberId).build());
        }

        /**
         * <p>
         * The maximum number of results to be returned per request. This parameter is used in the
         * <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
         * page. The length limit is 50 characters.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request. This parameter is used in the
         *        <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in
         *        one page. The length limit is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
         * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It
         * is returned in the API response if the total results are more than the size of one page. This token is also
         * returned when it is used in the API request to search for the next page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and
         *        <code>ListGroupMemberships</code> API operations. This value is generated by the identity store
         *        service. It is returned in the API response if the total results are more than the size of one page.
         *        This token is also returned when it is used in the API request to search for the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private MemberId memberId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembershipsForMemberRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            memberId(model.memberId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return memberId != null ? memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupMembershipsForMemberRequest build() {
            return new ListGroupMembershipsForMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
