/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A unique identifier for a user or group that is not the its primary identifier. This value can be an identifier from
 * an external identity provider (IdP) that is associated with the group or a unique attribute. For example, a unique
 * <code>GroupDisplayName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlternateIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<AlternateIdentifier.Builder, AlternateIdentifier> {
    private static final SdkField<ExternalId> EXTERNAL_ID_FIELD = SdkField.<ExternalId> builder(MarshallingType.SDK_POJO)
            .memberName("ExternalId").getter(getter(AlternateIdentifier::externalId)).setter(setter(Builder::externalId))
            .constructor(ExternalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<UniqueAttribute> UNIQUE_ATTRIBUTE_FIELD = SdkField
            .<UniqueAttribute> builder(MarshallingType.SDK_POJO).memberName("UniqueAttribute")
            .getter(getter(AlternateIdentifier::uniqueAttribute)).setter(setter(Builder::uniqueAttribute))
            .constructor(UniqueAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_ID_FIELD,
            UNIQUE_ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExternalId externalId;

    private final UniqueAttribute uniqueAttribute;

    private final Type type;

    private AlternateIdentifier(BuilderImpl builder) {
        this.externalId = builder.externalId;
        this.uniqueAttribute = builder.uniqueAttribute;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier issued to this resource by an external identity provider.
     * </p>
     * 
     * @return The identifier issued to this resource by an external identity provider.
     */
    public final ExternalId externalId() {
        return externalId;
    }

    /**
     * <p>
     * An entity attribute that's unique to a specific entity.
     * </p>
     * 
     * @return An entity attribute that's unique to a specific entity.
     */
    public final UniqueAttribute uniqueAttribute() {
        return uniqueAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlternateIdentifier)) {
            return false;
        }
        AlternateIdentifier other = (AlternateIdentifier) obj;
        return Objects.equals(externalId(), other.externalId()) && Objects.equals(uniqueAttribute(), other.uniqueAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlternateIdentifier").add("ExternalId", externalId()).add("UniqueAttribute", uniqueAttribute())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "UniqueAttribute":
            return Optional.ofNullable(clazz.cast(uniqueAttribute()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #externalId()} initialized to the given value.
     *
     * <p>
     * The identifier issued to this resource by an external identity provider.
     * </p>
     * 
     * @param externalId
     *        The identifier issued to this resource by an external identity provider.
     */
    public static AlternateIdentifier fromExternalId(ExternalId externalId) {
        return builder().externalId(externalId).build();
    }

    /**
     * Create an instance of this class with {@link #externalId()} initialized to the given value.
     *
     * <p>
     * The identifier issued to this resource by an external identity provider.
     * </p>
     * 
     * @param externalId
     *        The identifier issued to this resource by an external identity provider.
     */
    public static AlternateIdentifier fromExternalId(Consumer<ExternalId.Builder> externalId) {
        ExternalId.Builder builder = ExternalId.builder();
        externalId.accept(builder);
        return fromExternalId(builder.build());
    }

    /**
     * Create an instance of this class with {@link #uniqueAttribute()} initialized to the given value.
     *
     * <p>
     * An entity attribute that's unique to a specific entity.
     * </p>
     * 
     * @param uniqueAttribute
     *        An entity attribute that's unique to a specific entity.
     */
    public static AlternateIdentifier fromUniqueAttribute(UniqueAttribute uniqueAttribute) {
        return builder().uniqueAttribute(uniqueAttribute).build();
    }

    /**
     * Create an instance of this class with {@link #uniqueAttribute()} initialized to the given value.
     *
     * <p>
     * An entity attribute that's unique to a specific entity.
     * </p>
     * 
     * @param uniqueAttribute
     *        An entity attribute that's unique to a specific entity.
     */
    public static AlternateIdentifier fromUniqueAttribute(Consumer<UniqueAttribute.Builder> uniqueAttribute) {
        UniqueAttribute.Builder builder = UniqueAttribute.builder();
        uniqueAttribute.accept(builder);
        return fromUniqueAttribute(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlternateIdentifier, T> g) {
        return obj -> g.apply((AlternateIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlternateIdentifier> {
        /**
         * <p>
         * The identifier issued to this resource by an external identity provider.
         * </p>
         * 
         * @param externalId
         *        The identifier issued to this resource by an external identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(ExternalId externalId);

        /**
         * <p>
         * The identifier issued to this resource by an external identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalId.Builder} avoiding the need to
         * create one manually via {@link ExternalId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExternalId.Builder#build()} is called immediately and its result
         * is passed to {@link #externalId(ExternalId)}.
         * 
         * @param externalId
         *        a consumer that will call methods on {@link ExternalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalId(ExternalId)
         */
        default Builder externalId(Consumer<ExternalId.Builder> externalId) {
            return externalId(ExternalId.builder().applyMutation(externalId).build());
        }

        /**
         * <p>
         * An entity attribute that's unique to a specific entity.
         * </p>
         * 
         * @param uniqueAttribute
         *        An entity attribute that's unique to a specific entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueAttribute(UniqueAttribute uniqueAttribute);

        /**
         * <p>
         * An entity attribute that's unique to a specific entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link UniqueAttribute.Builder} avoiding the
         * need to create one manually via {@link UniqueAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link UniqueAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #uniqueAttribute(UniqueAttribute)}.
         * 
         * @param uniqueAttribute
         *        a consumer that will call methods on {@link UniqueAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uniqueAttribute(UniqueAttribute)
         */
        default Builder uniqueAttribute(Consumer<UniqueAttribute.Builder> uniqueAttribute) {
            return uniqueAttribute(UniqueAttribute.builder().applyMutation(uniqueAttribute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExternalId externalId;

        private UniqueAttribute uniqueAttribute;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AlternateIdentifier model) {
            externalId(model.externalId);
            uniqueAttribute(model.uniqueAttribute);
        }

        public final ExternalId.Builder getExternalId() {
            return externalId != null ? externalId.toBuilder() : null;
        }

        public final void setExternalId(ExternalId.BuilderImpl externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId != null ? externalId.build() : null;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
        }

        @Override
        public final Builder externalId(ExternalId externalId) {
            Object oldValue = this.externalId;
            this.externalId = externalId;
            handleUnionValueChange(Type.EXTERNAL_ID, oldValue, this.externalId);
            return this;
        }

        public final UniqueAttribute.Builder getUniqueAttribute() {
            return uniqueAttribute != null ? uniqueAttribute.toBuilder() : null;
        }

        public final void setUniqueAttribute(UniqueAttribute.BuilderImpl uniqueAttribute) {
            Object oldValue = this.uniqueAttribute;
            this.uniqueAttribute = uniqueAttribute != null ? uniqueAttribute.build() : null;
            handleUnionValueChange(Type.UNIQUE_ATTRIBUTE, oldValue, this.uniqueAttribute);
        }

        @Override
        public final Builder uniqueAttribute(UniqueAttribute uniqueAttribute) {
            Object oldValue = this.uniqueAttribute;
            this.uniqueAttribute = uniqueAttribute;
            handleUnionValueChange(Type.UNIQUE_ATTRIBUTE, oldValue, this.uniqueAttribute);
            return this;
        }

        @Override
        public AlternateIdentifier build() {
            return new AlternateIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AlternateIdentifier#type()
     */
    public enum Type {
        EXTERNAL_ID,

        UNIQUE_ATTRIBUTE,

        UNKNOWN_TO_SDK_VERSION
    }
}
