/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClient;
import software.amazon.awssdk.services.identitystore.model.GroupMembership;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse;

public class ListGroupMembershipsForMemberPublisher
implements SdkPublisher<ListGroupMembershipsForMemberResponse> {
    private final IdentitystoreAsyncClient client;
    private final ListGroupMembershipsForMemberRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupMembershipsForMemberPublisher(IdentitystoreAsyncClient client, ListGroupMembershipsForMemberRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupMembershipsForMemberPublisher(IdentitystoreAsyncClient client, ListGroupMembershipsForMemberRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupMembershipsForMemberResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupMembershipsForMemberResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupMembership> groupMemberships() {
        Function<ListGroupMembershipsForMemberResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupMemberships() != null) {
                return response.groupMemberships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupMembershipsForMemberResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupMembershipsForMemberResponseFetcher
    implements AsyncPageFetcher<ListGroupMembershipsForMemberResponse> {
        private ListGroupMembershipsForMemberResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembershipsForMemberResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupMembershipsForMemberResponse> nextPage(ListGroupMembershipsForMemberResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembershipsForMemberPublisher.this.client.listGroupMembershipsForMember(ListGroupMembershipsForMemberPublisher.this.firstRequest);
            }
            return ListGroupMembershipsForMemberPublisher.this.client.listGroupMembershipsForMember((ListGroupMembershipsForMemberRequest)((Object)ListGroupMembershipsForMemberPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

