/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.identitystore.IdentitystoreClient;
import software.amazon.awssdk.services.identitystore.model.GroupMembership;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse;

public class ListGroupMembershipsIterable
implements SdkIterable<ListGroupMembershipsResponse> {
    private final IdentitystoreClient client;
    private final ListGroupMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupMembershipsIterable(IdentitystoreClient client, ListGroupMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupMembershipsResponseFetcher();
    }

    public Iterator<ListGroupMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupMembership> groupMemberships() {
        Function<ListGroupMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupMemberships() != null) {
                return response.groupMemberships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupMembershipsResponseFetcher
    implements SyncPageFetcher<ListGroupMembershipsResponse> {
        private ListGroupMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupMembershipsResponse nextPage(ListGroupMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembershipsIterable.this.client.listGroupMemberships(ListGroupMembershipsIterable.this.firstRequest);
            }
            return ListGroupMembershipsIterable.this.client.listGroupMemberships((ListGroupMembershipsRequest)((Object)ListGroupMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

