/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserResponse extends IdentitystoreResponse implements
        ToCopyableBuilder<DescribeUserResponse.Builder, DescribeUserResponse> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(DescribeUserResponse::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeUserResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_NAME_FIELD, USER_ID_FIELD));

    private final String userName;

    private final String userId;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * Contains the user’s user name value. The length limit is 128 characters. This value can consist of letters,
     * accented characters, symbols, numbers, and punctuation. The characters <code>&lt;&gt;;:%</code> are excluded.
     * This value is specified at the time the user is created and stored as an attribute of the user object in the
     * identity store.
     * </p>
     * 
     * @return Contains the user’s user name value. The length limit is 128 characters. This value can consist of
     *         letters, accented characters, symbols, numbers, and punctuation. The characters <code>&lt;&gt;;:%</code>
     *         are excluded. This value is specified at the time the user is created and stored as an attribute of the
     *         user object in the identity store.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The identifier for a user in the identity store.
     * </p>
     * 
     * @return The identifier for a user in the identity store.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserResponse")
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***").add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserResponse> {
        /**
         * <p>
         * Contains the user’s user name value. The length limit is 128 characters. This value can consist of letters,
         * accented characters, symbols, numbers, and punctuation. The characters <code>&lt;&gt;;:%</code> are excluded.
         * This value is specified at the time the user is created and stored as an attribute of the user object in the
         * identity store.
         * </p>
         * 
         * @param userName
         *        Contains the user’s user name value. The length limit is 128 characters. This value can consist of
         *        letters, accented characters, symbols, numbers, and punctuation. The characters
         *        <code>&lt;&gt;;:%</code> are excluded. This value is specified at the time the user is created and
         *        stored as an attribute of the user object in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The identifier for a user in the identity store.
         * </p>
         * 
         * @param userId
         *        The identifier for a user in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl extends IdentitystoreResponse.BuilderImpl implements Builder {
        private String userName;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            userName(model.userName);
            userId(model.userId);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
