/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupIdRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<GetGroupIdRequest.Builder, GetGroupIdRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(GetGroupIdRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<AlternateIdentifier> ALTERNATE_IDENTIFIER_FIELD = SdkField
            .<AlternateIdentifier> builder(MarshallingType.SDK_POJO).memberName("AlternateIdentifier")
            .getter(getter(GetGroupIdRequest::alternateIdentifier)).setter(setter(Builder::alternateIdentifier))
            .constructor(AlternateIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            ALTERNATE_IDENTIFIER_FIELD));

    private final String identityStoreId;

    private final AlternateIdentifier alternateIdentifier;

    private GetGroupIdRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.alternateIdentifier = builder.alternateIdentifier;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * A unique identifier for a user or group that is not the primary identifier. This value can be an identifier from
     * an external identity provider (IdP) that is associated with the user, the group, or a unique attribute. For
     * example, a unique <code>GroupDisplayName</code>.
     * </p>
     * 
     * @return A unique identifier for a user or group that is not the primary identifier. This value can be an
     *         identifier from an external identity provider (IdP) that is associated with the user, the group, or a
     *         unique attribute. For example, a unique <code>GroupDisplayName</code>.
     */
    public final AlternateIdentifier alternateIdentifier() {
        return alternateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(alternateIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupIdRequest)) {
            return false;
        }
        GetGroupIdRequest other = (GetGroupIdRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId())
                && Objects.equals(alternateIdentifier(), other.alternateIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupIdRequest").add("IdentityStoreId", identityStoreId())
                .add("AlternateIdentifier", alternateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "AlternateIdentifier":
            return Optional.ofNullable(clazz.cast(alternateIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupIdRequest, T> g) {
        return obj -> g.apply((GetGroupIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupIdRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * A unique identifier for a user or group that is not the primary identifier. This value can be an identifier
         * from an external identity provider (IdP) that is associated with the user, the group, or a unique attribute.
         * For example, a unique <code>GroupDisplayName</code>.
         * </p>
         * 
         * @param alternateIdentifier
         *        A unique identifier for a user or group that is not the primary identifier. This value can be an
         *        identifier from an external identity provider (IdP) that is associated with the user, the group, or a
         *        unique attribute. For example, a unique <code>GroupDisplayName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateIdentifier(AlternateIdentifier alternateIdentifier);

        /**
         * <p>
         * A unique identifier for a user or group that is not the primary identifier. This value can be an identifier
         * from an external identity provider (IdP) that is associated with the user, the group, or a unique attribute.
         * For example, a unique <code>GroupDisplayName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlternateIdentifier.Builder} avoiding the
         * need to create one manually via {@link AlternateIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlternateIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #alternateIdentifier(AlternateIdentifier)}.
         * 
         * @param alternateIdentifier
         *        a consumer that will call methods on {@link AlternateIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateIdentifier(AlternateIdentifier)
         */
        default Builder alternateIdentifier(Consumer<AlternateIdentifier.Builder> alternateIdentifier) {
            return alternateIdentifier(AlternateIdentifier.builder().applyMutation(alternateIdentifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private AlternateIdentifier alternateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupIdRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            alternateIdentifier(model.alternateIdentifier);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final AlternateIdentifier.Builder getAlternateIdentifier() {
            return alternateIdentifier != null ? alternateIdentifier.toBuilder() : null;
        }

        public final void setAlternateIdentifier(AlternateIdentifier.BuilderImpl alternateIdentifier) {
            this.alternateIdentifier = alternateIdentifier != null ? alternateIdentifier.build() : null;
        }

        @Override
        public final Builder alternateIdentifier(AlternateIdentifier alternateIdentifier) {
            this.alternateIdentifier = alternateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGroupIdRequest build() {
            return new GetGroupIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
