/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.identitystore.DefaultIdentitystoreAsyncClient;
import software.amazon.awssdk.services.identitystore.DefaultIdentitystoreBaseClientBuilder;
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClient;
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClientBuilder;
import software.amazon.awssdk.services.identitystore.IdentitystoreServiceClientConfiguration;
import software.amazon.awssdk.services.identitystore.endpoints.IdentitystoreEndpointProvider;

@SdkInternalApi
final class DefaultIdentitystoreAsyncClientBuilder
extends DefaultIdentitystoreBaseClientBuilder<IdentitystoreAsyncClientBuilder, IdentitystoreAsyncClient>
implements IdentitystoreAsyncClientBuilder {
    DefaultIdentitystoreAsyncClientBuilder() {
    }

    @Override
    public DefaultIdentitystoreAsyncClientBuilder endpointProvider(IdentitystoreEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IdentitystoreAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIdentitystoreAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IdentitystoreServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIdentitystoreAsyncClient client = new DefaultIdentitystoreAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IdentitystoreServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IdentitystoreServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

