/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(UpdateUserRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UpdateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<List<AttributeOperation>> OPERATIONS_FIELD = SdkField
            .<List<AttributeOperation>> builder(MarshallingType.LIST)
            .memberName("Operations")
            .getter(getter(UpdateUserRequest::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            USER_ID_FIELD, OPERATIONS_FIELD));

    private final String identityStoreId;

    private final String userId;

    private final List<AttributeOperation> operations;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.userId = builder.userId;
        this.operations = builder.operations;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The identifier for a user in the identity store.
     * </p>
     * 
     * @return The identifier for a user in the identity store.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might add,
     * replace, or remove an attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might
     *         add, replace, or remove an attribute.
     */
    public final List<AttributeOperation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(userId(), other.userId())
                && hasOperations() == other.hasOperations() && Objects.equals(operations(), other.operations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("IdentityStoreId", identityStoreId()).add("UserId", userId())
                .add("Operations", hasOperations() ? operations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Operations":
            return Optional.ofNullable(clazz.cast(operations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The identifier for a user in the identity store.
         * </p>
         * 
         * @param userId
         *        The identifier for a user in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might add,
         * replace, or remove an attribute.
         * </p>
         * 
         * @param operations
         *        A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations
         *        might add, replace, or remove an attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<AttributeOperation> operations);

        /**
         * <p>
         * A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might add,
         * replace, or remove an attribute.
         * </p>
         * 
         * @param operations
         *        A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations
         *        might add, replace, or remove an attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(AttributeOperation... operations);

        /**
         * <p>
         * A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might add,
         * replace, or remove an attribute.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.identitystore.model.AttributeOperation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.identitystore.model.AttributeOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.identitystore.model.AttributeOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #operations(List<AttributeOperation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.identitystore.model.AttributeOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(java.util.Collection<AttributeOperation>)
         */
        Builder operations(Consumer<AttributeOperation.Builder>... operations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private String userId;

        private List<AttributeOperation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            userId(model.userId);
            operations(model.operations);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<AttributeOperation.Builder> getOperations() {
            List<AttributeOperation.Builder> result = AttributeOperationsCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<AttributeOperation.BuilderImpl> operations) {
            this.operations = AttributeOperationsCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<AttributeOperation> operations) {
            this.operations = AttributeOperationsCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(AttributeOperation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<AttributeOperation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> AttributeOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
