/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An operation that applies to the requested group. This operation might add, replace, or remove an attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeOperation.Builder, AttributeOperation> {
    private static final SdkField<String> ATTRIBUTE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributePath").getter(getter(AttributeOperation::attributePath)).setter(setter(Builder::attributePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributePath").build()).build();

    private static final SdkField<Document> ATTRIBUTE_VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("AttributeValue").getter(getter(AttributeOperation::attributeValue))
            .setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_PATH_FIELD,
            ATTRIBUTE_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributePath;

    private final Document attributeValue;

    private AttributeOperation(BuilderImpl builder) {
        this.attributePath = builder.attributePath;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.
     * </p>
     * 
     * @return A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.
     */
    public final String attributePath() {
        return attributePath;
    }

    /**
     * <p>
     * The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1, Go V1,
     * and older versions of the CLI.
     * </p>
     * 
     * @return The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1,
     *         Go V1, and older versions of the CLI.
     */
    public final Document attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributePath());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeOperation)) {
            return false;
        }
        AttributeOperation other = (AttributeOperation) obj;
        return Objects.equals(attributePath(), other.attributePath()) && Objects.equals(attributeValue(), other.attributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeOperation").add("AttributePath", attributePath())
                .add("AttributeValue", attributeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributePath":
            return Optional.ofNullable(clazz.cast(attributePath()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributePath", ATTRIBUTE_PATH_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeOperation, T> g) {
        return obj -> g.apply((AttributeOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeOperation> {
        /**
         * <p>
         * A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.
         * </p>
         * 
         * @param attributePath
         *        A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePath(String attributePath);

        /**
         * <p>
         * The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1, Go
         * V1, and older versions of the CLI.
         * </p>
         * 
         * @param attributeValue
         *        The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java
         *        V1, Go V1, and older versions of the CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(Document attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String attributePath;

        private Document attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeOperation model) {
            attributePath(model.attributePath);
            attributeValue(model.attributeValue);
        }

        public final String getAttributePath() {
            return attributePath;
        }

        public final void setAttributePath(String attributePath) {
            this.attributePath = attributePath;
        }

        @Override
        public final Builder attributePath(String attributePath) {
            this.attributePath = attributePath;
            return this;
        }

        public final Document getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(Document attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(Document attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        @Override
        public AttributeOperation build() {
            return new AttributeOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
