/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the identifiers for a group, a group member, and a <code>GroupMembership</code> object in the identity
 * store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupMembership implements SdkPojo, Serializable, ToCopyableBuilder<GroupMembership.Builder, GroupMembership> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(GroupMembership::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MembershipId").getter(getter(GroupMembership::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(GroupMembership::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.<MemberId> builder(MarshallingType.SDK_POJO)
            .memberName("MemberId").getter(getter(GroupMembership::memberId)).setter(setter(Builder::memberId))
            .constructor(MemberId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            MEMBERSHIP_ID_FIELD, GROUP_ID_FIELD, MEMBER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identityStoreId;

    private final String membershipId;

    private final String groupId;

    private final MemberId memberId;

    private GroupMembership(BuilderImpl builder) {
        this.identityStoreId = builder.identityStoreId;
        this.membershipId = builder.membershipId;
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The identifier for a <code>GroupMembership</code> object in an identity store.
     * </p>
     * 
     * @return The identifier for a <code>GroupMembership</code> object in an identity store.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The identifier for a group in the identity store.
     * </p>
     * 
     * @return The identifier for a group in the identity store.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @return An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *         specific identifier for a user indicates that the user is a member of the group.
     */
    public final MemberId memberId() {
        return memberId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupMembership)) {
            return false;
        }
        GroupMembership other = (GroupMembership) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(membershipId(), other.membershipId())
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(memberId(), other.memberId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupMembership").add("IdentityStoreId", identityStoreId()).add("MembershipId", membershipId())
                .add("GroupId", groupId()).add("MemberId", memberId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "MembershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("MembershipId", MEMBERSHIP_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupMembership, T> g) {
        return obj -> g.apply((GroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupMembership> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The identifier for a <code>GroupMembership</code> object in an identity store.
         * </p>
         * 
         * @param membershipId
         *        The identifier for a <code>GroupMembership</code> object in an identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The identifier for a group in the identity store.
         * </p>
         * 
         * @param groupId
         *        The identifier for a group in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * 
         * @param memberId
         *        An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         *        specific identifier for a user indicates that the user is a member of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(MemberId memberId);

        /**
         * <p>
         * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
         * specific identifier for a user indicates that the user is a member of the group.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberId.Builder} avoiding the need to
         * create one manually via {@link MemberId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemberId.Builder#build()} is called immediately and its result is
         * passed to {@link #memberId(MemberId)}.
         * 
         * @param memberId
         *        a consumer that will call methods on {@link MemberId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberId(MemberId)
         */
        default Builder memberId(Consumer<MemberId.Builder> memberId) {
            return memberId(MemberId.builder().applyMutation(memberId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identityStoreId;

        private String membershipId;

        private String groupId;

        private MemberId memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupMembership model) {
            identityStoreId(model.identityStoreId);
            membershipId(model.membershipId);
            groupId(model.groupId);
            memberId(model.memberId);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return memberId != null ? memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        @Override
        public GroupMembership build() {
            return new GroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
