/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsMemberInGroupsRequest extends IdentitystoreRequest implements
        ToCopyableBuilder<IsMemberInGroupsRequest.Builder, IsMemberInGroupsRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(IsMemberInGroupsRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.<MemberId> builder(MarshallingType.SDK_POJO)
            .memberName("MemberId").getter(getter(IsMemberInGroupsRequest::memberId)).setter(setter(Builder::memberId))
            .constructor(MemberId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupIds")
            .getter(getter(IsMemberInGroupsRequest::groupIds))
            .setter(setter(Builder::groupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            MEMBER_ID_FIELD, GROUP_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityStoreId;

    private final MemberId memberId;

    private final List<String> groupIds;

    private IsMemberInGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.memberId = builder.memberId;
        this.groupIds = builder.groupIds;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * An object containing the identifier of a group member.
     * </p>
     * 
     * @return An object containing the identifier of a group member.
     */
    public final MemberId memberId() {
        return memberId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupIds() {
        return groupIds != null && !(groupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for groups in the identity store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupIds} method.
     * </p>
     * 
     * @return A list of identifiers for groups in the identity store.
     */
    public final List<String> groupIds() {
        return groupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupIds() ? groupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsMemberInGroupsRequest)) {
            return false;
        }
        IsMemberInGroupsRequest other = (IsMemberInGroupsRequest) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId()) && Objects.equals(memberId(), other.memberId())
                && hasGroupIds() == other.hasGroupIds() && Objects.equals(groupIds(), other.groupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsMemberInGroupsRequest").add("IdentityStoreId", identityStoreId()).add("MemberId", memberId())
                .add("GroupIds", hasGroupIds() ? groupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "GroupIds":
            return Optional.ofNullable(clazz.cast(groupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("GroupIds", GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsMemberInGroupsRequest, T> g) {
        return obj -> g.apply((IsMemberInGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IdentitystoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, IsMemberInGroupsRequest> {
        /**
         * <p>
         * The globally unique identifier for the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The globally unique identifier for the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * An object containing the identifier of a group member.
         * </p>
         * 
         * @param memberId
         *        An object containing the identifier of a group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(MemberId memberId);

        /**
         * <p>
         * An object containing the identifier of a group member.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberId.Builder} avoiding the need to
         * create one manually via {@link MemberId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemberId.Builder#build()} is called immediately and its result is
         * passed to {@link #memberId(MemberId)}.
         * 
         * @param memberId
         *        a consumer that will call methods on {@link MemberId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberId(MemberId)
         */
        default Builder memberId(Consumer<MemberId.Builder> memberId) {
            return memberId(MemberId.builder().applyMutation(memberId).build());
        }

        /**
         * <p>
         * A list of identifiers for groups in the identity store.
         * </p>
         * 
         * @param groupIds
         *        A list of identifiers for groups in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * A list of identifiers for groups in the identity store.
         * </p>
         * 
         * @param groupIds
         *        A list of identifiers for groups in the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IdentitystoreRequest.BuilderImpl implements Builder {
        private String identityStoreId;

        private MemberId memberId;

        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IsMemberInGroupsRequest model) {
            super(model);
            identityStoreId(model.identityStoreId);
            memberId(model.memberId);
            groupIds(model.groupIds);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return memberId != null ? memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Collection<String> getGroupIds() {
            if (groupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return groupIds;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdsCopier.copy(groupIds);
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdsCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IsMemberInGroupsRequest build() {
            return new IsMemberInGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
