/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupMembershipRequest
extends IdentitystoreRequest
implements ToCopyableBuilder<Builder, DescribeGroupMembershipRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::identityStoreId)).setter(DescribeGroupMembershipRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MembershipId").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::membershipId)).setter(DescribeGroupMembershipRequest.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, MEMBERSHIP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGroupMembershipRequest.memberNameToFieldInitializer();
    private final String identityStoreId;
    private final String membershipId;

    private DescribeGroupMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.membershipId = builder.membershipId;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupMembershipRequest)) {
            return false;
        }
        DescribeGroupMembershipRequest other = (DescribeGroupMembershipRequest)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.membershipId(), other.membershipId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupMembershipRequest").add("IdentityStoreId", (Object)this.identityStoreId()).add("MembershipId", (Object)this.membershipId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "MembershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("MembershipId", MEMBERSHIP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupMembershipRequest, T> g) {
        return obj -> g.apply((DescribeGroupMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreRequest.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private String membershipId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupMembershipRequest model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.membershipId(model.membershipId);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupMembershipRequest build() {
            return new DescribeGroupMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IdentitystoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupMembershipRequest> {
        public Builder identityStoreId(String var1);

        public Builder membershipId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

