/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * The Identity Store service used by IAM Identity Center provides a single place to retrieve all of your identities
 * (users and groups). For more information, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html"> IAM Identity Center User Guide</a>.
 * </p>
 * <p>
 * This reference guide describes the identity store operations that you can call programmatically and includes detailed
 * information about data types and errors.
 * </p>
 * <note>
 * <p>
 * IAM Identity Center uses the <code>sso</code>, <code>sso-directory</code>, and <code>identitystore</code> API
 * namespaces. The <code>sso-directory</code> and <code>identitystore</code> namespaces authorize access to data in the
 * Identity Store. Make sure your policies with IAM actions from these two namespaces are consistent to avoid
 * conflicting authorization to the same data.
 * </p>
 * </note>
 */
package software.amazon.awssdk.services.identitystore;