/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    KMS_INVALID_ARN("KMS_INVALID_ARN"),
    KMS_INVALID_KEY_USAGE("KMS_INVALID_KEY_USAGE"),
    KMS_INVALID_STATE("KMS_INVALID_STATE"),
    KMS_DISABLED("KMS_DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

