/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInfrastructureConfigurationsResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListInfrastructureConfigurationsResponse.Builder, ListInfrastructureConfigurationsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListInfrastructureConfigurationsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<InfrastructureConfigurationSummary>> INFRASTRUCTURE_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField
            .<List<InfrastructureConfigurationSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListInfrastructureConfigurationsResponse::infrastructureConfigurationSummaryList))
            .setter(setter(Builder::infrastructureConfigurationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("infrastructureConfigurationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InfrastructureConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InfrastructureConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListInfrastructureConfigurationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            INFRASTRUCTURE_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String requestIdValue;

    private final List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList;

    private final String nextToken;

    private ListInfrastructureConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.infrastructureConfigurationSummaryList = builder.infrastructureConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The list of infrastructure configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of infrastructure configurations.
     */
    public List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList() {
        return infrastructureConfigurationSummaryList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this is not empty then there are additional elements that the
     * service that not include in this request. Use this token with the next request to retrieve additional object.
     * </p>
     * 
     * @return The next token used for paginated responses. When this is not empty then there are additional elements
     *         that the service that not include in this request. Use this token with the next request to retrieve
     *         additional object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInfrastructureConfigurationsResponse)) {
            return false;
        }
        ListInfrastructureConfigurationsResponse other = (ListInfrastructureConfigurationsResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(infrastructureConfigurationSummaryList(), other.infrastructureConfigurationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInfrastructureConfigurationsResponse").add("RequestId", requestId())
                .add("InfrastructureConfigurationSummaryList", infrastructureConfigurationSummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "infrastructureConfigurationSummaryList":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInfrastructureConfigurationsResponse, T> g) {
        return obj -> g.apply((ListInfrastructureConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInfrastructureConfigurationsResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The list of infrastructure configurations.
         * </p>
         * 
         * @param infrastructureConfigurationSummaryList
         *        The list of infrastructure configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationSummaryList(
                Collection<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList);

        /**
         * <p>
         * The list of infrastructure configurations.
         * </p>
         * 
         * @param infrastructureConfigurationSummaryList
         *        The list of infrastructure configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationSummaryList(
                InfrastructureConfigurationSummary... infrastructureConfigurationSummaryList);

        /**
         * <p>
         * The list of infrastructure configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <InfrastructureConfigurationSummary>.Builder} avoiding the need to create one manually via {@link List
         * <InfrastructureConfigurationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InfrastructureConfigurationSummary>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #infrastructureConfigurationSummaryList(List<InfrastructureConfigurationSummary>)}.
         * 
         * @param infrastructureConfigurationSummaryList
         *        a consumer that will call methods on {@link List<InfrastructureConfigurationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infrastructureConfigurationSummaryList(List<InfrastructureConfigurationSummary>)
         */
        Builder infrastructureConfigurationSummaryList(
                Consumer<InfrastructureConfigurationSummary.Builder>... infrastructureConfigurationSummaryList);

        /**
         * <p>
         * The next token used for paginated responses. When this is not empty then there are additional elements that
         * the service that not include in this request. Use this token with the next request to retrieve additional
         * object.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this is not empty then there are additional elements
         *        that the service that not include in this request. Use this token with the next request to retrieve
         *        additional object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInfrastructureConfigurationsResponse model) {
            super(model);
            requestId(model.requestIdValue);
            infrastructureConfigurationSummaryList(model.infrastructureConfigurationSummaryList);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<InfrastructureConfigurationSummary.Builder> getInfrastructureConfigurationSummaryList() {
            return infrastructureConfigurationSummaryList != null ? infrastructureConfigurationSummaryList.stream()
                    .map(InfrastructureConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder infrastructureConfigurationSummaryList(
                Collection<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList = InfrastructureConfigurationSummaryListCopier
                    .copy(infrastructureConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder infrastructureConfigurationSummaryList(
                InfrastructureConfigurationSummary... infrastructureConfigurationSummaryList) {
            infrastructureConfigurationSummaryList(Arrays.asList(infrastructureConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder infrastructureConfigurationSummaryList(
                Consumer<InfrastructureConfigurationSummary.Builder>... infrastructureConfigurationSummaryList) {
            infrastructureConfigurationSummaryList(Stream.of(infrastructureConfigurationSummaryList)
                    .map(c -> InfrastructureConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInfrastructureConfigurationSummaryList(
                Collection<InfrastructureConfigurationSummary.BuilderImpl> infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList = InfrastructureConfigurationSummaryListCopier
                    .copyFromBuilder(infrastructureConfigurationSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInfrastructureConfigurationsResponse build() {
            return new ListInfrastructureConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
