/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an EC2 AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ami implements SdkPojo, Serializable, ToCopyableBuilder<Ami.Builder, Ami> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ami::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ami::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ami::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Ami::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ImageState> STATE_FIELD = SdkField.<ImageState> builder(MarshallingType.SDK_POJO)
            .getter(getter(Ami::state)).setter(setter(Builder::state)).constructor(ImageState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, IMAGE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String image;

    private final String name;

    private final String description;

    private final ImageState state;

    private Ami(BuilderImpl builder) {
        this.region = builder.region;
        this.image = builder.image;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
    }

    /**
     * <p>
     * The region of the EC2 AMI.
     * </p>
     * 
     * @return The region of the EC2 AMI.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The AMI ID of the EC2 AMI.
     * </p>
     * 
     * @return The AMI ID of the EC2 AMI.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The name of the EC2 AMI.
     * </p>
     * 
     * @return The name of the EC2 AMI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the EC2 AMI.
     * </p>
     * 
     * @return The description of the EC2 AMI.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the State property for this object.
     * 
     * @return The value of the State property for this object.
     */
    public ImageState state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ami)) {
            return false;
        }
        Ami other = (Ami) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(image(), other.image())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Ami").add("Region", region()).add("Image", image()).add("Name", name())
                .add("Description", description()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ami, T> g) {
        return obj -> g.apply((Ami) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ami> {
        /**
         * <p>
         * The region of the EC2 AMI.
         * </p>
         * 
         * @param region
         *        The region of the EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The AMI ID of the EC2 AMI.
         * </p>
         * 
         * @param image
         *        The AMI ID of the EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The name of the EC2 AMI.
         * </p>
         * 
         * @param name
         *        The name of the EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the EC2 AMI.
         * </p>
         * 
         * @param description
         *        The description of the EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ImageState state);

        /**
         * Sets the value of the State property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImageState.Builder} avoiding the need to create
         * one manually via {@link ImageState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageState.Builder#build()} is called immediately and its result
         * is passed to {@link #state(ImageState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ImageState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ImageState)
         */
        default Builder state(Consumer<ImageState.Builder> state) {
            return state(ImageState.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String image;

        private String name;

        private String description;

        private ImageState state;

        private BuilderImpl() {
        }

        private BuilderImpl(Ami model) {
            region(model.region);
            image(model.image);
            name(model.name);
            description(model.description);
            state(model.state);
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public Ami build() {
            return new Ami(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
