/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInfrastructureConfigurationRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateInfrastructureConfigurationRequest.Builder, CreateInfrastructureConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateInfrastructureConfigurationRequest::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::instanceProfileName))
            .setter(setter(Builder::instanceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileName").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateInfrastructureConfigurationRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateInfrastructureConfigurationRequest::logging)).setter(setter(Builder::logging))
            .constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::keyPair)).setter(setter(Builder::keyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCE_ON_FAILURE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateInfrastructureConfigurationRequest::terminateInstanceOnFailure))
            .setter(setter(Builder::terminateInstanceOnFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateInstanceOnFailure").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateInfrastructureConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInfrastructureConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INSTANCE_TYPES_FIELD, INSTANCE_PROFILE_NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, LOGGING_FIELD,
            KEY_PAIR_FIELD, TERMINATE_INSTANCE_ON_FAILURE_FIELD, SNS_TOPIC_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String description;

    private final List<String> instanceTypes;

    private final String instanceProfileName;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final Logging logging;

    private final String keyPair;

    private final Boolean terminateInstanceOnFailure;

    private final String snsTopicArn;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateInfrastructureConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.instanceTypes = builder.instanceTypes;
        this.instanceProfileName = builder.instanceProfileName;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.logging = builder.logging;
        this.keyPair = builder.keyPair;
        this.terminateInstanceOnFailure = builder.terminateInstanceOnFailure;
        this.snsTopicArn = builder.snsTopicArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the infrastructure configuration.
     * </p>
     * 
     * @return The name of the infrastructure configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the infrastructure configuration.
     * </p>
     * 
     * @return The description of the infrastructure configuration.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The instance types of the infrastructure configuration. You may specify one or more instance types to use for
     * this build, the service will pick one of these instance types based on availability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance types of the infrastructure configuration. You may specify one or more instance types to use
     *         for this build, the service will pick one of these instance types based on availability.
     */
    public List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * The instance profile to associate with the instance used to customize your EC2 AMI.
     * </p>
     * 
     * @return The instance profile to associate with the instance used to customize your EC2 AMI.
     */
    public String instanceProfileName() {
        return instanceProfileName;
    }

    /**
     * <p>
     * The security group IDs to associate with the instance used to customize your EC2 AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security group IDs to associate with the instance used to customize your EC2 AMI.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID to place the instance used to customize your EC2 AMI in.
     * </p>
     * 
     * @return The subnet ID to place the instance used to customize your EC2 AMI in.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The logging configuration of the infrastructure configuration.
     * </p>
     * 
     * @return The logging configuration of the infrastructure configuration.
     */
    public Logging logging() {
        return logging;
    }

    /**
     * <p>
     * The key pair of the infrastructure configuration. This can be used to log onto and debug the instance used to
     * create your image.
     * </p>
     * 
     * @return The key pair of the infrastructure configuration. This can be used to log onto and debug the instance
     *         used to create your image.
     */
    public String keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * The terminate instance on failure setting of the infrastructure configuration. Set to false if you wish for Image
     * Builder to retain the instance used to configure your AMI in the event that the build or test phase of your
     * workflow failed.
     * </p>
     * 
     * @return The terminate instance on failure setting of the infrastructure configuration. Set to false if you wish
     *         for Image Builder to retain the instance used to configure your AMI in the event that the build or test
     *         phase of your workflow failed.
     */
    public Boolean terminateInstanceOnFailure() {
        return terminateInstanceOnFailure;
    }

    /**
     * <p>
     * The SNS topic on which to send image build events.
     * </p>
     * 
     * @return The SNS topic on which to send image build events.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The tags of the infrastructure configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags of the infrastructure configuration.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The idempotency token used to make this request idempotent.
     * </p>
     * 
     * @return The idempotency token used to make this request idempotent.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstanceOnFailure());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInfrastructureConfigurationRequest)) {
            return false;
        }
        CreateInfrastructureConfigurationRequest other = (CreateInfrastructureConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(instanceProfileName(), other.instanceProfileName())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(logging(), other.logging()) && Objects.equals(keyPair(), other.keyPair())
                && Objects.equals(terminateInstanceOnFailure(), other.terminateInstanceOnFailure())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateInfrastructureConfigurationRequest").add("Name", name()).add("Description", description())
                .add("InstanceTypes", instanceTypes()).add("InstanceProfileName", instanceProfileName())
                .add("SecurityGroupIds", securityGroupIds()).add("SubnetId", subnetId()).add("Logging", logging())
                .add("KeyPair", keyPair()).add("TerminateInstanceOnFailure", terminateInstanceOnFailure())
                .add("SnsTopicArn", snsTopicArn()).add("Tags", tags()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "instanceProfileName":
            return Optional.ofNullable(clazz.cast(instanceProfileName()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "terminateInstanceOnFailure":
            return Optional.ofNullable(clazz.cast(terminateInstanceOnFailure()));
        case "snsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInfrastructureConfigurationRequest, T> g) {
        return obj -> g.apply((CreateInfrastructureConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInfrastructureConfigurationRequest> {
        /**
         * <p>
         * The name of the infrastructure configuration.
         * </p>
         * 
         * @param name
         *        The name of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the infrastructure configuration.
         * </p>
         * 
         * @param description
         *        The description of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The instance types of the infrastructure configuration. You may specify one or more instance types to use for
         * this build, the service will pick one of these instance types based on availability.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types of the infrastructure configuration. You may specify one or more instance types to
         *        use for this build, the service will pick one of these instance types based on availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * The instance types of the infrastructure configuration. You may specify one or more instance types to use for
         * this build, the service will pick one of these instance types based on availability.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types of the infrastructure configuration. You may specify one or more instance types to
         *        use for this build, the service will pick one of these instance types based on availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The instance profile to associate with the instance used to customize your EC2 AMI.
         * </p>
         * 
         * @param instanceProfileName
         *        The instance profile to associate with the instance used to customize your EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileName(String instanceProfileName);

        /**
         * <p>
         * The security group IDs to associate with the instance used to customize your EC2 AMI.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs to associate with the instance used to customize your EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security group IDs to associate with the instance used to customize your EC2 AMI.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs to associate with the instance used to customize your EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID to place the instance used to customize your EC2 AMI in.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID to place the instance used to customize your EC2 AMI in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The logging configuration of the infrastructure configuration.
         * </p>
         * 
         * @param logging
         *        The logging configuration of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * The logging configuration of the infrastructure configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link Logging.Builder} avoiding the need to create one
         * manually via {@link Logging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * The key pair of the infrastructure configuration. This can be used to log onto and debug the instance used to
         * create your image.
         * </p>
         * 
         * @param keyPair
         *        The key pair of the infrastructure configuration. This can be used to log onto and debug the instance
         *        used to create your image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(String keyPair);

        /**
         * <p>
         * The terminate instance on failure setting of the infrastructure configuration. Set to false if you wish for
         * Image Builder to retain the instance used to configure your AMI in the event that the build or test phase of
         * your workflow failed.
         * </p>
         * 
         * @param terminateInstanceOnFailure
         *        The terminate instance on failure setting of the infrastructure configuration. Set to false if you
         *        wish for Image Builder to retain the instance used to configure your AMI in the event that the build
         *        or test phase of your workflow failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure);

        /**
         * <p>
         * The SNS topic on which to send image build events.
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic on which to send image build events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The tags of the infrastructure configuration.
         * </p>
         * 
         * @param tags
         *        The tags of the infrastructure configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The idempotency token used to make this request idempotent.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used to make this request idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String instanceProfileName;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private Logging logging;

        private String keyPair;

        private Boolean terminateInstanceOnFailure;

        private String snsTopicArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInfrastructureConfigurationRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            instanceTypes(model.instanceTypes);
            instanceProfileName(model.instanceProfileName);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            logging(model.logging);
            keyPair(model.keyPair);
            terminateInstanceOnFailure(model.terminateInstanceOnFailure);
            snsTopicArn(model.snsTopicArn);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getInstanceTypes() {
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final String getInstanceProfileName() {
            return instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getKeyPair() {
            return keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final Boolean getTerminateInstanceOnFailure() {
            return terminateInstanceOnFailure;
        }

        @Override
        public final Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        public final void setTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInfrastructureConfigurationRequest build() {
            return new CreateInfrastructureConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
