/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDistributionConfigurationRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<UpdateDistributionConfigurationRequest.Builder, UpdateDistributionConfigurationRequest> {
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDistributionConfigurationRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDistributionConfigurationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Distribution>> DISTRIBUTIONS_FIELD = SdkField
            .<List<Distribution>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDistributionConfigurationRequest::distributions))
            .setter(setter(Builder::distributions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Distribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(Distribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDistributionConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISTRIBUTION_CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, DISTRIBUTIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final String distributionConfigurationArn;

    private final String description;

    private final List<Distribution> distributions;

    private final String clientToken;

    private UpdateDistributionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.description = builder.description;
        this.distributions = builder.distributions;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that you wish to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that you wish to update.
     */
    public String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    /**
     * <p>
     * The description of the distribution configuration.
     * </p>
     * 
     * @return The description of the distribution configuration.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Distributions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDistributions() {
        return distributions != null && !(distributions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The distributions of the distribution configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDistributions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The distributions of the distribution configuration.
     */
    public List<Distribution> distributions() {
        return distributions;
    }

    /**
     * <p>
     * The idempotency token of the distribution configuration.
     * </p>
     * 
     * @return The idempotency token of the distribution configuration.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(distributions());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionConfigurationRequest)) {
            return false;
        }
        UpdateDistributionConfigurationRequest other = (UpdateDistributionConfigurationRequest) obj;
        return Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn())
                && Objects.equals(description(), other.description()) && Objects.equals(distributions(), other.distributions())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDistributionConfigurationRequest")
                .add("DistributionConfigurationArn", distributionConfigurationArn()).add("Description", description())
                .add("Distributions", distributions()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "distributions":
            return Optional.ofNullable(clazz.cast(distributions()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDistributionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDistributionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that you wish to update.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        /**
         * <p>
         * The description of the distribution configuration.
         * </p>
         * 
         * @param description
         *        The description of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * 
         * @param distributions
         *        The distributions of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(Collection<Distribution> distributions);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * 
         * @param distributions
         *        The distributions of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(Distribution... distributions);

        /**
         * <p>
         * The distributions of the distribution configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Distribution>.Builder} avoiding the need to
         * create one manually via {@link List<Distribution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Distribution>.Builder#build()} is called immediately and its
         * result is passed to {@link #distributions(List<Distribution>)}.
         * 
         * @param distributions
         *        a consumer that will call methods on {@link List<Distribution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributions(List<Distribution>)
         */
        Builder distributions(Consumer<Distribution.Builder>... distributions);

        /**
         * <p>
         * The idempotency token of the distribution configuration.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token of the distribution configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String distributionConfigurationArn;

        private String description;

        private List<Distribution> distributions = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionConfigurationRequest model) {
            super(model);
            distributionConfigurationArn(model.distributionConfigurationArn);
            description(model.description);
            distributions(model.distributions);
            clientToken(model.clientToken);
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Distribution.Builder> getDistributions() {
            return distributions != null ? distributions.stream().map(Distribution::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder distributions(Collection<Distribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Distribution... distributions) {
            distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<Distribution.Builder>... distributions) {
            distributions(Stream.of(distributions).map(c -> Distribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDistributions(Collection<Distribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionConfigurationRequest build() {
            return new UpdateDistributionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
