/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionConfigurationsResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListDistributionConfigurationsResponse.Builder, ListDistributionConfigurationsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDistributionConfigurationsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<DistributionConfigurationSummary>> DISTRIBUTION_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField
            .<List<DistributionConfigurationSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDistributionConfigurationsResponse::distributionConfigurationSummaryList))
            .setter(setter(Builder::distributionConfigurationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("distributionConfigurationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DistributionConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DistributionConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDistributionConfigurationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            DISTRIBUTION_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String requestIdValue;

    private final List<DistributionConfigurationSummary> distributionConfigurationSummaryList;

    private final String nextToken;

    private ListDistributionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfigurationSummaryList = builder.distributionConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public String requestId() {
        return requestIdValue;
    }

    /**
     * Returns true if the DistributionConfigurationSummaryList property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasDistributionConfigurationSummaryList() {
        return distributionConfigurationSummaryList != null
                && !(distributionConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of distributions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDistributionConfigurationSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of distributions.
     */
    public List<DistributionConfigurationSummary> distributionConfigurationSummaryList() {
        return distributionConfigurationSummaryList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this is not empty then there are additional elements that the
     * service that not include in this request. Use this token with the next request to retrieve additional object.
     * </p>
     * 
     * @return The next token used for paginated responses. When this is not empty then there are additional elements
     *         that the service that not include in this request. Use this token with the next request to retrieve
     *         additional object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionConfigurationsResponse)) {
            return false;
        }
        ListDistributionConfigurationsResponse other = (ListDistributionConfigurationsResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(distributionConfigurationSummaryList(), other.distributionConfigurationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDistributionConfigurationsResponse").add("RequestId", requestId())
                .add("DistributionConfigurationSummaryList", distributionConfigurationSummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "distributionConfigurationSummaryList":
            return Optional.ofNullable(clazz.cast(distributionConfigurationSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionConfigurationsResponse, T> g) {
        return obj -> g.apply((ListDistributionConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionConfigurationsResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The list of distributions.
         * </p>
         * 
         * @param distributionConfigurationSummaryList
         *        The list of distributions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationSummaryList(
                Collection<DistributionConfigurationSummary> distributionConfigurationSummaryList);

        /**
         * <p>
         * The list of distributions.
         * </p>
         * 
         * @param distributionConfigurationSummaryList
         *        The list of distributions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationSummaryList(DistributionConfigurationSummary... distributionConfigurationSummaryList);

        /**
         * <p>
         * The list of distributions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DistributionConfigurationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<DistributionConfigurationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DistributionConfigurationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #distributionConfigurationSummaryList(List<DistributionConfigurationSummary>)}.
         * 
         * @param distributionConfigurationSummaryList
         *        a consumer that will call methods on {@link List<DistributionConfigurationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfigurationSummaryList(List<DistributionConfigurationSummary>)
         */
        Builder distributionConfigurationSummaryList(
                Consumer<DistributionConfigurationSummary.Builder>... distributionConfigurationSummaryList);

        /**
         * <p>
         * The next token used for paginated responses. When this is not empty then there are additional elements that
         * the service that not include in this request. Use this token with the next request to retrieve additional
         * object.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this is not empty then there are additional elements
         *        that the service that not include in this request. Use this token with the next request to retrieve
         *        additional object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<DistributionConfigurationSummary> distributionConfigurationSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionConfigurationsResponse model) {
            super(model);
            requestId(model.requestIdValue);
            distributionConfigurationSummaryList(model.distributionConfigurationSummaryList);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<DistributionConfigurationSummary.Builder> getDistributionConfigurationSummaryList() {
            return distributionConfigurationSummaryList != null ? distributionConfigurationSummaryList.stream()
                    .map(DistributionConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder distributionConfigurationSummaryList(
                Collection<DistributionConfigurationSummary> distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList = DistributionConfigurationSummaryListCopier
                    .copy(distributionConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionConfigurationSummaryList(
                DistributionConfigurationSummary... distributionConfigurationSummaryList) {
            distributionConfigurationSummaryList(Arrays.asList(distributionConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionConfigurationSummaryList(
                Consumer<DistributionConfigurationSummary.Builder>... distributionConfigurationSummaryList) {
            distributionConfigurationSummaryList(Stream.of(distributionConfigurationSummaryList)
                    .map(c -> DistributionConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDistributionConfigurationSummaryList(
                Collection<DistributionConfigurationSummary.BuilderImpl> distributionConfigurationSummaryList) {
            this.distributionConfigurationSummaryList = DistributionConfigurationSummaryListCopier
                    .copyFromBuilder(distributionConfigurationSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDistributionConfigurationsResponse build() {
            return new ListDistributionConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
