/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutImageRecipePolicyRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<PutImageRecipePolicyRequest.Builder, PutImageRecipePolicyRequest> {
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutImageRecipePolicyRequest::imageRecipeArn)).setter(setter(Builder::imageRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutImageRecipePolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_RECIPE_ARN_FIELD,
            POLICY_FIELD));

    private final String imageRecipeArn;

    private final String policy;

    private PutImageRecipePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.imageRecipeArn = builder.imageRecipeArn;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.
     */
    public String imageRecipeArn() {
        return imageRecipeArn;
    }

    /**
     * <p>
     * The policy to apply.
     * </p>
     * 
     * @return The policy to apply.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageRecipePolicyRequest)) {
            return false;
        }
        PutImageRecipePolicyRequest other = (PutImageRecipePolicyRequest) obj;
        return Objects.equals(imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutImageRecipePolicyRequest").add("ImageRecipeArn", imageRecipeArn()).add("Policy", policy())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageRecipeArn":
            return Optional.ofNullable(clazz.cast(imageRecipeArn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutImageRecipePolicyRequest, T> g) {
        return obj -> g.apply((PutImageRecipePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutImageRecipePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.
         * </p>
         * 
         * @param imageRecipeArn
         *        The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRecipeArn(String imageRecipeArn);

        /**
         * <p>
         * The policy to apply.
         * </p>
         * 
         * @param policy
         *        The policy to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String imageRecipeArn;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageRecipePolicyRequest model) {
            super(model);
            imageRecipeArn(model.imageRecipeArn);
            policy(model.policy);
        }

        public final String getImageRecipeArn() {
            return imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutImageRecipePolicyRequest build() {
            return new PutImageRecipePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
