/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Elastic Compute Cloud Image Builder provides a one-stop-shop to automate the image management processes. You
 * configure an automated pipeline that creates images for use on AWS. As software updates become available, Image
 * Builder automatically produces a new image based on a customizable schedule and distributes it to stipulated AWS
 * Regions after running tests on it. With the Image Builder, organizations can capture their internal or
 * industry-specific compliance policies as a vetted template that can be consistently applied to every new image.
 * Built-in integration with AWS Organizations provides customers with a centralized way to enforce image distribution
 * and access policies across their AWS accounts and Regions. Image Builder supports multiple image format AMIs on AWS.
 * </p>
 */
package software.amazon.awssdk.services.imagebuilder;