/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDistributionConfigurationRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<DeleteDistributionConfigurationRequest.Builder, DeleteDistributionConfigurationRequest> {
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDistributionConfigurationRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISTRIBUTION_CONFIGURATION_ARN_FIELD));

    private final String distributionConfigurationArn;

    private DeleteDistributionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration to delete.
     */
    public String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDistributionConfigurationRequest)) {
            return false;
        }
        DeleteDistributionConfigurationRequest other = (DeleteDistributionConfigurationRequest) obj;
        return Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDistributionConfigurationRequest")
                .add("DistributionConfigurationArn", distributionConfigurationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDistributionConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteDistributionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDistributionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration to delete.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String distributionConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDistributionConfigurationRequest model) {
            super(model);
            distributionConfigurationArn(model.distributionConfigurationArn);
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDistributionConfigurationRequest build() {
            return new DeleteDistributionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
