/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateComponentRequest.Builder, CreateComponentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::semanticVersion)).setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::changeDescription)).setter(setter(Builder::changeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateComponentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, PLATFORM_FIELD, DATA_FIELD, URI_FIELD,
            KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String semanticVersion;

    private final String description;

    private final String changeDescription;

    private final String platform;

    private final String data;

    private final String uri;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.platform = builder.platform;
        this.data = builder.data;
        this.uri = builder.uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version of the component. This version to follow the semantic version syntax. i.e.
     * major.minor.patch. This could be versioned like software 2.0.1 or date like 2019.12.01.
     * </p>
     * 
     * @return The semantic version of the component. This version to follow the semantic version syntax. i.e.
     *         major.minor.patch. This could be versioned like software 2.0.1 or date like 2019.12.01.
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * CThe description of the component. Describes the contents of the component.
     * </p>
     * 
     * @return CThe description of the component. Describes the contents of the component.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * CThe change description of the component. Describes what change has been made in this version. In other words
     * what makes this version different from other versions of this component.
     * </p>
     * 
     * @return CThe change description of the component. Describes what change has been made in this version. In other
     *         words what makes this version different from other versions of this component.
     */
    public String changeDescription() {
        return changeDescription;
    }

    /**
     * <p>
     * CThe platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return CThe platform of the component.
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * CThe platform of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return CThe platform of the component.
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * CThe data of the component.
     * </p>
     * 
     * @return CThe data of the component.
     */
    public String data() {
        return data;
    }

    /**
     * <p>
     * CThe uri of the component.
     * </p>
     * 
     * @return CThe uri of the component.
     */
    public String uri() {
        return uri;
    }

    /**
     * <p>
     * The ID of the KMS key that should be used to encrypt this component.
     * </p>
     * 
     * @return The ID of the KMS key that should be used to encrypt this component.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * CThe tags of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return CThe tags of the component.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * CThe idempotency token of the component.
     * </p>
     * 
     * @return CThe idempotency token of the component.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(changeDescription(), other.changeDescription())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(data(), other.data())
                && Objects.equals(uri(), other.uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateComponentRequest").add("Name", name()).add("SemanticVersion", semanticVersion())
                .add("Description", description()).add("ChangeDescription", changeDescription())
                .add("Platform", platformAsString()).add("Data", data()).add("Uri", uri()).add("KmsKeyId", kmsKeyId())
                .add("Tags", tags()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "changeDescription":
            return Optional.ofNullable(clazz.cast(changeDescription()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComponentRequest> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param name
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version of the component. This version to follow the semantic version syntax. i.e.
         * major.minor.patch. This could be versioned like software 2.0.1 or date like 2019.12.01.
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the component. This version to follow the semantic version syntax. i.e.
         *        major.minor.patch. This could be versioned like software 2.0.1 or date like 2019.12.01.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * CThe description of the component. Describes the contents of the component.
         * </p>
         * 
         * @param description
         *        CThe description of the component. Describes the contents of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * CThe change description of the component. Describes what change has been made in this version. In other words
         * what makes this version different from other versions of this component.
         * </p>
         * 
         * @param changeDescription
         *        CThe change description of the component. Describes what change has been made in this version. In
         *        other words what makes this version different from other versions of this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDescription(String changeDescription);

        /**
         * <p>
         * CThe platform of the component.
         * </p>
         * 
         * @param platform
         *        CThe platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * CThe platform of the component.
         * </p>
         * 
         * @param platform
         *        CThe platform of the component.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * CThe data of the component.
         * </p>
         * 
         * @param data
         *        CThe data of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * CThe uri of the component.
         * </p>
         * 
         * @param uri
         *        CThe uri of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The ID of the KMS key that should be used to encrypt this component.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key that should be used to encrypt this component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * CThe tags of the component.
         * </p>
         * 
         * @param tags
         *        CThe tags of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * CThe idempotency token of the component.
         * </p>
         * 
         * @param clientToken
         *        CThe idempotency token of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private String description;

        private String changeDescription;

        private String platform;

        private String data;

        private String uri;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            name(model.name);
            semanticVersion(model.semanticVersion);
            description(model.description);
            changeDescription(model.changeDescription);
            platform(model.platform);
            data(model.data);
            uri(model.uri);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getChangeDescription() {
            return changeDescription;
        }

        @Override
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
