/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A schedule configures how often and when a pipeline will automatically create a new image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::scheduleExpression)).setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> PIPELINE_EXECUTION_START_CONDITION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Schedule::pipelineExecutionStartConditionAsString))
            .setter(setter(Builder::pipelineExecutionStartCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionStartCondition")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            PIPELINE_EXECUTION_START_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final String pipelineExecutionStartCondition;

    private Schedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.pipelineExecutionStartCondition = builder.pipelineExecutionStartCondition;
    }

    /**
     * <p>
     * The expression determines how often EC2 Image Builder evaluates your <code>pipelineExecutionStartCondition</code>
     * .
     * </p>
     * 
     * @return The expression determines how often EC2 Image Builder evaluates your
     *         <code>pipelineExecutionStartCondition</code>.
     */
    public String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The condition configures when the pipeline should trigger a new image build. When the
     * <code>pipelineExecutionStartCondition</code> is set to
     * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image only
     * when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new
     * image every time the CRON expression matches the current time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStartCondition} will return
     * {@link PipelineExecutionStartCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pipelineExecutionStartConditionAsString}.
     * </p>
     * 
     * @return The condition configures when the pipeline should trigger a new image build. When the
     *         <code>pipelineExecutionStartCondition</code> is set to
     *         <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image
     *         only when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will
     *         build a new image every time the CRON expression matches the current time.
     * @see PipelineExecutionStartCondition
     */
    public PipelineExecutionStartCondition pipelineExecutionStartCondition() {
        return PipelineExecutionStartCondition.fromValue(pipelineExecutionStartCondition);
    }

    /**
     * <p>
     * The condition configures when the pipeline should trigger a new image build. When the
     * <code>pipelineExecutionStartCondition</code> is set to
     * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image only
     * when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new
     * image every time the CRON expression matches the current time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStartCondition} will return
     * {@link PipelineExecutionStartCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pipelineExecutionStartConditionAsString}.
     * </p>
     * 
     * @return The condition configures when the pipeline should trigger a new image build. When the
     *         <code>pipelineExecutionStartCondition</code> is set to
     *         <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image
     *         only when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will
     *         build a new image every time the CRON expression matches the current time.
     * @see PipelineExecutionStartCondition
     */
    public String pipelineExecutionStartConditionAsString() {
        return pipelineExecutionStartCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionStartConditionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(pipelineExecutionStartConditionAsString(), other.pipelineExecutionStartConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Schedule").add("ScheduleExpression", scheduleExpression())
                .add("PipelineExecutionStartCondition", pipelineExecutionStartConditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "pipelineExecutionStartCondition":
            return Optional.ofNullable(clazz.cast(pipelineExecutionStartConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The expression determines how often EC2 Image Builder evaluates your
         * <code>pipelineExecutionStartCondition</code>.
         * </p>
         * 
         * @param scheduleExpression
         *        The expression determines how often EC2 Image Builder evaluates your
         *        <code>pipelineExecutionStartCondition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The condition configures when the pipeline should trigger a new image build. When the
         * <code>pipelineExecutionStartCondition</code> is set to
         * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image only
         * when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a
         * new image every time the CRON expression matches the current time.
         * </p>
         * 
         * @param pipelineExecutionStartCondition
         *        The condition configures when the pipeline should trigger a new image build. When the
         *        <code>pipelineExecutionStartCondition</code> is set to
         *        <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new
         *        image only when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>,
         *        it will build a new image every time the CRON expression matches the current time.
         * @see PipelineExecutionStartCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStartCondition
         */
        Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition);

        /**
         * <p>
         * The condition configures when the pipeline should trigger a new image build. When the
         * <code>pipelineExecutionStartCondition</code> is set to
         * <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new image only
         * when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a
         * new image every time the CRON expression matches the current time.
         * </p>
         * 
         * @param pipelineExecutionStartCondition
         *        The condition configures when the pipeline should trigger a new image build. When the
         *        <code>pipelineExecutionStartCondition</code> is set to
         *        <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, EC2 Image Builder will build a new
         *        image only when there are known changes pending. When it is set to <code>EXPRESSION_MATCH_ONLY</code>,
         *        it will build a new image every time the CRON expression matches the current time.
         * @see PipelineExecutionStartCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStartCondition
         */
        Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private String pipelineExecutionStartCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            scheduleExpression(model.scheduleExpression);
            pipelineExecutionStartCondition(model.pipelineExecutionStartCondition);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getPipelineExecutionStartConditionAsString() {
            return pipelineExecutionStartCondition;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition(pipelineExecutionStartCondition == null ? null : pipelineExecutionStartCondition
                    .toString());
            return this;
        }

        public final void setPipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
