/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image semantic version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageVersion implements SdkPojo, Serializable, ToCopyableBuilder<ImageVersion.Builder, ImageVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImageVersion::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_FIELD, PLATFORM_FIELD, OWNER_FIELD, DATE_CREATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String version;

    private final String platform;

    private final String owner;

    private final String dateCreated;

    private ImageVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image semantic version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image semantic version.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the image semantic version.
     * </p>
     * 
     * @return The name of the image semantic version.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version of the image semantic version.
     * </p>
     * 
     * @return The semantic version of the image semantic version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The platform of the image semantic version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image semantic version.
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the image semantic version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the image semantic version.
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The owner of the image semantic version.
     * </p>
     * 
     * @return The owner of the image semantic version.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The date at which this image semantic version was created.
     * </p>
     * 
     * @return The date at which this image semantic version was created.
     */
    public String dateCreated() {
        return dateCreated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(owner(), other.owner()) && Objects.equals(dateCreated(), other.dateCreated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImageVersion").add("Arn", arn()).add("Name", name()).add("Version", version())
                .add("Platform", platformAsString()).add("Owner", owner()).add("DateCreated", dateCreated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageVersion> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image semantic version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the image semantic version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the image semantic version.
         * </p>
         * 
         * @param name
         *        The name of the image semantic version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version of the image semantic version.
         * </p>
         * 
         * @param version
         *        The semantic version of the image semantic version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The platform of the image semantic version.
         * </p>
         * 
         * @param platform
         *        The platform of the image semantic version.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the image semantic version.
         * </p>
         * 
         * @param platform
         *        The platform of the image semantic version.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The owner of the image semantic version.
         * </p>
         * 
         * @param owner
         *        The owner of the image semantic version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The date at which this image semantic version was created.
         * </p>
         * 
         * @param dateCreated
         *        The date at which this image semantic version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String version;

        private String platform;

        private String owner;

        private String dateCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            arn(model.arn);
            name(model.name);
            version(model.version);
            platform(model.platform);
            owner(model.owner);
            dateCreated(model.dateCreated);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public ImageVersion build() {
            return new ImageVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
