/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines block device mappings for the instance used to configure your image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceBlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceBlockDeviceMapping.Builder, InstanceBlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceBlockDeviceMapping::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<EbsInstanceBlockDeviceSpecification> EBS_FIELD = SdkField
            .<EbsInstanceBlockDeviceSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(InstanceBlockDeviceMapping::ebs)).setter(setter(Builder::ebs))
            .constructor(EbsInstanceBlockDeviceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebs").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceBlockDeviceMapping::virtualName)).setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualName").build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceBlockDeviceMapping::noDevice)).setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noDevice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD,
            VIRTUAL_NAME_FIELD, NO_DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final EbsInstanceBlockDeviceSpecification ebs;

    private final String virtualName;

    private final String noDevice;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.virtualName = builder.virtualName;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The device to which these mappings apply.
     * </p>
     * 
     * @return The device to which these mappings apply.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Use to manage Amazon EBS-specific configuration for this mapping.
     * </p>
     * 
     * @return Use to manage Amazon EBS-specific configuration for this mapping.
     */
    public EbsInstanceBlockDeviceSpecification ebs() {
        return ebs;
    }

    /**
     * <p>
     * Use to manage instance ephemeral devices.
     * </p>
     * 
     * @return Use to manage instance ephemeral devices.
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * Use to remove a mapping from the parent image.
     * </p>
     * 
     * @return Use to remove a mapping from the parent image.
     */
    public String noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(virtualName(), other.virtualName()) && Objects.equals(noDevice(), other.noDevice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceBlockDeviceMapping").add("DeviceName", deviceName()).add("Ebs", ebs())
                .add("VirtualName", virtualName()).add("NoDevice", noDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "virtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        case "noDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceBlockDeviceMapping, T> g) {
        return obj -> g.apply((InstanceBlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        /**
         * <p>
         * The device to which these mappings apply.
         * </p>
         * 
         * @param deviceName
         *        The device to which these mappings apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Use to manage Amazon EBS-specific configuration for this mapping.
         * </p>
         * 
         * @param ebs
         *        Use to manage Amazon EBS-specific configuration for this mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsInstanceBlockDeviceSpecification ebs);

        /**
         * <p>
         * Use to manage Amazon EBS-specific configuration for this mapping.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsInstanceBlockDeviceSpecification.Builder}
         * avoiding the need to create one manually via {@link EbsInstanceBlockDeviceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsInstanceBlockDeviceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #ebs(EbsInstanceBlockDeviceSpecification)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsInstanceBlockDeviceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsInstanceBlockDeviceSpecification)
         */
        default Builder ebs(Consumer<EbsInstanceBlockDeviceSpecification.Builder> ebs) {
            return ebs(EbsInstanceBlockDeviceSpecification.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Use to manage instance ephemeral devices.
         * </p>
         * 
         * @param virtualName
         *        Use to manage instance ephemeral devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * Use to remove a mapping from the parent image.
         * </p>
         * 
         * @param noDevice
         *        Use to remove a mapping from the parent image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsInstanceBlockDeviceSpecification ebs;

        private String virtualName;

        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            virtualName(model.virtualName);
            noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDeviceSpecification.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDeviceSpecification ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDeviceSpecification.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
